
-- Remanola Novation Launchpad Codec
-- Copyright 2018 Niklas Jakobsson <nico@niconet.se>

-- This file is part of Remanola.

-- Remanola is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- Remanola is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with Remanola.  If not, see <http://www.gnu.org/licenses/>.

DEVICE_ID=0x51

WHITE="ffffff"
HGREY="808080"
DGREY="101010"

RED="ff0000"
HRED="400000"
DRED="100000"

GREEN="00ff00"
HGREEN="004000"
DGREEN="001000"

BLUE="0000ff"
HBLUE="000040"
DBLUE="000010"

YELLOW="ffff00"
HYELLOW="404000"
DYELLOW="101000"

MAGENTA="ff00ff"
HMAGENTA="400040"
DMAGENTA="100010"

CYAN="00ffff"
HCYAN="004040"
DCYAN="001010"

NOCOLOR="000000"

-- Mix colors

ORANGE="ff8000"
HORANGE="402000"
DORANGE="100800"

AMBER="ff4000"
HAMBER="401000"
DAMBER="100500"

GOLD="ffd700"
HGOLD="403500"
DGOLD="100800"

MARINE="7fffd4"
HMARINE="1F4035"
DMARINE="08100d"

CADET="5f9ea0"
HCADET="182829"
DCADET="060a0b"

PINK="ff69b4"
HPINK="401a2d"
DPINK="10070b"

-- Legacy colors
WRED=DRED

WGREEN=DGREEN

--AMBER="ff5515"
WAMBER="401300"

WYELLOW=DYELLOW
YELLOW3="888822"

-- Short name color style
S_RED=5
-- S_WRED=7
S_YELLOW=13
-- S_WYELLOW=15
S_NOCOLOR=0

-- Redrum sequencer
REDRUM_HARD=HRED
REDRUM_MEDIUM=ORANGE
REDRUM_SOFT=YELLOW
REDRUM_HIT=RED
REDRUM_NOHIT=DGREY
-- Thor sequencer
THOR_SEQ_ACTIVE=YELLOW
THOR_SEQ_STEPON=RED
THOR_SEQ_STEPOFF=DGREY

MIDI_OUT_GETVERSION = "f0 00 20 29 00 70 f7"
MIDI_OUT_DEVICEINQ = "f0 7e 7f 06 01 f7"

MIDI_IN_DEVICEINQ_HEAD = "f0 7e 00 06 02 00 20 29"

MIDI_OUT_SCROLL = "f0 00 20 29 02 10 14"
MIDI_OUT_ENDSCROLL = MIDI_OUT_SCROLL.." f7"
MIDI_OUT_PROGLAYOUT = "f0 00 20 29 02 10 2c 03 F7"

MIDI_IN_SCROLLEND = "f0 00 20 29 02 10 15 f7"
MIDI_IN_PROGLAYOUT_STATUS = "f0 00 20 29 02 10 2f 03 F7"


-- brightness={
-- 	[1]="0d",
-- 	[2]="08",
-- 	[3]="04",
-- 	[4]="02",
-- 	[5]="00",
-- }

item_bvmap={
	["Default"]={
		[1]=127,
		[2]=113,
		[3]=100,
		[4]=75,
		[5]=63,
		[6]=40,
		[7]=20,
		[8]=0,
	},
	["MFader"]={
		[1]=63,
		[2]=127,
	},
	["Fader64"]={
		[1]=127,
		[2]=113,
		[3]=100,
		[4]=75,
		[5]=64,
		[6]=40,
		[7]=20,
		[8]=0,
	},
	["MeterSI"]={
		[1]=63,
		[2]=55,
		[3]=48,
		[4]=40,
		[5]=32,
		[6]=24,
		[7]=16,
		[8]=11,
	},
	["Fader VC"]={
		[1]=127,
		[2]=108,
		[3]=89,
		[4]=71,
		[5]=53,
		[6]=36,
		[7]=18,
		[8]=0,
	},
	["BigFader"]={
		[1]=1023,
		[2]=876,
		[3]=751,
		[4]=631,
		[5]=511,
		[6]=340,
		[7]=170,
		[8]=0,
	},
	["Knob V"]={
		[1]=127,
		[2]=111,
		[3]=95,
		[4]=79,
		[5]=47,
		[6]=31,
		[7]=15,
		[8]=0,
	},
	["Knob H"]={
		[1]=127,
		[2]=111,
		[3]=95,
		[4]=79,
		[5]=47,
		[6]=31,
		[7]=15,
		[8]=0,
	},
	["Drawbar"]={
		[1]=0,
		[2]=20,
		[3]=40,
		[4]=63,
		[5]=80,
		[6]=100,
		[7]=113,
		[8]=127,
	},
	["Meter"]={
		[1]=45,
		[2]=39,
		[3]=33,
		[4]=27,
		[5]=21,
		[6]=15,
		[7]=8,
		[8]=1,
	},
	["MeterPeak"]={
		[1]=127,
		[2]=111,
		[3]=95,
		[4]=79,
		[5]=47,
		[6]=31,
		[7]=15,
		[8]=0,
	},
}

button_to_padnote={
	["Button 8-1"]=36,
	["Button 8-2"]=37,
	["Button 8-3"]=38,
	["Button 8-4"]=39,
	["Button 7-1"]=40,
	["Button 7-2"]=41,
	["Button 7-3"]=42,
	["Button 7-4"]=43,
	["Button 6-1"]=44,
	["Button 6-2"]=45,
	["Button 6-3"]=46,
	["Button 6-4"]=47,
	["Button 5-1"]=48,
	["Button 5-2"]=49,
	["Button 5-3"]=50,
	["Button 5-4"]=51,
}

button_to_fullpadnote={
	-- DL
	["Button 8-1"]=36,
	["Button 8-2"]=37,
	["Button 8-3"]=38,
	["Button 8-4"]=39,
	["Button 7-1"]=40,
	["Button 7-2"]=41,
	["Button 7-3"]=42,
	["Button 7-4"]=43,
	["Button 6-1"]=44,
	["Button 6-2"]=45,
	["Button 6-3"]=46,
	["Button 6-4"]=47,
	["Button 5-1"]=48,
	["Button 5-2"]=49,
	["Button 5-3"]=50,
	["Button 5-4"]=51,
	-- UL
	["button 4-1"]=52,
	["button 4-2"]=53,
	["button 4-3"]=54,
	["button 4-4"]=55,
	["button 3-1"]=56,
	["button 3-2"]=57,
	["button 3-3"]=58,
	["button 3-4"]=59,
	["button 2-1"]=60,
	["button 2-2"]=61,
	["button 2-3"]=62,
	["button 2-4"]=63,
	["button 1-1"]=64,
	["button 1-2"]=65,
	["button 1-3"]=66,
	["button 1-4"]=67,
	-- DR
	["Button 8-5"]=68,
	["Button 8-6"]=69,
	["Button 8-7"]=70,
	["Button 8-8"]=71,
	["Button 7-5"]=72,
	["Button 7-6"]=73,
	["Button 7-7"]=74,
	["Button 7-8"]=75,
	["Button 6-5"]=76,
	["Button 6-6"]=77,
	["Button 6-7"]=78,
	["Button 6-8"]=79,
	["Button 5-5"]=80,
	["Button 5-6"]=81,
	["Button 5-7"]=82,
	["Button 5-8"]=83,
	-- UR
	["Button 4-5"]=84,
	["Button 4-6"]=85,
	["Button 4-7"]=86,
	["Button 4-8"]=87,
	["Button 3-5"]=88,
	["Button 3-6"]=89,
	["Button 3-7"]=90,
	["Button 3-8"]=91,
	["Button 2-5"]=92,
	["Button 2-6"]=93,
	["Button 2-7"]=94,
	["Button 2-8"]=95,
	["Button 1-5"]=96,
	["Button 1-6"]=97,
	["Button 1-7"]=98,
	["Button 1-8"]=99,
}

button_to_keynote={
	-- C0
	["Button 8-2"]=24,
	["Button 7-2"]=25,
	["Button 8-3"]=26,
	["Button 7-3"]=27,
	["Button 8-4"]=28,
	["Button 8-5"]=29,
	["Button 7-5"]=30,
	["Button 8-6"]=31,
	["Button 7-6"]=32,
	["Button 8-7"]=33,
	["Button 7-7"]=34,
	["Button 8-8"]=35,
	-- C1
	["Button 6-2"]=36,
	["Button 5-2"]=37,
	["Button 6-3"]=38,
	["Button 5-3"]=39,
	["Button 6-4"]=40,
	["Button 6-5"]=41,
	["Button 5-5"]=42,
	["Button 6-6"]=43,
	["Button 5-6"]=44,
	["Button 6-7"]=45,
	["Button 5-7"]=46,
	["Button 6-8"]=47,
	-- C2
	["Button 4-2"]=48,
	["Button 3-2"]=49,
	["Button 4-3"]=50,
	["Button 3-3"]=51,
	["Button 4-4"]=52,
	["Button 4-5"]=53,
	["Button 3-5"]=54,
	["Button 4-6"]=55,
	["Button 3-6"]=56,
	["Button 4-7"]=57,
	["Button 3-7"]=58,
	["Button 4-8"]=59,
}

local buttons = {
	["Button 1-1"]="90 51",
	["Button 1-2"]="90 52",
	["Button 1-3"]="90 53",
	["Button 1-4"]="90 54",
	["Button 1-5"]="90 55",
	["Button 1-6"]="90 56",
	["Button 1-7"]="90 57",
	["Button 1-8"]="90 58",

	["Button 2-1"]="90 47",
	["Button 2-2"]="90 48",
	["Button 2-3"]="90 49",
	["Button 2-4"]="90 4a",
	["Button 2-5"]="90 4b",
	["Button 2-6"]="90 4c",
	["Button 2-7"]="90 4d",
	["Button 2-8"]="90 4e",

	["Button 3-1"]="90 3d",
	["Button 3-2"]="90 3e",
	["Button 3-3"]="90 3f",
	["Button 3-4"]="90 40",
	["Button 3-5"]="90 41",
	["Button 3-6"]="90 42",
	["Button 3-7"]="90 43",
	["Button 3-8"]="90 44",

	["Button 4-1"]="90 33",
	["Button 4-2"]="90 34",
	["Button 4-3"]="90 35",
	["Button 4-4"]="90 36",
	["Button 4-5"]="90 37",
	["Button 4-6"]="90 38",
	["Button 4-7"]="90 39",
	["Button 4-8"]="90 3a",

	["Button 5-1"]="90 29",
	["Button 5-2"]="90 2a",
	["Button 5-3"]="90 2b",
	["Button 5-4"]="90 2c",
	["Button 5-5"]="90 2d",
	["Button 5-6"]="90 2e",
	["Button 5-7"]="90 2f",
	["Button 5-8"]="90 30",

	["Button 6-1"]="90 1f",
	["Button 6-2"]="90 20",
	["Button 6-3"]="90 21",
	["Button 6-4"]="90 22",
	["Button 6-5"]="90 23",
	["Button 6-6"]="90 24",
	["Button 6-7"]="90 25",
	["Button 6-8"]="90 26",

	["Button 7-1"]="90 15",
	["Button 7-2"]="90 16",
	["Button 7-3"]="90 17",
	["Button 7-4"]="90 18",
	["Button 7-5"]="90 19",
	["Button 7-6"]="90 1a",
	["Button 7-7"]="90 1b",
	["Button 7-8"]="90 1c",

	["Button 8-1"]="90 0b",
	["Button 8-2"]="90 0c",
	["Button 8-3"]="90 0d",
	["Button 8-4"]="90 0e",
	["Button 8-5"]="90 0f",
	["Button 8-6"]="90 10",
	["Button 8-7"]="90 11",
	["Button 8-8"]="90 12",

	-- Bottom
	["Button A0"]="b0 00", -- Hidden
	["Button A1"]="b0 01",
	["Button A2"]="b0 02",
	["Button A3"]="b0 03",
	["Button A4"]="b0 04",
	["Button A5"]="b0 05",
	["Button A6"]="b0 06",
	["Button A7"]="b0 07",
	["Button A8"]="b0 08",
	["Button A9"]="b0 09", -- Hidden

	-- Left
	["Button B1"]="b0 50",
	["Button B2"]="b0 46",
	["Button B3"]="b0 3c",
	["Button B4"]="b0 32",
	["Button B5"]="b0 28",
	["Button B6"]="b0 1e",
	["Button B7"]="b0 14",
	["Button B8"]="b0 0a",

	-- Top
	["Button C0"]="b0 5a", -- Hidden
	["Button C1"]="b0 5b",
	["Button C2"]="b0 5c",
	["Button C3"]="b0 5d",
	["Button C4"]="b0 5e",
	["Button C5"]="b0 5f",
	["Button C6"]="b0 60",
	["Button C7"]="b0 61",
	["Button C8"]="b0 62",
	["Button C9"]="b0 63", -- Hidden

	-- Right
	["Button D1"]="b0 59",
	["Button D2"]="b0 4f",
	["Button D3"]="b0 45",
	["Button D4"]="b0 3b",
	["Button D5"]="b0 31",
	["Button D6"]="b0 27",
	["Button D7"]="b0 1d",
	["Button D8"]="b0 13",
}

local efsactive = {
	[1] = WHITE,
	[2] = GREEN,
	[3] = RED,
}

local efsinactive = {
	[1] = DGREY,
	[2] = DGREEN,
	[3] = DRED,
}g_scopetext = "none"
g_colorscheme = "Default"
g_helpmode = false
g_valuemode = false
g_scrolltext = nil
g_scrollcolor_default = 13
g_scrollcolor = g_scrollcolor_default
g_scrolling = false
g_scrollspeed_default = 6
g_endscroll = true
g_scrollspeed = g_scrollspeed_default
g_playingbutton = 1
g_flashing = false
g_stopflashing = false
g_startflashing = false
g_sel = {}
g_selcount = 4
g_select = {}
g_updateall = true
g_basekey = 2
g_buttondown = {}
g_velofaderbuttons = {}
g_velofaderlastupdate = 0
g_repeatudbuttons = {}
g_repeatudlastupdate = 0
g_mfaderbuttons = {}
g_mfaderlastupdate = 0
g_debugupdate = 0
g_lightshow = 0


local inputs = {}
-- local outputs = {}

local itemsindex = {}
local itemsmodeindex = {}

midi_to_button = {}

g_esmap = {
	["I"]=0,
	["II"]=1,
	["III"]=2,
	["IV"]=3
}
local color_templates = {
	-- Fader and Knob
	["FAmber"]={enabledcolor=DGREEN, activecolor=AMBER},
	["FRed"]={enabledcolor=DGREEN, activecolor=RED},
	["FGreen"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FYellow"]={enabledcolor=DGREEN, activecolor=YELLOW},
	["FOrange"]={enabledcolor=DGREEN, activecolor=ORANGE},
	-- Faders by type
	["FOsc"]={enabledcolor=DAMBER, activecolor=AMBER},
	["FVol"]={enabledcolor=DMAGENTA, activecolor=MAGENTA},
	["FPan"]={enabledcolor=DMAGENTA, activecolor=MAGENTA},
	["FAmount"]={enabledcolor=DRED, activecolor=RED},
	["FGain"]={enabledcolor=DRED, activecolor=RED},
	["FFreq"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FMisc"]={enabledcolor=DPINK, activecolor=PINK},
	["FLFO"]={enabledcolor=DYELLOW, activecolor=YELLOW},
	["FEnv"]={enabledcolor=DYELLOW, activecolor=YELLOW},
	["FPerf"]={enabledcolor=DCYAN, activecolor=CYAN},
	["FEffect"]={enabledcolor=DBLUE, activecolor=BLUE},
	-- Mix Channel
	["FMixComp"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FMixGate"]={enabledcolor=DRED, activecolor=RED},
	["FMixFilter"]={enabledcolor=DORANGE, activecolor=ORANGE},
	["FMixEqHF"]={enabledcolor=DRED, activecolor=RED},
	["FMixEqHMF"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FMixEqLMF"]={enabledcolor=DBLUE, activecolor=BLUE},
	["FMixEqLF"]={enabledcolor=DPINK, activecolor=PINK},
	-- Drawbars
	["DSub"]={enabledcolor=DRED, activecolor=RED},
	["DFund"]={enabledcolor=DGREY, activecolor=WHITE},
	["DHarm"]={enabledcolor=DBLUE, activecolor=BLUE},
	["DHarm7"]={enabledcolor=DCYAN, activecolor=CYAN},
	-- Special Vocoder Fader
	["FVCGreen"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR, denabledcolor=WAMBER, dactivecolor=YELLOW, defaultvalue=89},
	["FVCFreq"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR, denabledcolor=WAMBER, dactivecolor=YELLOW, defaultvalue=89},
	-- Fader with default value
	["FAmberDef100"]={enabledcolor=DGREEN, activecolor=AMBER, denabledcolor=WAMBER, dactivecolor=RED, defaultvalue=100},
	["FRedDef100"]={enabledcolor=DGREEN, activecolor=RED, denabledcolor=WAMBER, dactivecolor=ORANGE, defaultvalue=100},
	["FGreenDef100"]={enabledcolor=WAMBER, activecolor=GREEN, denabledcolor=DGREEN, dactivecolor=YELLOW, defaultvalue=100},
	["FYellowDef100"]={enabledcolor=DGREEN, activecolor=YELLOW, denabledcolor=WAMBER, dactivecolor=RED, defaultvalue=100},
	["FOrangeDef100"]={enabledcolor=DGREEN, activecolor=ORANGE, denabledcolor=WAMBER, dactivecolor=RED, defaultvalue=100},
	-- Meters
	["InvMeter"]={enabledcolor=GREEN, activecolor=DGREEN, disabledcolor=NOCOLOR, maxcolor=RED},
	["MRed"]={enabledcolor=WAMBER, activecolor=RED, disabledcolor=NOCOLOR, maxcolor=RED},
	-- Up/Down Buttons
	["UDAmber"]={enabledcolor=AMBER, activecolor=AMBER},
	["UDAmber2"]={enabledcolor=HAMBER, activecolor=HAMBER},
	["UDRed"]={enabledcolor=RED, activecolor=RED},
	["UDGreen"]={enabledcolor=GREEN, activecolor=GREEN},
	["UDYellow"]={enabledcolor=YELLOW, activecolor=YELLOW},
	["UDYellow3"]={enabledcolor=HYELLOW, activecolor=HYELLOW},
	["UDOrange"]={enabledcolor=ORANGE, activecolor=ORANGE},
	["UDNocolor"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR},
	-- UD by type
	["UDOsc"]={enabledcolor=DAMBER, activecolor=AMBER},
	["UDOsc2"]={enabledcolor=HAMBER, activecolor=AMBER},
	["UDAmount"]={enabledcolor=DRED, activecolor=RED},
	["UDAmount2"]={enabledcolor=HRED, activecolor=RED},
	["UDVol"]={enabledcolor=DMAGENTA, activecolor=MAGENTA},
	["UDVol2"]={enabledcolor=HMAGENTA, activecolor=MAGENTA},
	["UDGain"]={enabledcolor=DRED, activecolor=RED},
	["UDGain2"]={enabledcolor=HRED, activecolor=RED},
	["UDFreq"]={enabledcolor=DGREEN, activecolor=GREEN},
	["UDFreq2"]={enabledcolor=HGREEN, activecolor=GREEN},
	["UDMisc"]={enabledcolor=DPINK, activecolor=PINK},
	["UDMisc2"]={enabledcolor=HPINK, activecolor=PINK},
	["UDLFO"]={enabledcolor=DYELLOW, activecolor=YELLOW},
	["UDLFO2"]={enabledcolor=HYELLOW, activecolor=YELLOW},
	["UDEnv"]={enabledcolor=DYELLOW, activecolor=YELLOW},
	["UDEnv2"]={enabledcolor=HYELLOW, activecolor=YELLOW},
	["UDEffect"]={enabledcolor=DBLUE, activecolor=BLUE},
	["UDEffect2"]={enabledcolor=HBLUE, activecolor=BLUE},
	["UDPerf"]={enabledcolor=DCYAN, activecolor=CYAN},
	["UDPerf2"]={enabledcolor=HCYAN, activecolor=CYAN},
	-- Buttons
	["BAmber"]={enabledcolor=AMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BRed"]={enabledcolor=RED, activecolor=RED, disabledcolor=NOCOLOR},
	["BGreen"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BYellow"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	["BYellow3"]={enabledcolor=YELLOW3, activecolor=YELLOW3, disabledcolor=NOCOLOR},
	["BOrange"]={enabledcolor=ORANGE, activecolor=ORANGE, disabledcolor=NOCOLOR},
	-- Button On/Off
	["BRedOnOff"]={enabledcolor=HGREY, activecolor=RED, disabledcolor=NOCOLOR},
	["BYellowOnOff"]={enabledcolor=HGREY, activecolor=YELLOW, disabledcolor=NOCOLOR},
	["BGreenOnOff"]={enabledcolor=HGREY, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BAmberOnOff"]={enabledcolor=HGREY, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BBAmberOnOff"]={enabledcolor=DAMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BBlueOnOff"]={enabledcolor=HGREY, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BBGreenOnOff"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BBRedOnOff"]={enabledcolor=DRED, activecolor=RED, disabledcolor=NOCOLOR},
	["BBBlueOnOff"]={enabledcolor=DBLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BBWhiteOnOff"]={enabledcolor=DGREY, activecolor=WHITE, disabledcolor=NOCOLOR},
	["BPerfOnOff"]={enabledcolor=DCYAN, activecolor=CYAN, disabledcolor=NOCOLOR},
	-- Button On/OFf Mix channel
	["BMixOnOff"]={enabledcolor=HGREY, activecolor=BLUE, disabledcolor=NOCOLOR},
	-- Red LED
	["BRedLed"]={enabledcolor=DGREEN, activecolor=RED, disabledcolor=NOCOLOR},
	-- Button Page
	["BMainPage"]={enabledcolor=DGREY, activecolor=WHITE, disabledcolor=NOCOLOR},
	["BIndexPage"]={enabledcolor=DGREY, activecolor=WHITE, disabledcolor=NOCOLOR},
	["BAmpPage"]={enabledcolor=DMAGENTA, activecolor=MAGENTA, disabledcolor=NOCOLOR},
	["BAmpModPage"]={enabledcolor=DMAGENTA, activecolor=MAGENTA, disabledcolor=NOCOLOR},
	["BOscPage"]={enabledcolor=DAMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BOscModPage"]={enabledcolor=DAMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BFilterPage"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BFilterModPage"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BGainPage"]={enabledcolor=DRED, activecolor=RED, disabledcolor=NOCOLOR},
	["BMainEffectPage"]={enabledcolor=DBLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BEffectPage"]={enabledcolor=DBLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BEffect2Page"]={enabledcolor=DBLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BEqPage"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BEffectSupPage"]={enabledcolor=DBLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BPerformancePage"]={enabledcolor=DCYAN, activecolor=CYAN, disabledcolor=NOCOLOR},
	["BPerfPage"]={enabledcolor=DCYAN, activecolor=CYAN, disabledcolor=NOCOLOR},
	["BLFOPage"]={enabledcolor=DYELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	["BEnvPage"]={enabledcolor=HYELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	["BModMPage"]={enabledcolor=DYELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	-- Button Page (High intensity version)
	["BMainPageHigh"]={enabledcolor=WHITE, activecolor=WHITE, disabledcolor=NOCOLOR},
	["BIndexPageHigh"]={enabledcolor=WHITE, activecolor=WHITE, disabledcolor=NOCOLOR},
	["BAmpPageHigh"]={enabledcolor=MAGENTA, activecolor=MAGENTA, disabledcolor=NOCOLOR},
	["BAmpModPageHigh"]={enabledcolor=MAGENTA, activecolor=MAGENTA, disabledcolor=NOCOLOR},
	["BOscPageHigh"]={enabledcolor=AMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BOscModPageHigh"]={enabledcolor=AMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BFilterPageHigh"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BFilterModPageHigh"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BMainEffectPageHigh"]={enabledcolor=BLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BEffectPageHigh"]={enabledcolor=BLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BEffect2PageHigh"]={enabledcolor=BLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BEqPageHigh"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BEffectSupPageHigh"]={enabledcolor=BLUE, activecolor=BLUE, disabledcolor=NOCOLOR},
	["BPerformancePageHigh"]={enabledcolor=CYAN, activecolor=CYAN, disabledcolor=NOCOLOR},
	["BPerfPageHigh"]={enabledcolor=CYAN, activecolor=CYAN, disabledcolor=NOCOLOR},
	["BLFOPageHigh"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	["BEnvPageHigh"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	["BModMPageHigh"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
	-- Mute/Solo
	["BMute"]={enabledcolor=DRED, activecolor=RED, disabledcolor=NOCOLOR},
	["BSolo"]={enabledcolor=WAMBER, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BSoloRevival"]={enabledcolor=WAMBER, activecolor=YELLOW, disabledcolor=NOCOLOR},
	-- Select
	["BPlaySel"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	["BOscSel"]={enabledcolor=DAMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	-- Run
	["BRun"]={enabledcolor=RED, activecolor=GREEN, disabledcolor=NOCOLOR},
	-- Bank / Pattern Select
	["BBank"]={enabledcolor=WAMBER, activecolor=RED, disabledcolor=NOCOLOR},
	-- Sel sound/cat
	["BSelCat"]={enabledcolor=AMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	["BSelSound"]={enabledcolor=WAMBER, activecolor=AMBER, disabledcolor=NOCOLOR},
	-- Step sequencer
	["BStep"]={enabledcolor=DGREEN, activecolor=RED, disabledcolor=NOCOLOR},
	-- Drum Pad
	["BPad"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
	-- Keyboard page Pad
	["BULPad"]={enabledcolor=MAGENTA, activecolor=MAGENTA, disabledcolor=MAGENTA},
	["BURPad"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=GREEN},
	["BDLPad"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=YELLOW},
	["BDRPad"]={enabledcolor=CYAN, activecolor=CYAN, disabledcolor=CYAN},
	-- Keyboard
	["BWhitekey"]={enabledcolor=WHITE, activecolor=WHITE, disabledcolor=WHITE},
	["BBlackkey"]={enabledcolor=BLUE, activecolor=BLUE, disabledcolor=BLUE},
}
local item_conf_map = {
	["Default"]={
		["Default"]={
			["Button *"]={enabledcolor=YELLOW, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Fader *"]={template="FYellow"},
			["BigFader *"]={enabledcolor=WAMBER, activecolor=GREEN, disabledcolor=NOCOLOR, denabledcolor=WGREEN, dactivecolor=YELLOW, defaultvalue=751, bvmap="BigFader"},
			["MFader *"]={enabledcolor=WYELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR, bvmap="MFader"},
			["Drawbar *"]={ttemplate="FYellow", defaultvalue=0},
			["Meter *"]={enabledcolor=WAMBER, activecolor=GREEN, disabledcolor=NOCOLOR, maxcolor=RED},
			["Knob *"]={template="FYellow"},
			["UDHButton *"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
			["UDVButton *"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
			["EFSButton"]={enabledcolor=YELLOW, activecolor=GREEN, disabledcolor=NOCOLOR},
			["ARadioButton2"]={template="BRedOnOff"},
			["ARadioButton3"]={template="BRedOnOff"},
			["ARadioButton4"]={template="BRedOnOff"},

			["Button D1"]={enabledcolor=WGREEN, activecolor=WGREEN, disabledcolor=NOCOLOR},
			["Button D2"]={enabledcolor=ORANGE, activecolor=YELLOW, disabledcolor=NOCOLOR},
			["Button D3"]={enabledcolor=WRED, activecolor=RED, disabledcolor=NOCOLOR},
			["Button D4"]={enabledcolor=WAMBER, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D5"]={enabledcolor=WAMBER, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D6"]={enabledcolor=YELLOW, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D7"]={enabledcolor=YELLOW, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D8"]={enabledcolor=RED, activecolor=AMBER, disabledcolor=NOCOLOR},

			["Button C1"]={enabledcolor=ORANGE, activecolor=ORANGE, disabledcolor=NOCOLOR},
			["Button C2"]={enabledcolor=ORANGE, activecolor=ORANGE, disabledcolor=NOCOLOR},
			["Button C3"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button C4"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button C6"]={template="BPerfPage", helptext="Goto Keyboard"},
			["Button C7"]={template="BIndexPage", helptext="Goto Index"},
			["Button C8"]={enabledcolor=YELLOW, activecolor=RED, disabledcolor=GREEN},
			["Button B1"]={template="BMainPage"},

			["Side LED"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=GREEN},
		},
		["Index"]={
			["Button C7"]={enabledcolor=WHITE, activecolor=WHITE, disabledcolor=NOCOLOR, helptext="Goto Internal"},
			["Button 1-1"]={template="BMainPageHigh", helptext="Goto Main"},
			["Button 2-1"]={template="BOscPageHigh"},
			["Button 3-1"]={template="BOscPageHigh"},
			["Button 4-1"]={template="BOscPageHigh"},
			["Button 5-1"]={template="BOscPageHigh"},
			["Button 6-1"]={template="BOscPageHigh"},
			["Button 7-1"]={template="BOscPageHigh"},
			["Button 8-1"]={template="BOscPageHigh"},

			["Button 1-2"]={template="BAmpPageHigh"},
			["Button 2-2"]={template="BOscModPageHigh"},
			["Button 3-2"]={template="BOscModPageHigh"},
			["Button 4-2"]={template="BOscModPageHigh"},
			["Button 5-2"]={template="BOscModPageHigh"},
			["Button 6-2"]={template="BOscModPageHigh"},
			["Button 7-2"]={template="BOscModPageHigh"},
			["Button 8-2"]={template="BOscModPageHigh"},

			["Button 1-3"]={template="BAmpPageHigh"},
			["Button 2-3"]={template="BOscModPageHigh"},
			["Button 3-3"]={template="BOscModPageHigh"},
			["Button 4-3"]={template="BOscModPageHigh"},
			["Button 5-3"]={template="BOscModPageHigh"},
			["Button 6-3"]={template="BOscModPageHigh"},
			["Button 7-3"]={template="BOscModPageHigh"},
			["Button 8-3"]={template="BOscModPageHigh"},

			["Button 1-4"]={template="BAmpPageHigh"},
			["Button 2-4"]={template="BOscModPageHigh"},
			["Button 3-4"]={template="BOscModPageHigh"},
			["Button 4-4"]={template="BOscModPageHigh"},
			["Button 5-4"]={template="BOscModPageHigh"},
			["Button 6-4"]={template="BOscModPageHigh"},
			["Button 7-4"]={template="BOscModPageHigh"},
			["Button 8-4"]={template="BOscModPageHigh"},

			["Button 1-5"]={template="BPerformancePageHigh"},
			["Button 2-5"]={template="BFilterPageHigh"},
			["Button 3-5"]={template="BFilterPageHigh"},
			["Button 4-5"]={template="BFilterPageHigh"},
			["Button 5-5"]={template="BLFOPageHigh"},
			["Button 6-5"]={template="BLFOPageHigh"},
			["Button 7-5"]={template="BLFOPageHigh"},
			["Button 8-5"]={template="BLFOPageHigh"},

			["Button 1-6"]={template="BPerformancePageHigh"},
			["Button 2-6"]={template="BFilterModPageHigh"},
			["Button 3-6"]={template="BFilterModPageHigh"},
			["Button 4-6"]={template="BFilterModPageHigh"},
			["Button 5-6"]={template="BEnvPageHigh"},
			["Button 6-6"]={template="BEnvPageHigh"},
			["Button 7-6"]={template="BEnvPageHigh"},
			["Button 8-6"]={template="BEnvPageHigh"},

			["Button 1-7"]={template="BPerformancePageHigh"},
			["Button 2-7"]={template="BEffectPageHigh"},
			["Button 3-7"]={template="BEffectPageHigh"},
			["Button 4-7"]={template="BEffectPageHigh"},
			["Button 5-7"]={template="BEffectPageHigh"},
			["Button 6-7"]={template="BEffectPageHigh"},
			["Button 7-7"]={template="BEffectPageHigh"},
			["Button 8-7"]={template="BEffectPageHigh"},

			["Button 1-8"]={template="BMainEffectPageHigh"},
			["Button 2-8"]={template="BEffectPageHigh"},
			["Button 3-8"]={template="BEffectPageHigh"},
			["Button 4-8"]={template="BEffectPageHigh"},
			["Button 5-8"]={template="BEffectPageHigh"},
			["Button 6-8"]={template="BEffectPageHigh"},
			["Button 7-8"]={template="BEffectPageHigh"},
			["Button 8-8"]={template="BEffectPageHigh"},
		},
		["Internal"]={
			["Button C7"]={enabledcolor=RED, activecolor=RED, disabledcolor=NOCOLOR},
			["Button 1-1"]={template="BMainPage"},
			["Button C1"]={enabledcolor=NOCOLOR, activecolor=ORANGE, disabledcolor=NOCOLOR},
			["Button C2"]={enabledcolor=NOCOLOR, activecolor=ORANGE, disabledcolor=NOCOLOR},
			["Button C3"]={enabledcolor=NOCOLOR, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button C4"]={enabledcolor=NOCOLOR, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button H"]={enabledcolor=YELLOW, activecolor=GREEN, disabledcolor=NOCOLOR},
			-- Color test
			["Button 2-1"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=RED},
			["Button 3-1"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HRED},
			["Button 4-1"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DRED},

			["Button 2-2"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=YELLOW},
			["Button 3-2"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HYELLOW},
			["Button 4-2"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DYELLOW},

			["Button 2-3"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=GREEN},
			["Button 3-3"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HGREEN},
			["Button 4-3"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DGREEN},

			["Button 2-4"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=CYAN},
			["Button 3-4"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HCYAN},
			["Button 4-4"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DCYAN},

			["Button 2-5"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=BLUE},
			["Button 3-5"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HBLUE},
			["Button 4-5"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DBLUE},

			["Button 2-6"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=MAGENTA},
			["Button 3-6"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HMAGENTA},
			["Button 4-6"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DMAGENTA},

			["Button 2-8"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=WHITE},
			["Button 3-8"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HGREY},
			["Button 4-8"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DGREY},

			["Button 5-1"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=AMBER},
			["Button 6-1"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HAMBER},
			["Button 7-1"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DAMBER},

			["Button 5-2"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=ORANGE},
			["Button 6-2"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HORANGE},
			["Button 7-2"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DORANGE},

			["Button 5-3"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=GOLD},
			["Button 6-3"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HGOLD},
			["Button 7-3"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DGOLD},

			["Button 5-4"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=MARINE},
			["Button 6-4"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HMARINE},
			["Button 7-4"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DMARINE},

			["Button 5-5"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=CADET},
			["Button 6-5"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HCADET},
			["Button 7-5"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DCADET},

			["Button 5-6"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=PINK},
			["Button 6-6"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=HPINK},
			["Button 7-6"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR, disabledcolor=DPINK},
		},
		["Keyboard"]={
			["Button A1"]={template="BPerformancePage"},
			["Button A2"]={template="BPerformancePage"},
			["Kbd"]={
				["Button 1-2"]={template="BPerformancePage"},
				["Button 2-2"]={template="BPerformancePage"},
				["Fader 1"]={template="FPerf"},
				["Knob V1"]={template="FFreq", resetonrel=true},
				["UDVButton 1-3_2-3"]={template="UDPerf"},
				["Button 1-4"]={template="BPerformancePage"},
				["Button 1-5"]={template="BPerformancePage"},
				["Button 1-6"]={template="BPerformancePage"},
				["Button 1-7"]={template="BPerformancePage"},
				["Button 1-8"]={template="BPerformancePage"},
				["Button 2-4"]={template="BFilterPage"},
				["Button 2-5"]={template="BFilterPage"},
				["Button 2-6"]={template="BFilterPage"},
				["Button 2-7"]={template="BFilterPage"},
				["Button 2-8"]={template="BFilterPage"},

				["Button 8-2"]={template="BWhitekey"},
				["Button 7-2"]={template="BBlackkey"},
				["Button 8-3"]={template="BWhitekey"},
				["Button 7-3"]={template="BBlackkey"},
				["Button 8-4"]={template="BWhitekey"},
				["Button 8-5"]={template="BWhitekey"},
				["Button 7-5"]={template="BBlackkey"},
				["Button 8-6"]={template="BWhitekey"},
				["Button 7-6"]={template="BBlackkey"},
				["Button 8-7"]={template="BWhitekey"},
				["Button 7-7"]={template="BBlackkey"},
				["Button 8-8"]={template="BWhitekey"},

				["Button 6-2"]={template="BWhitekey"},
				["Button 5-2"]={template="BBlackkey"},
				["Button 6-3"]={template="BWhitekey"},
				["Button 5-3"]={template="BBlackkey"},
				["Button 6-4"]={template="BWhitekey"},
				["Button 6-5"]={template="BWhitekey"},
				["Button 5-5"]={template="BBlackkey"},
				["Button 6-6"]={template="BWhitekey"},
				["Button 5-6"]={template="BBlackkey"},
				["Button 6-7"]={template="BWhitekey"},
				["Button 5-7"]={template="BBlackkey"},
				["Button 6-8"]={template="BWhitekey"},

				["Button 4-2"]={template="BWhitekey"},
				["Button 3-2"]={template="BBlackkey"},
				["Button 4-3"]={template="BWhitekey"},
				["Button 3-3"]={template="BBlackkey"},
				["Button 4-4"]={template="BWhitekey"},
				["Button 4-5"]={template="BWhitekey"},
				["Button 3-5"]={template="BBlackkey"},
				["Button 4-6"]={template="BWhitekey"},
				["Button 3-6"]={template="BBlackkey"},
				["Button 4-7"]={template="BWhitekey"},
				["Button 3-7"]={template="BBlackkey"},
				["Button 4-8"]={template="BWhitekey"},
			},
			["Drum"]={
				-- Pads UL
				["Button 1-1"]={template="BULPad"},
				["Button 1-2"]={template="BULPad"},
				["Button 1-3"]={template="BULPad"},
				["Button 1-4"]={template="BULPad"},
				["Button 2-1"]={template="BULPad"},
				["Button 2-2"]={template="BULPad"},
				["Button 2-3"]={template="BULPad"},
				["Button 2-4"]={template="BULPad"},
				["Button 3-1"]={template="BULPad"},
				["Button 3-2"]={template="BULPad"},
				["Button 3-3"]={template="BULPad"},
				["Button 3-4"]={template="BULPad"},
				["Button 4-1"]={template="BULPad"},
				["Button 4-2"]={template="BULPad"},
				["Button 4-3"]={template="BULPad"},
				["Button 4-4"]={template="BULPad"},
				-- Pads UR
				["Button 1-5"]={template="BURPad"},
				["Button 1-6"]={template="BURPad"},
				["Button 1-7"]={template="BURPad"},
				["Button 1-8"]={template="BURPad"},
				["Button 2-5"]={template="BURPad"},
				["Button 2-6"]={template="BURPad"},
				["Button 2-7"]={template="BURPad"},
				["Button 2-8"]={template="BURPad"},
				["Button 3-5"]={template="BURPad"},
				["Button 3-6"]={template="BURPad"},
				["Button 3-7"]={template="BURPad"},
				["Button 3-8"]={template="BURPad"},
				["Button 4-5"]={template="BURPad"},
				["Button 4-6"]={template="BURPad"},
				["Button 4-7"]={template="BURPad"},
				["Button 4-8"]={template="BURPad"},
				-- Pads DL
				["Button 5-1"]={template="BDLPad"},
				["Button 5-2"]={template="BDLPad"},
				["Button 5-3"]={template="BDLPad"},
				["Button 5-4"]={template="BDLPad"},
				["Button 6-1"]={template="BDLPad"},
				["Button 6-2"]={template="BDLPad"},
				["Button 6-3"]={template="BDLPad"},
				["Button 6-4"]={template="BDLPad"},
				["Button 7-1"]={template="BDLPad"},
				["Button 7-2"]={template="BDLPad"},
				["Button 7-3"]={template="BDLPad"},
				["Button 7-4"]={template="BDLPad"},
				["Button 8-1"]={template="BDLPad"},
				["Button 8-2"]={template="BDLPad"},
				["Button 8-3"]={template="BDLPad"},
				["Button 8-4"]={template="BDLPad"},
				-- Pads DR
				["Button 5-5"]={template="BDRPad"},
				["Button 5-6"]={template="BDRPad"},
				["Button 5-7"]={template="BDRPad"},

				["Button 6-5"]={template="BDRPad"},
				["Button 6-6"]={template="BDRPad"},
				["Button 6-7"]={template="BDRPad"},
				["Button 6-8"]={template="BDRPad"},
				["Button 7-5"]={template="BDRPad"},
				["Button 7-6"]={template="BDRPad"},
				["Button 7-7"]={template="BDRPad"},
				["Button 7-8"]={template="BDRPad"},
				["Button 8-5"]={template="BDRPad"},
				["Button 8-6"]={template="BDRPad"},
				["Button 8-7"]={template="BDRPad"},
				["Button 8-8"]={template="BDRPad"},
			},
		},
		["Transport"]={
			["Button D1"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D2"]={enabledcolor=ORANGE, activecolor=YELLOW, disabledcolor=NOCOLOR},
			["Button D3"]={enabledcolor=WRED, activecolor=RED, disabledcolor=NOCOLOR},
			["Button D4"]={enabledcolor=AMBER, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D5"]={enabledcolor=AMBER, activecolor=GREEN, disabledcolor=NOCOLOR},
			["Button D6"]={template="BBGreenOnOff"},
			["Button D7"]={template="BBGreenOnOff"},
			["Button D8"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
		},
		["Options"]={
			["Button D1"]={template="BRedOnOff"},
			["Button D2"]={template="BRed"},
			["Button D3"]={template="BGreen"},
			["Button D4"]={template="BGreenOnOff"},
			["Button D5"]={template="BRedOnOff"},
			["Button D6"]={template="BRedOnOff"},
			["Button D7"]={template="BRedOnOff"},
			["Button D8"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
		},
	},
	["Master Section"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button 1-1"]={template="BMainPageHigh", helptext="Goto Main"},
			["Button 1-2"]={template="BAmpPageHigh", helptext="Goto ChFaders"},
			["Button 1-3"]={template="BAmpPageHigh", helptext="Goto ChPans"},
			["Button 1-5"]={template="BPerformancePageHigh", helptext="Goto ChMutesSolos"},
			["Button 1-7"]={template="BEffectPageHigh", helptext="Goto SendReturn1"},
			["Button 2-7"]={template="BEffectPageHigh", helptext="Goto SendReturn2"},
			["Button 3-7"]={template="BEffectPageHigh", helptext="Goto SendReturn3"},
			["Button 4-7"]={template="BEffectPageHigh", helptext="Goto SendReturn4"},
			["Button 5-7"]={template="BEffectPageHigh", helptext="Goto SendReturn5"},
			["Button 6-7"]={template="BEffectPageHigh", helptext="Goto SendReturn6"},
			["Button 7-7"]={template="BEffectPageHigh", helptext="Goto SendReturn7"},
			["Button 8-7"]={template="BEffectPageHigh", helptext="Goto SendReturn8"},
			["Button 2-8"]={template="BEffectPageHigh", helptext="Goto MasterComp"},
			["Button 3-8"]={template="BEffectPageHigh", helptext="Goto MasterSend"},
			["Button 4-8"]={template="BEffectPageHigh", helptext="Goto MasterInsert"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button 6-4"]={template="BAmpPage"},
			["Button 7-4"]={template="BAmpPage"},
			["Button 8-4"]={template="BRedOnOff"},
			["UDVButton 1-6_2-6"]={template="UDGain", inverted=true, defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="BOrange", inverted=true, defaultvalue=0},
			["Fader 5"]={template="FRed", defaultvalue=100},
			["Button 8-6"]={template="BMute"},
			["Button 8-7"]={template="BSolo"},
			["Button 8-8"]={template="BRedOnOff"},
			["Vu"]={
				["Meter 1"]={template="FGreen"},
				["Meter 2"]={template="FGreen"},
			},
			["Peak"]={
				["Meter 1"]={template="FOrange", bvmap="MeterPeak"},
				["Meter 2"]={template="FOrange", bvmap="MeterPeak"},
			},
		},
		["Channel Mutes & Solos"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BYellow"},
			["Button A2"]={template="BYellow"},
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BMute"},
			["Button 1-4"]={template="BMute"},
			["Button 1-5"]={template="BMute"},
			["Button 1-6"]={template="BMute"},
			["Button 1-7"]={template="BMute"},
			["Button 1-8"]={template="BMute"},
			["Button 2-1"]={template="BSolo"},
			["Button 2-2"]={template="BSolo"},
			["Button 2-3"]={template="BSolo"},
			["Button 2-4"]={template="BSolo"},
			["Button 2-5"]={template="BSolo"},
			["Button 2-6"]={template="BSolo"},
			["Button 2-7"]={template="BSolo"},
			["Button 2-8"]={template="BSolo"},
			["Button 3-1"]={template="BMute"},
			["Button 3-2"]={template="BSolo"},
		},
		["Channel Faders"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BYellow"},
			["Button A2"]={template="BYellow"},
		},
		["Channel Pans"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BYellow"},
			["Button A2"]={template="BYellow"},
		},
		["Master Compressor"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["UDVButton 1-4_2-4"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="FEffect", defaultvalue=4},
			["UDVButton 1-6_2-6"]={template="FEffect", defaultvalue=2},
			["Fader 7"]={template="FEffect", defaultvalue=50},
		},
		["Master Send"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Fader 1"]={template="FGreen", defaultvalue=100},
			["Fader 2"]={template="FGreen", defaultvalue=100},
			["Fader 3"]={template="FGreen", defaultvalue=100},
			["Fader 4"]={template="FGreen", defaultvalue=100},
			["Fader 5"]={template="FGreen", defaultvalue=100},
			["Fader 6"]={template="FGreen", defaultvalue=100},
			["Fader 7"]={template="FGreen", defaultvalue=100},
			["Fader 8"]={template="FGreen", defaultvalue=100},
		},
		["Master Insert"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FMisc", defaultvalue=64},
			["Fader 4"]={template="FMisc", defaultvalue=64},
			["Fader 5"]={template="FMisc", defaultvalue=64},
			["Fader 6"]={template="FMisc", defaultvalue=64},
		},
		["Send Return 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
		["Send Return 8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto ChFaders"},
			["Button B3"]={template="BAmpPage", helptext="Goto ChPans"},
			["Button B4"]={template="BPerformancePage", helptext="Goto ChMutesSolos"},
			["Button B5"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["Button B6"]={template="BEffectPage", helptext="Goto MasterComp"},
			["Button B7"]={template="BEffectPage", helptext="Goto MasterSend"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterInsert"},
			["Button A1"]={template="BEffectPage", helptext="Goto SendReturn1"},
			["Button A2"]={template="BEffectPage", helptext="Goto SendReturn2"},
			["Button A3"]={template="BEffectPage", helptext="Goto SendReturn3"},
			["Button A4"]={template="BEffectPage", helptext="Goto SendReturn4"},
			["Button A5"]={template="BEffectPage", helptext="Goto SendReturn5"},
			["Button A6"]={template="BEffectPage", helptext="Goto SendReturn6"},
			["Button A7"]={template="BEffectPage", helptext="Goto SendReturn7"},
			["Button A8"]={template="BEffectPage", helptext="Goto SendReturn8"},
			["PatchName"]={template="BRedOnOff"},
			["Button 1-2"]={template="BMute"},
			["Fader 3"]={template="FOrange", defaultvalue=100},
			["Knob V4"]={template="FOrange"},
			["Meter 8"]={template="FGreen"},
		},
	},
	["Mix Channel"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-8"]={template="BAmpPageHigh", helptext="Goto Input"},
			["Button 2-8"]={template="BEffectPageHigh", helptext="Goto Comp"},
			["Button 3-8"]={template="BEffectPageHigh", helptext="Goto Gate"},
			["Button 4-8"]={template="BFilterPageHigh", helptext="Goto EqLow"},
			["Button 5-8"]={template="BFilterPageHigh", helptext="Goto EqHi"},
			["Button 6-8"]={template="BFilterPageHigh", helptext="Goto Filter"},
			["Button 7-7"]={template="BEffectPageHigh", helptext="Goto Send1"},
			["Button 7-8"]={template="BEffectPageHigh", helptext="Goto Send2"},
			["Button 8-8"]={template="BEffectPageHigh", helptext="Goto Insert"},
			["Button C7"]={template="BEffectPageHigh", helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BSolo"},
			["Fader 4"]={template="FEffect", defaultvalue=127},
			["Knob V5"]={template="FPan"},
			["BigFader 6"]={template="FVol"},
		},
		["Input"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Knob V2"]={template="FVol"},
			["Button 1-3"]={template="BMixOnOff"},
			["Button 1-4"]={template="BMixOnOff"},
			["Button 1-5"]={template="BMixOnOff"},
			["Button 1-7"]={template="BMixOnOff"},
		},
		["Compressor"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button 1-2"]={template="BMixOnOff"},
			["Button 4-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FMixComp"},
			["Fader 4"]={template="FMixComp"},
			["Fader 5"]={template="FMixComp"},
			["Button 1-6"]={template="BMixOnOff"},
			["Meter 8"]={template="FYellow"},
		},
		["Gate"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button 1-2"]={template="BMixOnOff"},
			["Button 4-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FMixGate", defaultvalue=64},
			["Fader 4"]={template="FMixGate", defaultvalue=32},
			["Fader 5"]={template="FMixGate", defaultvalue=64},
			["Fader 6"]={template="FMixGate", defaultvalue=0},
			["Button 1-7"]={template="BMixOnOff"},
			["Meter 8"]={template="FGreen"},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button 1-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FMixFilter", defaultvalue=85},
			["Button 1-4"]={template="BMixOnOff"},
			["Fader 5"]={template="FMixFilter", defaultvalue=54},
			["Button 1-7"]={template="BMixOnOff"},
		},
		["Equalizer High"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A1"]={template="BEqPage", helptext="Goto EqHi"},
			["Button A2"]={template="BEqPage", helptext="Goto EqLow"},
			["Button 1-1"]={template="BMixOnOff"},
			["Button 4-1"]={template="BMixOnOff"},
			["Knob V3"]={template="FMixEqHMF"},
			["Fader 4"]={template="FMixEqHMF", defaultvalue=64},
			["Fader 5"]={template="FMixEqHMF", defaultvalue=64},
			["Button 1-6"]={template="BMixOnOff"},
			["Knob V7"]={template="FMixEqHMF"},
			["Fader 8"]={template="FMixEqHMF", defaultvalue=64},
		},
		["Equalizer Low"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqLow"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A1"]={template="BEqPage", helptext="Goto EqHi"},
			["Button A2"]={template="BEqPage", helptext="Goto EqLow"},
			["Button 1-1"]={template="BMixOnOff"},
			["Button 4-1"]={template="BMixOnOff"},
			["Button 1-2"]={template="BMixOnOff"},
			["Knob V3"]={template="FMixEqLF"},
			["Fader 4"]={template="FMixEqLF", defaultvalue=64},
			["Knob V6"]={template="FMixEqLMF"},
			["Fader 7"]={template="FMixEqLMF", defaultvalue=64},
			["Fader 8"]={template="FMixEqLMF", defaultvalue=64},
		},
		["Insert"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A3"]={template="BBlueOnOff"},
			["Button A4"]={template="BBlueOnOff"},
			["Button A5"]={template="BBlueOnOff"},
			["Button A6"]={template="BBlueOnOff"},
			["Button 1-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=64},
		},
		["Send 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A1"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A2"]={template="BEffectPage", helptext="Goto Send2"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-2"]={template="BGreenOnOff"},
			["Button 1-3"]={template="BGreenOnOff"},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BGreenOnOff"},
			["Button 1-6"]={template="BGreenOnOff"},
			["Button 1-7"]={template="BGreenOnOff"},
			["Button 1-8"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BMixOnOff"},
			["Button 2-2"]={template="BMixOnOff"},
			["Button 2-3"]={template="BMixOnOff"},
			["Button 2-4"]={template="BMixOnOff"},
			["Button 2-5"]={template="BMixOnOff"},
			["Button 2-6"]={template="BMixOnOff"},
			["Button 2-7"]={template="BMixOnOff"},
			["Button 2-8"]={template="BMixOnOff"},
		},
		["Send 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Input"},
			["Button B3"]={template="BEffectPage", helptext="Goto Comp"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BFilterPage", helptext="Goto EqHi"},
			["Button B7"]={template="BEffectPage", helptext="Goto Insert"},
			["Button B8"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A1"]={template="BEffectPage", helptext="Goto Send1"},
			["Button A2"]={template="BEffectPage", helptext="Goto Send2"},
			["Fader 1"]={template="FEffect", defaultvalue=64},
			["Fader 2"]={template="FEffect", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=64},
			["Fader 8"]={template="FEffect", defaultvalue=64},
		},
	},
	["Ammo 100LA"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-1"]={helptext="Goto Osc"},
			["Button 2-2"]={helptext="Goto Osc2"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Osc"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button 1-1"]={template="BBlueOnOff"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["MFader 5-2"]={template="UDOsc", defaultvalue=64},
			["MFader 7-2"]={template="UDLFO", defaultvalue=127},
			["Low Rate Hz"]={
				["BigFader 3"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 3"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["MFader 7-5"]={template="UDLFO", defaultvalue=127},
			["Fader 6"]={template="FFreq", defaultvalue=127},
			["MFader 7-7"]={template="UDLFO", defaultvalue=127},
			["Fader 8"]={template="FOsc", defaultvalue=0},
		},
		["Osc2"]={
			["Fader 1"]={template="FPerf", defaultvalue=0},
			["Fader 2"]={template="FEnv", defaultvalue=127},
			["Button 1-3"]={template="BYellowOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
		},
	},
	["Ammo 400R"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-1"]={helptext="Goto OscA"},
			["Button 3-1"]={helptext="Goto OscB"},
			["Button 4-1"]={helptext="Goto OscC"},
			["Button 5-1"]={helptext="Goto OscD"},
			["Button 7-1"]={template="BModMPageHigh", helptext="Goto ModMatrix"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BYellowOnOff"},
			["Button 1-6"]={template="BBlueOnOff"},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["MFader 1-1"]={template="FPerf"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BGreenOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BBlueOnOff"},
			["MFader 3-1"]={template="FPerf"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BGreenOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BBlueOnOff"},
			["MFader 5-1"]={template="FPerf"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BGreenOnOff"},
			["Button 5-7"]={template="BYellowOnOff"},
			["Button 5-8"]={template="BBlueOnOff"},
			["MFader 7-1"]={template="FPerf"},
			["Button 7-5"]={template="BRedOnOff"},
			["Button 7-6"]={template="BGreenOnOff"},
			["Button 7-7"]={template="BYellowOnOff"},
			["Button 7-8"]={template="BBlueOnOff"},
		},
		["Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Fader 1"]={template="FEffect", defaultvalue=0},
			["Fader 2"]={template="FEnv", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=127},
			["Fader 6"]={template="FEnv", defaultvalue=0},
		},
		["ModMatrix"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["MFader 1-2"]={template="FMod"},
			["MFader 3-2"]={template="FMod"},
			["MFader 5-2"]={template="FMod"},
			["MFader 7-2"]={template="FMod"},
			["MFader 1-4"]={template="FMod"},
			["MFader 3-4"]={template="FMod"},
			["MFader 5-4"]={template="FMod"},
			["MFader 7-4"]={template="FMod"},
		},
		["Osc A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["Osc B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscB"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["Osc C"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscC"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["Osc D"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscD"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BBlueOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["VPM A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-1"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
		["VPM B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-2"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
		["VPM C"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-3"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
		["VPM D"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BAmpPage", helptext="Goto VPMD"},
			["Button B4"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B5"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B6"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-4"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
	},
	["Ammo 1200BR"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-1"]={helptext="Goto OscA"},
			["Button 3-1"]={helptext="Goto OscB"},
			["Button 4-1"]={helptext="Goto OscC"},
			["Button 5-1"]={helptext="Goto OscD"},
			["Button 7-1"]={template="BModMPageHigh", helptext="Goto ModMatrix"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BYellowOnOff"},
			["Button 1-6"]={template="BBlueOnOff"},
		},
		["Battery"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto Battery"},
			["Button A2"]={template="BOscPage", helptext="Goto SampleAndHold"},
			["Button A3"]={template="BOscPage", helptext="Goto Comparator"},
			["Button A4"]={template="BOscPage", helptext="Goto ElektroSwitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Attenuator"},
			["MFader 1-1"]={template="FGain", defaultvalue=89},
			["MFader 3-1"]={template="FGain", defaultvalue=89},
			["MFader 5-1"]={template="FGain", defaultvalue=89},
			["MFader 7-1"]={template="FGain", defaultvalue=89},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 3-5"]={template="BGreenOnOff"},
			["Button 5-5"]={template="BYellowOnOff"},
			["Button 7-5"]={template="BBlueOnOff"},
		},
		["SampleAndHold"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto SampleAndHold"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto Battery"},
			["Button A2"]={template="BOscPage", helptext="Goto SampleAndHold"},
			["Button A3"]={template="BOscPage", helptext="Goto Comparator"},
			["Button A4"]={template="BOscPage", helptext="Goto ElektroSwitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Attenuator"},
			["UDHButton 1-1_1-2"]={template="UDOsc", defaultvalue=0},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 4-1"]={template="BGreenOnOff"},
			["Button 6-1"]={template="BYellowOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["MFader 1-3"]={template="FGain", defaultvalue=0},
			["MFader 3-3"]={template="FGain", defaultvalue=0},
			["MFader 5-3"]={template="FGain", defaultvalue=0},
			["MFader 7-3"]={template="FGain", defaultvalue=0},
			["MFader 1-5"]={template="FFreq", defaultvalue=80},
			["MFader 3-5"]={template="FFreq", defaultvalue=80},
			["MFader 5-5"]={template="FFreq", defaultvalue=80},
			["MFader 7-5"]={template="FFreq", defaultvalue=80},
		},
		["Comparator"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Comparator"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto Battery"},
			["Button A2"]={template="BOscPage", helptext="Goto SampleAndHold"},
			["Button A3"]={template="BOscPage", helptext="Goto Comparator"},
			["Button A4"]={template="BOscPage", helptext="Goto ElektroSwitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Attenuator"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 4-1"]={template="BGreenOnOff"},
			["Button 6-1"]={template="BYellowOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["UDHButton 2-3_2-4"]={template="UDOsc", defaultvalue=0},
			["UDHButton 4-3_4-4"]={template="UDOsc", defaultvalue=0},
			["UDHButton 6-3_6-4"]={template="UDOsc", defaultvalue=0},
			["UDHButton 8-3_8-4"]={template="UDOsc", defaultvalue=0},
		},
		["ElektroSwitch"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto ElektroSwitch"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto Battery"},
			["Button A2"]={template="BOscPage", helptext="Goto SampleAndHold"},
			["Button A3"]={template="BOscPage", helptext="Goto Comparator"},
			["Button A4"]={template="BOscPage", helptext="Goto ElektroSwitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Attenuator"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 4-1"]={template="BGreenOnOff"},
			["Button 6-1"]={template="BYellowOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["UDHButton 2-3_2-4"]={template="UDOsc", defaultvalue=0},
			["UDHButton 4-3_4-4"]={template="UDOsc", defaultvalue=0},
			["UDHButton 6-3_6-4"]={template="UDOsc", defaultvalue=0},
			["UDHButton 8-3_8-4"]={template="UDOsc", defaultvalue=0},
			["MFader 3-5"]={template="FLFO", defaultvalue=127},
			["MFader 5-5"]={template="FLFO", defaultvalue=127},
			["Button 1-5"]={template="BRedOnOff"},
			["MFader 1-6"]={template="FFreq", defaultvalue=64},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=18},
			["MFader 3-6"]={template="FFreq", defaultvalue=64},
			["UDVButton 3-6_4-6"]={template="UDFreq", defaultvalue=18},
			["MFader 5-6"]={template="FFreq", defaultvalue=64},
			["UDVButton 5-6_6-6"]={template="UDFreq", defaultvalue=18},
			["MFader 7-6"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-6_8-6"]={template="UDFreq", defaultvalue=18},
			["UDVButton 1-7_2-7"]={template="UDLFO", defaultvalue=0},
			["UDVButton 3-7_4-7"]={template="UDLFO", defaultvalue=0},
			["UDVButton 5-7_6-7"]={template="UDLFO", defaultvalue=0},
			["UDVButton 7-7_8-7"]={template="UDLFO", defaultvalue=0},
			["MFader 1-8"]={template="FOsc", defaultvalue=64},
			["MFader 3-8"]={template="FOsc", defaultvalue=64},
			["MFader 5-8"]={template="FOsc", defaultvalue=64},
			["MFader 7-8"]={template="FOsc", defaultvalue=64},
		},
		["Attenuator"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Attenuator"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto Battery"},
			["Button A2"]={template="BOscPage", helptext="Goto SampleAndHold"},
			["Button A3"]={template="BOscPage", helptext="Goto Comparator"},
			["Button A4"]={template="BOscPage", helptext="Goto ElektroSwitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Attenuator"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 4-1"]={template="BGreenOnOff"},
			["Button 6-1"]={template="BYellowOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["MFader 1-3"]={template="FLFO"},
			["MFader 3-3"]={template="FLFO"},
			["MFader 5-3"]={template="FLFO"},
			["MFader 7-3"]={template="FLFO"},
			["MFader 1-5"]={template="FEffect"},
			["MFader 3-5"]={template="FEffect"},
			["MFader 5-5"]={template="FEffect"},
			["MFader 7-5"]={template="FEffect"},
		},
		["Limiter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BYellowOnOff"},
			["Button 1-6"]={template="BBlueOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["MFader 1-1"]={template="FPerf"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BGreenOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BBlueOnOff"},
			["MFader 3-1"]={template="FPerf"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BGreenOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BBlueOnOff"},
			["MFader 5-1"]={template="FPerf"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BGreenOnOff"},
			["Button 5-7"]={template="BYellowOnOff"},
			["Button 5-8"]={template="BBlueOnOff"},
			["MFader 7-1"]={template="FPerf"},
			["Button 7-5"]={template="BRedOnOff"},
			["Button 7-6"]={template="BGreenOnOff"},
			["Button 7-7"]={template="BYellowOnOff"},
			["Button 7-8"]={template="BBlueOnOff"},
		},
		["Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Fader 1"]={template="FEffect", defaultvalue=0},
			["Fader 2"]={template="FEnv", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=127},
			["Fader 6"]={template="FEnv", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["ModMatrix"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["MFader 1-2"]={template="FMod"},
			["MFader 3-2"]={template="FMod"},
			["MFader 5-2"]={template="FMod"},
			["MFader 7-2"]={template="FMod"},
			["MFader 1-4"]={template="FMod"},
			["MFader 3-4"]={template="FMod"},
			["MFader 5-4"]={template="FMod"},
			["MFader 7-4"]={template="FMod"},
			["MFader 1-6"]={template="FMod"},
			["MFader 3-6"]={template="FMod"},
			["MFader 5-6"]={template="FMod"},
			["MFader 7-6"]={template="FMod"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 3-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 7-8"]={template="BRedOnOff"},
		},
		["Osc A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["Osc B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscB"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["Osc C"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscC"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["Osc D"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscD"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscPage", helptext="Goto OscB"},
			["Button A3"]={template="BOscPage", helptext="Goto OscC"},
			["Button A4"]={template="BOscPage", helptext="Goto OscD"},
			["Button 1-1"]={template="BBlueOnOff"},
			["UDVButton 3-1_4-1"]={template="UDOsc", defaultvalue=0},
			["Low Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=305},
			},
			["High Rate Hz"]={
				["BigFader 2"]={template="FFreq", defaultvalue=639},
			},
			["Rate Semitone"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=36},
			},
			["Cents Detune"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			},
			["Rate Tempo Sync"]={
				["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=18},
			},
			["UDVButton 1-3_2-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FOsc", defaultvalue=127},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
		},
		["VPM A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-1"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
		["VPM B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-2"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
		["VPM C"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-3"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
		["VPM D"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BOscModPage", helptext="Goto Battery"},
			["Button B4"]={template="BAmpPage", helptext="Goto VPMD"},
			["Button B5"]={template="BEnvPage", helptext="Goto Envelope"},
			["Button B6"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B7"]={template="BModMPage", helptext="Goto ModMatrix"},
			["Button B8"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button A1"]={template="BAmpPage", helptext="Goto VPMA"},
			["Button A2"]={template="BAmpPage", helptext="Goto VPMB"},
			["Button A3"]={template="BAmpPage", helptext="Goto VPMC"},
			["Button A4"]={template="BAmpPage", helptext="Goto VPMD"},
			["MFader 1-1"]={template="FGain"},
			["MFader 1-4"]={template="FGain"},
			["MFader 1-2"]={template="FGain"},
			["MFader 1-3"]={template="FGain"},
			["XFadeOn"]={
				["MFader 1-4"]={template="FVol"},
			},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 4-2"]={template="BGreenOnOff"},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FOsc", defaultvalue=0},
			["Fader 7"]={template="FOsc", defaultvalue=127},
			["Fader 8"]={template="FGain"},
		},
	},
	["Antidote"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Mixer"},
			["Button 1-3"]={helptext="Goto AmpEnv"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 1-6"]={helptext="Goto Arp"},
			["Button 2-1"]={helptext="Goto Osc1"},
			["Button 3-1"]={helptext="Goto Osc2"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 8-1"]={template="BPerformancePageHigh", helptext="Goto ModMatrix1"},
			["Button 8-2"]={template="BPerformancePageHigh", helptext="Goto ModMatrix2"},
			["Button 8-3"]={template="BPerformancePageHigh", helptext="Goto ModMatrix3"},
			["Button 8-4"]={template="BPerformancePageHigh", helptext="Goto ModMatrix4"},
			["Button 8-5"]={template="BPerformancePageHigh", helptext="Goto ModMatrix5"},
			["Button 1-8"]={helptext="Goto Effects"},
			["Button 2-8"]={helptext="Goto EQBass"},
			["Button 3-8"]={helptext="Goto Dist"},
			["Button 4-8"]={helptext="Goto Phaser"},
			["Button 5-8"]={helptext="Goto Chorus"},
			["Button 6-8"]={helptext="Goto Delay"},
			["Button 7-8"]={helptext="Goto Reverb"},
			["Button 8-8"]={helptext="Goto Comp"},
			["Button 5-5"]={helptext="Goto LFO1"},
			["Button 6-5"]={helptext="Goto LFO2"},
			["Button 5-6"]={helptext="Goto ModEnv"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 7-2_8-2"]={template="UDOsc", inverted=true, defaultvalue=3},
			["Fader 3"]={template="FPerf", defaultvalue=0},
		},
		["Osc 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-1_2-1"]={template="UDFreq", defaultvalue=24},
			["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=50},
			["MFader 1-4"]={template="FEffect", defaultvalue=0},
			["UDVButton 5-1_6-1"]={template="UDOsc", inverted=true, defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDOsc", defaultvalue=1},
			["UDVButton 5-4_6-4"]={template="UDOsc", defaultvalue=0},
			["MFader 3-1"]={template="FOsc", defaultvalue=127},
			["MFader 3-2"]={template="FOsc", defaultvalue=0},
			["MFader 3-3"]={template="FPerf", defaultvalue=127},
			["MFader 3-4"]={template="FVol", defaultvalue=64},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Osc 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-1_2-1"]={template="UDFreq", defaultvalue=24},
			["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=50},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=50},
			["MFader 1-4"]={template="FEffect", defaultvalue=0},
			["UDVButton 5-1_6-1"]={template="UDOsc", inverted=true, defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDOsc", defaultvalue=1},
			["UDVButton 5-4_6-4"]={template="UDOsc", defaultvalue=0},
			["MFader 3-1"]={template="FOsc", defaultvalue=127},
			["MFader 3-2"]={template="FOsc", defaultvalue=0},
			["MFader 3-3"]={template="FPerf", defaultvalue=127},
			["MFader 3-4"]={template="FVol", defaultvalue=64},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Mixer"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button A2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Fader 2"]={template="FVol", defaultvalue=64},
			["Fader 3"]={template="FVol", defaultvalue=64},
			["Fader 4"]={template="FGain", defaultvalue=0},
			["Fader 5"]={template="FGain", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEnv", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Filter Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Fader 2"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=127},
			["Fader 7"]={template="FFreq", defaultvalue=64},
		},
		["Effects"]={
			["Button 8-1"]={template="BGreenOnOff"},
			["Button 8-2"]={template="BGreenOnOff"},
			["Button 8-3"]={template="BGreenOnOff"},
			["Button 8-4"]={template="BGreenOnOff"},
			["Button 8-5"]={template="BGreenOnOff"},
			["Button 8-6"]={template="BGreenOnOff"},
			["Button 8-7"]={template="BGreenOnOff"},
			["Fader 8"]={template="FEffect", defaultvalue=64},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
		},
		["EQ/Bass"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FGain", defaultvalue=64},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=64},
			["Fader 6"]={template="FGain", defaultvalue=64},
			["MFader 1-7"]={template="UDFreq", defaultvalue=57},
			["MFader 5-7"]={template="UDEffect", defaultvalue=0},
			["Fader 8"]={template="FGain", defaultvalue=127},
		},
		["Dist"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect", defaultvalue=0},
			["MFader 5-1"]={template="FAmount", defaultvalue=0},
			["Fader 2"]={template="UDEffect", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Fader 6"]={template="FAmount", defaultvalue=64},
			["Fader 8"]={template="FGain", defaultvalue=127},
		},
		["Phaser"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect", defaultvalue=1},
			["Fader 2"]={template="FFreq", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=13},
			["Fader 6"]={template="FLFO", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=64},
			["Fader 8"]={template="FGain", defaultvalue=64},
		},
		["Chorus"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=102},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=25},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Fader 8"]={template="FGain", defaultvalue=64},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect", defaultvalue=0},
			["UDVButton 5-1_6-1"]={template="UDFreq", defaultvalue=10},
			["UDVButton 7-1_8-1"]={template="UDFreq", defaultvalue=10},
			["Fader 2"]={template="FEffect", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FLFO", defaultvalue=13},
			["Fader 8"]={template="FGain", defaultvalue=64},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["MFader 3-1"]={template="UDEffect", defaultvalue=0},
			["Fader 2"]={template="FEffect", defaultvalue=64},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Fader 6"]={template="FLFO", defaultvalue=64},
			["Fader 8"]={template="FGain", defaultvalue=64},
		},
		["Comp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto EQBass"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A4"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A5"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A7"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect", defaultvalue=25},
			["Fader 2"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=95},
			["Fader 8"]={template="FGain", defaultvalue=127},
		},
		["LFO 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-3"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDLFO", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=13},
			["Knob V5"]={template="FLFO"},
			["UDVButton 7-1_8-1"]={template="UDLFO", inverted=true, defaultvalue=0},
		},
		["LFO 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-3"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDLFO", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=13},
			["Knob V5"]={template="FLFO"},
			["UDVButton 7-1_8-1"]={template="UDLFO", inverted=true, defaultvalue=0},
		},
		["Amp Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button A2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Fader 3"]={template="FVol", defaultvalue=0},
			["Fader 4"]={template="FVol", defaultvalue=64},
			["Fader 5"]={template="FVol", defaultvalue=127},
			["Fader 6"]={template="FVol", defaultvalue=64},
		},
		["Mod Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto ModEnv"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["UDVButton 3-1_4-1"]={template="UDEnv", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=64},
			["Fader 5"]={template="FEnv", defaultvalue=127},
			["Fader 6"]={template="FEnv", defaultvalue=64},
			["Knob V8"]={template="FEnv"},
		},
		["Arpeggiator"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["UDVButton 1-1_2-1"]={template="UDPerf", defaultvalue=0},
			["UDVButton 3-1_4-1"]={template="UDPerf", defaultvalue=0},
			["UDVButton 5-1_6-1"]={template="UDFreq", defaultvalue=19},
			["MFader 1-3"]={template="FEffect", defaultvalue=64},
			["Button 3-3"]={template="BGreenOnOff"},
			["UDVButton 5-3_6-3"]={template="UDFreq", defaultvalue=0},
		},
		["Mod Matrix 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Arp"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
		},
	},
	["Combinator"]={
		["Keyboard"]={
			["Button B1"]={helptext="Goto Main"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDMisc", defaultvalue=1},
			["Button 5-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 5"]={template="FMisc"},
			["Fader 6"]={template="FMisc"},
			["Fader 7"]={template="FMisc"},
			["Fader 8"]={template="FMisc"},
		},
	},
	["DrOctoRex"]={
		["Keyboard"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto AmpEnv"},
			["Button 2-1"]={helptext="Goto Osc"},
			["Button 1-5"]={helptext="Goto Loop"},
			["Button 1-6"]={helptext="Goto Performance"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["UDVButton 1-2_2-2"]={template="UDPerf", defaultvalue=0},
			["UDVButton 1-3_2-3"]={template="UDPerf", defaultvalue=0},
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BYellowOnOff"},
			["Button 4-5"]={template="BYellowOnOff"},
			["Button 4-6"]={template="BYellowOnOff"},
			["Button 5-3"]={template="BYellowOnOff"},
			["Button 5-4"]={template="BYellowOnOff"},
			["Button 5-5"]={template="BYellowOnOff"},
			["Button 5-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRun"},
			["UDVButton 7-7_8-7"]={template="FFreq", defaultvalue=12},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["AmpEnv"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["Fader 4"]={template="FVol", defaultvalue=0},
			["Fader 5"]={template="FVol", defaultvalue=127},
			["Fader 6"]={template="FVol", defaultvalue=0},
			["Fader 7"]={template="FVol", defaultvalue=10},
		},
		["Osc"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["Knob V2"]={template="FOsc"},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=4},
			["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=50},
		},
		["Loop"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDPerf", defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=12},
			["Fader 8"]={template="FVol", defaultvalue=127},
		},
		["Performance"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["UDVButton 3-1_4-1"]={template="UDPerf", defaultvalue=7},
			["UDVButton 7-1_8-1"]={template="UDPerf", defaultvalue=5},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FEffect"},
			["Knob V4"]={template="FEffect"},
			["Knob V6"]={template="FFreq"},
			["Knob V7"]={template="FEffect"},
			["Knob V8"]={template="FVol"},
		},
		["Filter"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button 1-6"]={template="BRedOnOff"},
			["UDVButton 7-6_8-6"]={template="FFreq", inverted=true, defaultvalue=3},
			["Fader 4"]={template="FFreq", defaultvalue=127},
			["Fader 5"]={template="FEffect", defaultvalue=0},
		},
		["FilterEnv"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["Fader 2"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=64},
		},
		["LFO"]={
			["Button B1"]={template="FLFO", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Loop"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 7-1_8-1"]={template="UDLFO", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=7},
			["Fader 6"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-8_8-8"]={template="UDLFO", inverted=true, defaultvalue=0},
		},
	},
	["Europa"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Mixer"},
			["Button 1-3"]={helptext="Goto Amp"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto Eng1Osc"},
			["Button 3-1"]={helptext="Goto Eng2Osc"},
			["Button 4-1"]={helptext="Goto Eng3Osc"},
			["Button 2-2"]={helptext="Goto Eng1Mod1"},
			["Button 3-2"]={helptext="Goto Eng2Mod1"},
			["Button 4-2"]={helptext="Goto Eng3Mod1"},
			["Button 2-3"]={helptext="Goto Eng1Mod2"},
			["Button 3-3"]={helptext="Goto Eng2Mod2"},
			["Button 4-3"]={helptext="Goto Eng3Mod2"},
			["Button 2-5"]={helptext="Goto Eng1Filter"},
			["Button 3-5"]={helptext="Goto Eng2Filter"},
			["Button 4-5"]={helptext="Goto Eng3Filter"},
			["Button 2-6"]={helptext="Goto Eng1Harm"},
			["Button 3-6"]={helptext="Goto Eng2Harm"},
			["Button 4-6"]={helptext="Goto Eng3Harm"},
			["Button 2-7"]={template="BEffect2PageHigh", helptext="Goto Eng1Unison"},
			["Button 3-7"]={template="BEffect2PageHigh", helptext="Goto Eng2Unison"},
			["Button 4-7"]={template="BEffect2PageHigh", helptext="Goto Eng3Unison"},
			["Button 5-5"]={template="BFilterPageHigh", helptext="Goto Filter"},
			["Button 7-1"]={template="BModMPageHigh", helptext="Goto ModMatrix1"},
			["Button 7-2"]={template="BModMPageHigh", helptext="Goto ModMatrix2"},
			["Button 7-3"]={template="BModMPageHigh", helptext="Goto ModMatrix3"},
			["Button 7-4"]={template="BModMPageHigh", helptext="Goto ModMatrix4"},
			["Button 8-1"]={template="BModMPageHigh", helptext="Goto ModMatrix5"},
			["Button 8-2"]={template="BModMPageHigh", helptext="Goto ModMatrix6"},
			["Button 8-3"]={template="BModMPageHigh", helptext="Goto ModMatrix7"},
			["Button 8-4"]={template="BModMPageHigh", helptext="Goto ModMatrix8"},
			["Button 6-5"]={helptext="Goto LFO1"},
			["Button 7-5"]={helptext="Goto LFO2"},
			["Button 8-5"]={helptext="Goto LFO3"},
			["Button 5-6"]={helptext="Goto Env1"},
			["Button 6-6"]={helptext="Goto Env2"},
			["Button 7-6"]={helptext="Goto Env3"},
			["Button 8-6"]={helptext="Goto Env4"},
			["Button 1-8"]={helptext="Goto Effects"},
			["Button 2-8"]={helptext="Goto Phaser"},
			["Button 3-8"]={helptext="Goto Dist"},
			["Button 4-8"]={helptext="Goto Eq"},
			["Button 5-8"]={helptext="Goto Delay"},
			["Button 6-8"]={helptext="Goto Comp"},
			["Button 7-8"]={helptext="Goto Reverb"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 3-1"]={template="BRedOnOff"},
			["Button 4-1"]={template="BRedOnOff"},
			["Fader 8"]={template="FGain", defaultvalue=89},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 7-1_8-1"]={template="UDPerf2", defaultvalue=2},
			["UDVButton 7-3_8-3"]={template="UDPerf", defaultvalue=2},
			["Fader 4"]={template="FPerf"},
			["UDVButton 7-6_8-6"]={template="UDPerf", defaultvalue=2},
			["UDVButton 7-8_8-8"]={template="UDOsc", defaultvalue=7},
		},
		["Mixer"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button A2"]={template="BAmpPage", helptext="Goto Amp"},
			["Fader 2"]={template="FVol", defaultvalue=89},
			["Fader 3"]={template="FVol", defaultvalue=89},
			["Fader 4"]={template="FVol", defaultvalue=89},
			["Knob V6"]={template="FPan"},
			["Knob V7"]={template="FPan"},
			["Knob V8"]={template="FPan"},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 5-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Button 7-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FGain", defaultvalue=25},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FFreq"},
			["MFader 1-6"]={template="UDPerf", defaultvalue=127},
			["MFader 3-6"]={template="UDLFO", defaultvalue=0},
			["MFader 5-6"]={template="UDPerf", defaultvalue=0},
			["UDVButton 3-7_4-7"]={template="UDLFO", inverted=true},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button A2"]={template="BAmpPage", helptext="Goto Amp"},
			["Knob V2"]={template="FPan"},
			["Fader 3"]={template="FGain", defaultvalue=102},
			["Fader 4"]={template="FPerf", defaultvalue=0},
			["Fader 5"]={template="FVol", defaultvalue=13},
			["Fader 6"]={template="FVol", defaultvalue=64},
			["Fader 7"]={template="FVol", defaultvalue=127},
			["Fader 8"]={template="FVol", defaultvalue=13},
		},
		["Eng 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng1Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng1Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng1Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng1Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng1Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=2},
			["UDVButton 3-3_4-3"]={template="UDFreq2", defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDFreq", defaultvalue=50},
			["MFader 7-3"]={template="UDPerf", defaultvalue=127},
			["UDVButton 1-4_2-4"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 5"]={template="FOsc", defaultvalue=0},
			["Button 8-4"]={template="BRedOnOff"},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=6},
			["Fader 7"]={template="FLFO", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Eng 1 Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Mod1"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Mod1"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Mod1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng1Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng1Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng1Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng1Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng1Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=7},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=3},
		},
		["Eng 1 Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Mod2"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Mod2"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Mod2"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng1Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng1Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng1Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng1Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng1Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=10},
		},
		["Eng 1 Spectral Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Filter"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Filter"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Filter"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng1Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng1Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng1Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng1Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng1Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=127},
			["Fader 6"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-7_8-7"]={template="FLFO", inverted=true, defaultvalue=7},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Eng 1 Harmonics"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Harm"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Harm"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Harm"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng1Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng1Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng1Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng1Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng1Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FOsc"},
		},
		["Eng 1 Unison"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Unison"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Unison"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Unison"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng1Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng1Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng1Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng1Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng1Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true, defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDEffect", defaultvalue=4},
			["Fader 5"]={template="FEffect", defaultvalue=127},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect", defaultvalue=89},
		},
		["Eng 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng2Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng2Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng2Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng2Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng2Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=2},
			["UDVButton 3-3_4-3"]={template="UDFreq2", defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDFreq", defaultvalue=50},
			["MFader 7-3"]={template="UDPerf", defaultvalue=127},
			["UDVButton 1-4_2-4"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 5"]={template="FOsc", defaultvalue=0},
			["Button 8-4"]={template="BRedOnOff"},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=6},
			["Fader 7"]={template="FLFO", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Eng 2 Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Mod1"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Mod1"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Mod1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng2Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng2Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng2Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng2Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng2Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=7},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=3},
		},
		["Eng 2 Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Mod2"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Mod2"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Mod2"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng2Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng2Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng2Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng2Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng2Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=10},
		},
		["Eng 2 Spectral Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Filter"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Filter"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Filter"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng2Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng2Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng2Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng2Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng2Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=127},
			["Fader 6"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-7_8-7"]={template="FLFO", inverted=true, defaultvalue=7},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Eng 2 Harmonics"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Harm"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Harm"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Harm"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng2Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng2Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng2Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng2Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng2Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FOsc"},
		},
		["Eng 2 Unison"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Unison"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Unison"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Unison"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng2Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng2Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng2Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng2Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng2Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true, defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDEffect", defaultvalue=4},
			["Fader 5"]={template="FEffect", defaultvalue=127},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect", defaultvalue=89},
		},
		["Eng 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng3Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng3Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng3Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng3Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng3Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=2},
			["UDVButton 3-3_4-3"]={template="UDFreq2", defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDFreq", defaultvalue=50},
			["MFader 7-3"]={template="UDPerf", defaultvalue=127},
			["UDVButton 1-4_2-4"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 5"]={template="FOsc", defaultvalue=0},
			["Button 8-4"]={template="BRedOnOff"},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=6},
			["Fader 7"]={template="FLFO", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Eng 3 Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Mod1"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Mod1"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Mod1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng3Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng3Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng3Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng3Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng3Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=7},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=3},
		},
		["Eng 3 Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Mod2"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Mod2"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Mod2"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng3Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng3Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng3Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng3Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng3Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true, defaultvalue=10},
		},
		["Eng 3 Spectral Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Filter"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Filter"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Filter"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng3Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng3Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng3Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng3Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng3Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=127},
			["Fader 6"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-7_8-7"]={template="FLFO", inverted=true, defaultvalue=7},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Eng 3 Harmonics"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Harm"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Harm"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Harm"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng3Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng3Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng3Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng3Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng3Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FOsc"},
		},
		["Eng 3 Unison"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Unison"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Unison"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Unison"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button A2"]={template="BOscModPage", helptext="Goto Eng3Mod1"},
			["Button A3"]={template="BOscModPage", helptext="Goto Eng3Mod2"},
			["Button A5"]={template="BFilterPage", helptext="Goto Eng3Filter"},
			["Button A6"]={template="BFilterModPage", helptext="Goto Eng3Harm"},
			["Button A7"]={template="BEffectPage", helptext="Goto Eng3Unison"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true, defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDEffect", defaultvalue=4},
			["Fader 5"]={template="FEffect", defaultvalue=127},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect", defaultvalue=89},
		},
		["LFO 1"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=11},
			["Fader 4"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["LFO 2"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=11},
			["Fader 4"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["LFO 3"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=11},
			["Fader 4"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 1"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 2"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 3"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 4"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env4"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Effects"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
		},
		["Phaser"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 5-1_6-1"]={template="UDEffect", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=102},
			["Fader 4"]={template="FFreq", defaultvalue=25},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 7"]={template="FEffect", defaultvalue=76},
		},
		["Dist"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 5-1_6-1"]={template="UDEffect", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FOsc", defaultvalue=102},
			["Fader 7"]={template="FEffect", defaultvalue=127},
		},
		["Eq"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 4"]={template="FFreq", defaultvalue=13},
			["Fader 5"]={template="FEffect", defaultvalue=13},
			["Fader 7"]={template="FAmount", defaultvalue=64},
		},
		["Delay"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=13},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=4},
			["Fader 4"]={template="FEffect", defaultvalue=25},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 7"]={template="FEffect", defaultvalue=16},
		},
		["Comp"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=89},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 7"]={template="FEffect", defaultvalue=76},
		},
		["Mod Matrix 1"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=8},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 2"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=9},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 3"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=4},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 4"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=5},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 5"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 6"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 7"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 8"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Eng1Osc"},
			["Button B3"]={template="BOscPage", helptext="Goto Eng2Osc"},
			["Button B4"]={template="BOscPage", helptext="Goto Eng3Osc"},
			["Button B5"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B6"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B7"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
	},
	["Grain"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button 1-3"]={helptext="Goto Amp"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto Sample"},
			["Button 2-2"]={helptext="Goto Grains"},
			["Button 2-3"]={helptext="Goto Pitch"},
			["Button 2-4"]={helptext="Goto Osc"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 7-1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button 7-2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button 7-3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button 7-4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button 8-1"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button 8-2"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button 8-3"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button 8-4"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["Button 6-5"]={helptext="Goto LFO1"},
			["Button 7-5"]={helptext="Goto LFO2"},
			["Button 8-5"]={helptext="Goto LFO3"},
			["Button 5-6"]={helptext="Goto Env1"},
			["Button 6-6"]={helptext="Goto Env2"},
			["Button 7-6"]={helptext="Goto Env3"},
			["Button 8-6"]={helptext="Goto Env4"},
			["Button 1-8"]={helptext="Goto Effects"},
			["Button 2-8"]={helptext="Goto Phaser"},
			["Button 3-8"]={helptext="Goto Dist"},
			["Button 4-8"]={helptext="Goto Eq"},
			["Button 5-8"]={helptext="Goto Delay"},
			["Button 6-8"]={helptext="Goto Comp"},
			["Button 7-8"]={helptext="Goto Reverb"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Fader 8"]={template="FGain", defaultvalue=89},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 7-1_8-1"]={template="UDPerf2", defaultvalue=2},
			["UDVButton 7-3_8-3"]={template="UDPerf", defaultvalue=2},
			["Fader 4"]={template="FPerf", defaultvalue=32},
			["UDVButton 7-6_8-6"]={template="UDPerf", defaultvalue=2},
			["UDVButton 7-8_8-8"]={template="UDOsc", defaultvalue=7},
		},
		["Sample"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Fader 1"]={template="FMisc", defaultvalue=36},
			["Fader 2"]={template="FMisc", defaultvalue=0},
			["Fader 3"]={template="UDOsc", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=127},
			["UDVButton 1-5_2-5"]={template="UDOsc", inverted=true, defaultvalue=2},
			["Fader 6"]={template="FFreq", defaultvalue=64},
			["Fader 7"]={template="FOsc", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Grains"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Grains"},
			["Button A2"]={template="BOscModPage", helptext="Goto Pitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Osc"},
			["UDVButton 1-1_2-1"]={template="UDOsc", inverted=true, defaultvalue=2},
			["Spectral Grains"]={
				["Fader 2"]={template="FOsc", defaultvalue=0},
				["Fader 3"]={template="FFreq", defaultvalue=0},
				["Button 1-4"]={template="BRedOnOff"},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=2},
				["Fader 5"]={template="FOsc", defaultvalue=127},
				["Fader 6"]={template="FEffect", defaultvalue=64},
				["Fader 7"]={template="FOsc", defaultvalue=64},
				["Fader 8"]={template="FPerf", defaultvalue=127},
			},
			["Grain Oscillator"]={
				["Fader 2"]={template="FOsc", defaultvalue=0},
				["Fader 3"]={template="FOsc", defaultvalue=0},
				["Fader 4"]={template="FFreq", defaultvalue=89},
				["Fader 5"]={template="FOsc", defaultvalue=64},
				["Fader 6"]={template="FEffect", defaultvalue=64},
				["Fader 7"]={template="FOsc", defaultvalue=64},
				["Fader 8"]={template="FPerf", defaultvalue=127},
			},
			["Long Grains"]={
				["Fader 2"]={template="FOsc", defaultvalue=0},
				["Fader 3"]={template="FOsc", defaultvalue=0},
				["Fader 5"]={template="FOsc", defaultvalue=89},
				["Fader 6"]={template="FFreq", defaultvalue=64},
				["Fader 7"]={template="FOsc", defaultvalue=89},
			},
			["Tape"]={
				["Fader 6"]={template="FOsc"},
			},
		},
		["Pitch"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Pitch"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Grains"},
			["Button A2"]={template="BOscModPage", helptext="Goto Pitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Osc"},
			["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=50},
			["Fader 6"]={template="FPerf", defaultvalue=127},
		},
		["Osc"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Grains"},
			["Button A2"]={template="BOscModPage", helptext="Goto Pitch"},
			["Button A5"]={template="BOscPage", helptext="Goto Osc"},
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-4_2-4"]={template="UDOsc", defaultvalue=0},
			["Fader 6"]={template="FOsc"},
		},
		["Mixer"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button A2"]={template="BAmpPage", helptext="Goto Amp"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true},
			["Fader 3"]={template="FVol", defaultvalue=89},
			["UDVButton 1-5_2-5"]={template="UDAmount"},
			["Fader 6"]={template="FVol", defaultvalue=89},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=3},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEnv", defaultvalue=0},
			["Fader 7"]={template="FPerf", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button A2"]={template="BAmpPage", helptext="Goto Amp"},
			["Fader 2"]={template="FGain", defaultvalue=6},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Fader 4"]={template="FGain", defaultvalue=127},
			["Fader 5"]={template="FGain", defaultvalue=13},
			["Fader 6"]={template="FAmount", defaultvalue=102},
			["Fader 7"]={template="FPerf", defaultvalue=0},
			["Knob V8"]={template="FGain"},
		},
		["LFO 1"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=11},
			["Fader 4"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["LFO 2"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=11},
			["Fader 4"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["LFO 3"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=11},
			["Fader 4"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO3"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 1"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 2"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env2"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 3"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env3"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Env 4"]={
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env4"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A2"]={template="BEnvPage", helptext="Goto Env2"},
			["Button A3"]={template="BEnvPage", helptext="Goto Env3"},
			["Button A4"]={template="BEnvPage", helptext="Goto Env4"},
			["Button A6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A8"]={template="BLFOPage", helptext="Goto LFO3"},
		},
		["Effects"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
		},
		["Phaser"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 5-1_6-1"]={template="UDEffect", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=102},
			["Fader 4"]={template="FFreq", defaultvalue=25},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 7"]={template="FEffect", defaultvalue=76},
		},
		["Dist"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 5-1_6-1"]={template="UDEffect", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FOsc", defaultvalue=102},
			["Fader 7"]={template="FEffect", defaultvalue=127},
		},
		["Eq"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 4"]={template="FFreq", defaultvalue=13},
			["Fader 5"]={template="FEffect", defaultvalue=13},
			["Fader 7"]={template="FAmount", defaultvalue=64},
		},
		["Delay"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 4-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=13},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=4},
			["Fader 4"]={template="FEffect", defaultvalue=25},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 7"]={template="FEffect", defaultvalue=16},
		},
		["Comp"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button A3"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A5"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A6"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=89},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 7"]={template="FEffect", defaultvalue=76},
		},
		["Mod Matrix 1"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=8},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 2"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=9},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 3"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=4},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 4"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=5},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 5"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 6"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 7"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
		["Mod Matrix 8"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true, defaultvalue=0},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Sample"},
			["Button B3"]={template="BOscPage", helptext="Goto Grains"},
			["Button B4"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix8"},
		},
	},
	["Humana"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Amp"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto Instrument"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 2-8"]={helptext="Goto Delay"},
			["Button 3-8"]={helptext="Goto Reverb"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=6},
			["Fader 8"]={template="FVol", defaultvalue=80},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 7-1_8-1"]={template="UDPerf", defaultvalue=2},
			["Fader 2"]={template="FOsc", defaultvalue=99},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FVol", defaultvalue=64},
		},
		["Instrument"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=6},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=12},
			["UDVButton 1-7_2-7"]={template="UDFreq", defaultvalue=50},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=44},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=83},
			["Fader 7"]={template="FPerf", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Filter Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FEnv", defaultvalue=83},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=56},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FPerf", defaultvalue=67},
			["Fader 4"]={template="FVol", defaultvalue=0},
			["Fader 5"]={template="FVol", defaultvalue=80},
			["Fader 6"]={template="FVol", defaultvalue=127},
			["Fader 7"]={template="FVol", defaultvalue=94},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=38},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=6},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=65},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=45},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=70},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=34},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 8"]={template="FEffect", defaultvalue=45},
		},
	},
	["ID8"]={
		["Keyboard"]={
			["Button B1"]={helptext="Goto Main"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button 1-1"]={template="BSelCat"},
			["Button 2-1"]={template="BSelCat"},
			["Button 1-4"]={template="BSelSound"},
			["Button 2-4"]={template="BSelSound"},
			["Button 3-4"]={template="BSelSound"},
			["Button 4-4"]={template="BSelSound"},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=0},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
	},
	["Klang"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Amp"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto Instrument"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 2-8"]={helptext="Goto Delay"},
			["Button 3-8"]={helptext="Goto Reverb"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=2},
			["Fader 8"]={template="FVol", defaultvalue=80},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 7-1_8-1"]={template="UDPerf", defaultvalue=2},
			["Fader 2"]={template="FOsc", defaultvalue=99},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FVol", defaultvalue=64},
		},
		["Instrument"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=2},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=12},
			["UDVButton 1-7_2-7"]={template="UDFreq", defaultvalue=50},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=44},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=83},
			["Fader 7"]={template="FPerf", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Filter Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FEnv", defaultvalue=83},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=56},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FPerf", defaultvalue=67},
			["Fader 4"]={template="FVol", defaultvalue=0},
			["Fader 5"]={template="FVol", defaultvalue=80},
			["Fader 6"]={template="FVol", defaultvalue=127},
			["Fader 7"]={template="FVol", defaultvalue=94},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=38},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=6},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=65},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=45},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=70},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=34},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 8"]={template="FEffect", defaultvalue=45},
		},
	},
	["Kong"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-5"]={helptext="Goto MutesSolos"},
			["Button 2-8"]={helptext="Goto BusFX"},
			["Button 3-8"]={helptext="Goto MasterFX"},
			["Button 5-1"]={template="BOscPageHigh", helptext="Goto Drum13"},
			["Button 5-2"]={template="BOscPageHigh", helptext="Goto Drum14"},
			["Button 5-3"]={template="BOscPageHigh", helptext="Goto Drum15"},
			["Button 5-4"]={template="BOscPageHigh", helptext="Goto Drum16"},
			["Button 6-1"]={template="BOscPageHigh", helptext="Goto Drum9"},
			["Button 6-2"]={template="BOscPageHigh", helptext="Goto Drum10"},
			["Button 6-3"]={template="BOscPageHigh", helptext="Goto Drum11"},
			["Button 6-4"]={template="BOscPageHigh", helptext="Goto Drum12"},
			["Button 7-1"]={template="BOscPageHigh", helptext="Goto Drum5"},
			["Button 7-2"]={template="BOscPageHigh", helptext="Goto Drum6"},
			["Button 7-3"]={template="BOscPageHigh", helptext="Goto Drum7"},
			["Button 7-4"]={template="BOscPageHigh", helptext="Goto Drum8"},
			["Button 8-1"]={template="BOscPageHigh", helptext="Goto Drum1"},
			["Button 8-2"]={template="BOscPageHigh", helptext="Goto Drum2"},
			["Button 8-3"]={template="BOscPageHigh", helptext="Goto Drum3"},
			["Button 8-4"]={template="BOscPageHigh", helptext="Goto Drum4"},
			["Button 5-5"]={template="BPerformancePageHigh", helptext="Goto Pad13"},
			["Button 5-6"]={template="BPerformancePageHigh", helptext="Goto Pad14"},
			["Button 5-7"]={template="BPerformancePageHigh", helptext="Goto Pad15"},
			["Button 5-8"]={template="BPerformancePageHigh", helptext="Goto Pad16"},
			["Button 6-5"]={template="BPerformancePageHigh", helptext="Goto Pad9"},
			["Button 6-6"]={template="BPerformancePageHigh", helptext="Goto Pad10"},
			["Button 6-7"]={template="BPerformancePageHigh", helptext="Goto Pad11"},
			["Button 6-8"]={template="BPerformancePageHigh", helptext="Goto Pad12"},
			["Button 7-5"]={template="BPerformancePageHigh", helptext="Goto Pad5"},
			["Button 7-6"]={template="BPerformancePageHigh", helptext="Goto Pad6"},
			["Button 7-7"]={template="BPerformancePageHigh", helptext="Goto Pad7"},
			["Button 7-8"]={template="BPerformancePageHigh", helptext="Goto Pad8"},
			["Button 8-5"]={template="BPerformancePageHigh", helptext="Goto Pad1"},
			["Button 8-6"]={template="BPerformancePageHigh", helptext="Goto Pad2"},
			["Button 8-7"]={template="BPerformancePageHigh", helptext="Goto Pad3"},
			["Button 8-8"]={template="BPerformancePageHigh", helptext="Goto Pad4"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button 5-1"]={template="BPad"},
			["Button 5-2"]={template="BPad"},
			["Button 5-3"]={template="BPad"},
			["Button 5-4"]={template="BPad"},
			["Button 6-1"]={template="BPad"},
			["Button 6-2"]={template="BPad"},
			["Button 6-3"]={template="BPad"},
			["Button 6-4"]={template="BPad"},
			["Button 7-1"]={template="BPad"},
			["Button 7-2"]={template="BPad"},
			["Button 7-3"]={template="BPad"},
			["Button 7-4"]={template="BPad"},
			["Button 8-1"]={template="BPad"},
			["Button 8-2"]={template="BPad"},
			["Button 8-3"]={template="BPad"},
			["Button 8-4"]={template="BPad"},
			["Fader 6"]={template="FVol", defaultvalue=100},
		},
		["Mutes & Solos"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BMute"},
			["Button 1-4"]={template="BMute"},
			["Button 2-1"]={template="BMute"},
			["Button 2-2"]={template="BMute"},
			["Button 2-3"]={template="BMute"},
			["Button 2-4"]={template="BMute"},
			["Button 3-1"]={template="BMute"},
			["Button 3-2"]={template="BMute"},
			["Button 3-3"]={template="BMute"},
			["Button 3-4"]={template="BMute"},
			["Button 4-1"]={template="BMute"},
			["Button 4-2"]={template="BMute"},
			["Button 4-3"]={template="BMute"},
			["Button 4-4"]={template="BMute"},
			["Button 1-5"]={template="BSolo"},
			["Button 1-6"]={template="BSolo"},
			["Button 1-7"]={template="BSolo"},
			["Button 1-8"]={template="BSolo"},
			["Button 2-5"]={template="BSolo"},
			["Button 2-6"]={template="BSolo"},
			["Button 2-7"]={template="BSolo"},
			["Button 2-8"]={template="BSolo"},
			["Button 3-5"]={template="BSolo"},
			["Button 3-6"]={template="BSolo"},
			["Button 3-7"]={template="BSolo"},
			["Button 3-8"]={template="BSolo"},
			["Button 4-5"]={template="BSolo"},
			["Button 4-6"]={template="BSolo"},
			["Button 4-7"]={template="BSolo"},
			["Button 4-8"]={template="BSolo"},
		},
		["Drum 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum3"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum4"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum5"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum6"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum7"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum8"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 9"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 10"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum10"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 11"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 12"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum12"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 13"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum13"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 14"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum14"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 15"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum15"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Drum 16"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum16"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum11"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum12"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum13"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum14"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum15"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum16"},
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				["MFader 1-2"]={template="UDOsc"},
				["MFader 3-2"]={template="UDFreq"},
				["MFader 1-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-3"]={template="UDEffect", defaultvalue=0},
				["MFader 3-4"]={template="UDEffect", defaultvalue=0},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDVol", defaultvalue=0},
				["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=6},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol", defaultvalue=100},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Pad 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad8"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad8"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 9"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 10"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 11"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 12"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 13"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 14"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 15"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Pad 16"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad16"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Pad10"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Pad11"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Pad12"},
			["Button A5"]={template="BPerformancePage", helptext="Goto Pad13"},
			["Button A6"]={template="BPerformancePage", helptext="Goto Pad14"},
			["Button A7"]={template="BPerformancePage", helptext="Goto Pad15"},
			["Button A8"]={template="BPerformancePage", helptext="Goto Pad16"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
		},
		["Bus FX"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button 1-2"]={template="BYellowOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FVol", defaultvalue=100},
		},
		["Master FX"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Pad1"},
			["Button B5"]={template="BPerformancePage", helptext="Goto Pad9"},
			["Button B6"]={template="BAmpPage", helptext="Goto MutesSolos"},
			["Button B7"]={template="BEffectPage", helptext="Goto BusFX"},
			["Button B8"]={template="BEffectPage", helptext="Goto MasterFX"},
			["Button 1-2"]={template="BYellowOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
		},
	},
	["Malstrom"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 1-6"]={helptext="Goto Velocity"},
			["Button 1-7"]={helptext="Goto ModWheelContr"},
			["Button 2-1"]={helptext="Goto OscA"},
			["Button 3-1"]={helptext="Goto OscB"},
			["Button 2-2"]={helptext="Goto OscAEnv"},
			["Button 3-2"]={helptext="Goto OscBEnv"},
			["Button 2-5"]={helptext="Goto FilterA"},
			["Button 3-5"]={helptext="Goto FilterB"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 5-5"]={helptext="Goto ModA"},
			["Button 6-5"]={helptext="Goto ModB"},
			["Button 2-8"]={helptext="Goto Shaper"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Fader 7"]={template="FEffect", defaultvalue=0},
			["Fader 8"]={template="FGain", defaultvalue=90},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BPerfPage", helptext="Goto Perf"},
			["Button A2"]={template="BPerfPage", helptext="Goto Velocity"},
			["Button A3"]={template="BPerfPage", helptext="Goto ModWheelContr"},
			["UDVButton 7-2_8-2"]={template="FPerf", defaultvalue=7},
			["Button 8-3"]={template="BYellowOnOff"},
			["Fader 4"]={template="FPerf", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="FPerf", defaultvalue=7},
		},
		["Osc A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscModPage", helptext="Goto OscAEnv"},
			["Button A5"]={template="BOscPage", helptext="Goto OscB"},
			["Button A6"]={template="BOscModPage", helptext="Goto OscBEnv"},
			["Button 1-1"]={template="BYellowOnOff"},
			["Fader 2"]={template="FOsc", defaultvalue=64},
			["Fader 3"]={template="FOsc", defaultvalue=0},
			["Knob V4"]={template="FOsc"},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=4},
			["UDVButton 7-6_8-6"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-7_8-7"]={template="UDFreq", defaultvalue=50},
			["Button 7-8"]={template="BYellowOnOff"},
			["Button 8-8"]={template="BYellowOnOff"},
		},
		["Osc A Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscAEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscModPage", helptext="Goto OscAEnv"},
			["Button A5"]={template="BOscPage", helptext="Goto OscB"},
			["Button A6"]={template="BOscModPage", helptext="Goto OscBEnv"},
			["Fader 3"]={template="FOsc", defaultvalue=12},
			["Fader 4"]={template="FOsc", defaultvalue=100},
			["Fader 5"]={template="FOsc", defaultvalue=127},
			["Fader 6"]={template="FOsc", defaultvalue=10},
			["Fader 8"]={template="FVol", defaultvalue=90},
		},
		["Osc B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscB"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscModPage", helptext="Goto OscAEnv"},
			["Button A5"]={template="BOscPage", helptext="Goto OscB"},
			["Button A6"]={template="BOscModPage", helptext="Goto OscBEnv"},
			["Button 1-1"]={template="BYellowOnOff"},
			["Fader 2"]={template="FOsc", defaultvalue=64},
			["Fader 3"]={template="FOsc", defaultvalue=0},
			["Knob V4"]={template="FOsc"},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=4},
			["UDVButton 7-6_8-6"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-7_8-7"]={template="UDFreq", defaultvalue=50},
			["Button 8-8"]={template="BYellowOnOff"},
		},
		["Osc B Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscBEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BOscPage", helptext="Goto OscA"},
			["Button A2"]={template="BOscModPage", helptext="Goto OscAEnv"},
			["Button A5"]={template="BOscPage", helptext="Goto OscB"},
			["Button A6"]={template="BOscModPage", helptext="Goto OscBEnv"},
			["Fader 3"]={template="FOsc", defaultvalue=12},
			["Fader 4"]={template="FOsc", defaultvalue=100},
			["Fader 5"]={template="FOsc", defaultvalue=127},
			["Fader 6"]={template="FOsc", defaultvalue=10},
			["Fader 8"]={template="FVol", defaultvalue=90},
		},
		["Filter A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button A2"]={template="BFilterPage", helptext="Goto FilterB"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Button 8-5"]={template="BYellowOnOff"},
			["Button 8-6"]={template="BYellowOnOff"},
		},
		["Filter B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterB"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button A2"]={template="BFilterPage", helptext="Goto FilterB"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Button 8-5"]={template="BYellowOnOff"},
			["Button 8-6"]={template="BYellowOnOff"},
			["Button 1-6"]={template="BYellowOnOff"},
		},
		["Filter Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterEnv"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button A2"]={template="BFilterPage", helptext="Goto FilterB"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=100},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=10},
			["Button 8-7"]={template="BYellowOnOff"},
			["Fader 8"]={template="FEnv", defaultvalue=0},
		},
		["Shaper"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button 1-2"]={template="BYellowOnOff"},
			["UDVButton 1-3_2-3"]={template="FEffect", inverted=true, defaultvalue=0},
			["Fader 8"]={template="FEffect", defaultvalue=64},
		},
		["Mod A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BLFOPage", helptext="Goto ModA"},
			["Button A2"]={template="BLFOPage", helptext="Goto ModB"},
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FOsc"},
			["Knob V6"]={template="FOsc"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["UDVButton 7-8_8-8"]={template="UDLFO", defaultvalue=1},
		},
		["Mod B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModB"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BLFOPage", helptext="Goto ModA"},
			["Button A2"]={template="BLFOPage", helptext="Goto ModB"},
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FFreq"},
			["Knob V7"]={template="FLFO"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["UDVButton 7-8_8-8"]={template="UDLFO", defaultvalue=1},
		},
		["Velocity"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BPerfPage", helptext="Goto Perf"},
			["Button A2"]={template="BPerfPage", helptext="Goto Velocity"},
			["Button A3"]={template="BPerfPage", helptext="Goto ModWheelContr"},
			["Knob V2"]={template="FOsc"},
			["Knob V3"]={template="FOsc"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FLFO"},
			["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=1},
		},
		["ModWheel"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OscA"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterA"},
			["Button B4"]={template="BLFOPage", helptext="Goto ModA"},
			["Button B7"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button B8"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A1"]={template="BPerfPage", helptext="Goto Perf"},
			["Button A2"]={template="BPerfPage", helptext="Goto Velocity"},
			["Button A3"]={template="BPerfPage", helptext="Goto ModWheelContr"},
			["Knob V2"]={template="FOsc"},
			["Knob V3"]={template="FOsc"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FLFO"},
			["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=1},
		},
	},
	["External Midi Instrument"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 4-1"]={template="BRedOnOff"},
			["CC 0"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 1"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 2"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 3"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 4"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 5"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 6"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 7"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 8"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 9"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 10"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 11"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 12"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 13"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 14"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 15"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 16"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 17"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 18"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 19"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 20"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 21"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 22"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 23"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 24"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 25"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 26"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 27"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 28"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 29"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 30"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 31"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 32"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 33"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 34"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 35"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 36"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 37"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 38"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 39"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 40"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 41"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 42"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 43"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 44"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 45"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 46"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 47"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 48"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 49"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 50"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 51"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 52"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 53"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 54"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 55"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 56"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 57"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 58"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 59"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 60"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 61"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 62"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 63"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 64"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 65"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 66"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 67"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 68"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 69"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 70"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 71"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 72"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 73"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 74"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 75"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 76"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 77"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 78"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 79"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 80"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 81"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 82"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 83"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 84"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 85"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 86"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 87"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 88"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 89"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 90"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 91"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 92"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 93"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 94"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 95"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 96"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 97"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 98"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 99"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 100"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 101"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 102"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 103"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 104"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 105"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 106"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 107"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 108"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 109"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 110"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 111"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 112"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 113"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 114"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 115"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 116"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 117"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 118"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["CC 119"]={
				["Fader 4"]={template="FMisc", defaultvalue=0},
			},
			["UDVButton 1-7_2-7"]={template="UDPerf", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
			["UDVButton 3-7_4-7"]={template="UDMisc", defaultvalue=0},
			["Button 3-8"]={template="BRedOnOff"},
			["UDVButton 5-7_6-7"]={template="UDPerf", defaultvalue=0},
		},
	},
	["Monotone"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Amp"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto Osc"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button 5-6"]={helptext="Goto Env"},
			["Button 1-8"]={helptext="Goto Chorus"},
			["Button 2-8"]={helptext="Goto Delay"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Fader 8"]={template="FVol", defaultvalue=89},
		},
		["Osc"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["UDVButton 1-1_2-1"]={template="UDOsc", defaultvalue=0},
			["UDVButton 3-1_4-1"]={template="UDFreq", defaultvalue=1},
			["Knob V3"]={template="FVol"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["UDVButton 1-5_2-5"]={template="UDOsc", defaultvalue=3},
			["UDVButton 3-5_4-5"]={template="UDFreq", defaultvalue=1},
			["UDVButton 5-5_6-5"]={template="UDFreq", defaultvalue=12},
			["Fader 6"]={template="FOsc", defaultvalue=13},
			["Fader 7"]={template="FLFO", defaultvalue=0},
			["Fader 8"]={template="FLFO", defaultvalue=0},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Fader 1"]={template="FGain", defaultvalue=64},
			["Fader 2"]={template="FFreq", defaultvalue=38},
			["Fader 3"]={template="FEffect", defaultvalue=25},
			["Fader 5"]={template="FEnv", defaultvalue=51},
			["Fader 6"]={template="FPerf", defaultvalue=25},
			["Fader 7"]={template="FLFO", defaultvalue=0},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Fader 1"]={template="FVol", defaultvalue=5},
			["Fader 2"]={template="FVol", defaultvalue=64},
			["Fader 3"]={template="FVol", defaultvalue=64},
			["Fader 4"]={template="FVol", defaultvalue=13},
			["Fader 6"]={template="FPerf", defaultvalue=0},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Fader 1"]={template="FFreq", defaultvalue=64},
			["UDVButton 1-2_2-2"]={template="FLFO", defaultvalue=1},
		},
		["Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Fader 1"]={template="FEnv", defaultvalue=0},
			["Fader 2"]={template="FEnv", defaultvalue=51},
			["Fader 3"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=89},
			["Fader 6"]={template="FPerf", defaultvalue=64},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["UDVButton 1-1_2-1"]={template="UDPerf", defaultvalue=1},
			["Fader 2"]={template="FPerf", defaultvalue=0},
			["Button 1-3"]={template="BRedOnOff"},
			["UDVButton 1-4_2-4"]={template="UDPerf", defaultvalue=2},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FLFO", defaultvalue=64},
		},
		["Chorus"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A1"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A2"]={template="BEffectPage", helptext="Goto Delay"},
			["Fader 1"]={template="FEffect", defaultvalue=0},
			["Fader 2"]={template="FFreq", defaultvalue=51},
			["Fader 3"]={template="FEffect", defaultvalue=97},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BPerfPage", helptext="Goto Perf"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button A2"]={template="BEffectPage", helptext="Goto Delay"},
			["Fader 1"]={template="FEffect", defaultvalue=0},
			["Fader 2"]={template="FFreq", defaultvalue=51},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Button 1-4"]={template="BRedOnOff"},
		},
	},
	["NN-19"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Amp"},
			["Button 1-4"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button 1-5"]={helptext="Goto Controller"},
			["Button 1-6"]={helptext="Goto ModWheelContr"},
			["Button 1-7"]={helptext="Goto Velocity"},
			["Button 2-1"]={helptext="Goto Osc"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Controller"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Fader 1"]={template="FPerf", defaultvalue=0},
			["UDVButton 1-2_2-2"]={template="UDPerf", defaultvalue=5},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=127},
			["Button 1-5"]={template="BRedOnOff"},
			["UDVButton 1-6_2-6"]={template="UDPerf", inverted=true, defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="UDPerf", defaultvalue=7},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Fader 1"]={template="FVol", defaultvalue=100},
			["Fader 3"]={template="FVol", defaultvalue=0},
			["Fader 4"]={template="FVol", defaultvalue=64},
			["Fader 5"]={template="FVol", defaultvalue=127},
			["Fader 6"]={template="FVol", defaultvalue=10},
		},
		["Controller"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Controller"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Controller"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FLFO"},
			["Knob V4"]={template="FVol"},
			["UDVButton 1-5_2-5"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Wheel"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Controller"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FEffect"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FLFO"},
		},
		["Velocity"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Controller"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A4"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FVol"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FVol"},
		},
		["Osc"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Fader 1"]={template="FOsc", defaultvalue=0},
			["Button 1-2"]={template="BRedOnOff"},
			["Knob V3"]={template="FOsc"},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=4},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="UDFreq", defaultvalue=50},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", inverted=true, defaultvalue=3},
			["Fader 6"]={template="FPerf", defaultvalue=0},
		},
		["Filter Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterEnv"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Fader 2"]={template="FFreq", defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Button 1-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FEnv", defaultvalue=0},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["UDVButton 1-2_2-2"]={template="UDLFO", inverted=true, defaultvalue=0},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=8},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 1-6_2-6"]={template="UDLFO", inverted=true, defaultvalue=0},
		},
	},
	["NN-XT"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FEffect"},
			["Knob V4"]={template="FVol"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FVol"},
			["Knob V7"]={template="FEnv"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
	},
	["Pangea"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Amp"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto Instrument"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 2-8"]={helptext="Goto Delay"},
			["Button 3-8"]={helptext="Goto Reverb"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=9},
			["Fader 8"]={template="FVol", defaultvalue=80},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 7-1_8-1"]={template="UDPerf", defaultvalue=2},
			["Fader 2"]={template="FOsc", defaultvalue=99},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FVol", defaultvalue=64},
		},
		["Instrument"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=9},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=12},
			["UDVButton 1-7_2-7"]={template="UDFreq", defaultvalue=50},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=44},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=83},
			["Fader 7"]={template="FPerf", defaultvalue=0},
			["Fader 8"]={template="FPerf", defaultvalue=0},
		},
		["Filter Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FEnv", defaultvalue=83},
			["Fader 4"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=56},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 2"]={template="FPerf", defaultvalue=67},
			["Fader 4"]={template="FVol", defaultvalue=0},
			["Fader 5"]={template="FVol", defaultvalue=80},
			["Fader 6"]={template="FVol", defaultvalue=127},
			["Fader 7"]={template="FVol", defaultvalue=94},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=38},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=6},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=65},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=45},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Instrument"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=70},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=34},
			["Fader 6"]={template="FFreq", defaultvalue=0},
			["Fader 8"]={template="FEffect", defaultvalue=45},
		},
	},
	["Parsec"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto AmpEnv"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto GenereratorA"},
			["Button 3-1"]={helptext="Goto GenereratorB"},
			["Button 2-5"]={helptext="Goto SoundEngineA"},
			["Button 3-5"]={helptext="Goto SoundEngineB"},
			["Button 2-8"]={helptext="Goto Reverb"},
			["Button 3-8"]={helptext="Goto Delay"},
			["Button 5-5"]={helptext="Goto LFO1"},
			["Button 6-5"]={helptext="Goto LFO2"},
			["Button 5-6"]={helptext="Goto Env1"},
			["Button 6-6"]={helptext="Goto Env2"},
			["Button 8-1"]={template="BPerformancePageHigh", helptext="Goto ModMatrix1"},
			["Button 8-2"]={template="BPerformancePageHigh", helptext="Goto ModMatrix2"},
			["Button 8-3"]={template="BPerformancePageHigh", helptext="Goto ModMatrix3"},
			["Button 8-4"]={template="BPerformancePageHigh", helptext="Goto ModMatrix4"},
			["Button 8-5"]={template="BPerformancePageHigh", helptext="Goto ModMatrix5"},
			["Button 8-6"]={template="BPerformancePageHigh", helptext="Goto ModMatrix6"},
			["Button 8-7"]={template="BPerformancePageHigh", helptext="Goto ModMatrix7"},
			["Button 8-8"]={template="BPerformancePageHigh", helptext="Goto ModMatrix8"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Knob V6"]={template="FVol"},
			["Fader 7"]={template="FEffect", defaultvalue=0},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["UDVButton 7-1_8-1"]={template="UDPerf", defaultvalue=2},
			["UDVButton 7-3_8-3"]={template="UDPerf", defaultvalue=2},
			["UDVButton 7-5_8-5"]={template="UDPerf", defaultvalue=2},
			["Fader 6"]={template="FPerf", defaultvalue=38},
		},
		["Amp Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Fader 2"]={template="FGain", defaultvalue=64},
			["Fader 4"]={template="FVol", defaultvalue=0},
			["Fader 5"]={template="FVol", defaultvalue=64},
			["Fader 6"]={template="FVol", defaultvalue=127},
			["Fader 7"]={template="FVol", defaultvalue=13},
		},
		["Generator A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button A2"]={template="BOscPage", helptext="Goto GenereratorB"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Button 8-1"]={template="BBlueOnOff"},
			["Fader 3"]={template="FOsc", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="UDFreq", defaultvalue=50},
			["MFader 1-8"]={template="FPerf", defaultvalue=127},
			["MFader 3-5"]={template="FEffect", defaultvalue=64},
			["MFader 3-6"]={template="FFreq", defaultvalue=64},
			["MFader 3-7"]={template="FPerf", defaultvalue=64},
		},
		["Sound Engine A"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineB"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button A2"]={template="BFilterPage", helptext="Goto SoundEngineB"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["UDVButton 1-5_2-5"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=64},
		},
		["Generator B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button A2"]={template="BOscPage", helptext="Goto GenereratorB"},
			["Button 1-1"]={template="BBlueOnOff"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Button 8-1"]={template="BBlueOnOff"},
			["Fader 3"]={template="FOsc", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=2},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="UDFreq", defaultvalue=50},
			["MFader 1-8"]={template="FPerf", defaultvalue=127},
			["MFader 3-5"]={template="FEffect", defaultvalue=64},
			["MFader 3-6"]={template="FFreq", defaultvalue=64},
			["MFader 3-7"]={template="FPerf", defaultvalue=64},
		},
		["Sound Engine B"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineB"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button A2"]={template="BFilterPage", helptext="Goto SoundEngineB"},
			["Button 1-1"]={template="BBlueOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["UDVButton 1-5_2-5"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=64},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button 1-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 8"]={template="FEffect", defaultvalue=51},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button 1-2"]={template="BBlueOnOff"},
			["Button 8-3"]={template="BBlueOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=4},
			["Fader 5"]={template="FEffect", defaultvalue=38},
			["Fader 8"]={template="FEffect", defaultvalue=51},
		},
		["LFO 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A5"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A6"]={template="BEnvPage", helptext="Goto Env2"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
		},
		["LFO 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A5"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A6"]={template="BEnvPage", helptext="Goto Env2"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 8-3"]={template="BBlueOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=10},
		},
		["Env 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto Env1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A5"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A6"]={template="BEnvPage", helptext="Goto Env2"},
			["Fader 3"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=64},
			["Fader 5"]={template="FEnv", defaultvalue=0},
			["Fader 6"]={template="FEnv", defaultvalue=64},
		},
		["Env 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto Env2"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A5"]={template="BEnvPage", helptext="Goto Env1"},
			["Button A6"]={template="BEnvPage", helptext="Goto Env2"},
			["Button 1-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEnv", defaultvalue=64},
			["Fader 7"]={template="FEnv", defaultvalue=0},
			["Fader 8"]={template="FEnv", defaultvalue=64},
		},
		["Mod Matrix 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=2},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=3},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=5},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=6},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
		["Mod Matrix 8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto GenereratorA"},
			["Button B3"]={template="BFilterPage", helptext="Goto SoundEngineA"},
			["Button B4"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B5"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B6"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A1"]={template="BPerformancePage", helptext="Goto ModMatrix1"},
			["Button A2"]={template="BPerformancePage", helptext="Goto ModMatrix2"},
			["Button A3"]={template="BPerformancePage", helptext="Goto ModMatrix3"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModMatrix4"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ModMatrix5"},
			["Button A6"]={template="BPerformancePage", helptext="Goto ModMatrix6"},
			["Button A7"]={template="BPerformancePage", helptext="Goto ModMatrix7"},
			["Button A8"]={template="BPerformancePage", helptext="Goto ModMatrix8"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true, defaultvalue=0},
		},
	},
	["PX7"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 2-1"]={helptext="Goto OP6"},
			["Button 3-1"]={helptext="Goto OP5"},
			["Button 4-1"]={helptext="Goto OP4"},
			["Button 5-1"]={helptext="Goto OP3"},
			["Button 6-1"]={helptext="Goto OP2"},
			["Button 7-1"]={helptext="Goto OP1"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["UDVButton 1-2_2-2"]={template="FOsc", defaultvalue=0},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FOsc"},
			["Knob V6"]={template="FVol"},
			["Knob V7"]={template="FVol"},
			["Fader 8"]={template="FVol", defaultvalue=90},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Fader 3"]={template="FPerf", defaultvalue=40},
		},
		["Op1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=1},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=7},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain", defaultvalue=127	},
		},
		["Op2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=1},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=7},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain", defaultvalue=0	},
		},
		["Op3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=1},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=7},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain", defaultvalue=0	},
		},
		["Op4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=1},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=7},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain", defaultvalue=0	},
		},
		["Op5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=1},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=7},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain", defaultvalue=0	},
		},
		["Op6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=1},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=7},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain", defaultvalue=0	},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto OP6"},
			["Button B3"]={template="BOscPage", helptext="Goto OP5"},
			["Button B4"]={template="BOscPage", helptext="Goto OP4"},
			["Button B5"]={template="BOscPage", helptext="Goto OP3"},
			["Button B6"]={template="BOscPage", helptext="Goto OP2"},
			["Button B7"]={template="BOscPage", helptext="Goto OP1"},
			["Button B8"]={template="BLFOPage", helptext="Goto LFO"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq", defaultvalue=26},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=12},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDLFO", inverted=true, defaultvalue=4},
		},
	},
	["Radical Piano"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Envelope"},
			["Button 1-5"]={helptext="Goto Velocity"},
			["Button 2-1"]={helptext="Goto Tune"},
			["Button 2-2"]={helptext="Goto Resonance"},
			["Button 2-3"]={helptext="Goto Mechanics"},
			["Button 2-8"]={helptext="Goto Eq"},
			["Button 3-8"]={helptext="Goto Ambience"},
			["Button 4-8"]={helptext="Goto Output"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Fader 1"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=12},
			["UDVButton 1-4_2-4"]={template="UDOsc", defaultvalue=6},
			["Knob V5"]={template="FOsc"},
			["UDVButton 1-6_2-6"]={template="UDOsc", defaultvalue=6},
			["Fader 8"]={template="FVol", defaultvalue=89},
		},
		["Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Fader 4"]={template="FVol", defaultvalue=0},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FVol"},
		},
		["Velocity"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Fader 4"]={template="FPerf", defaultvalue=38},
			["Fader 5"]={template="FPerf", defaultvalue=64},
			["Knob V6"]={template="FPerf"},
		},
		["Tune"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Knob V4"]={template="FFreq"},
			["Fader 5"]={template="FOsc", defaultvalue=0},
		},
		["Resonance"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FFreq"},
		},
		["Mechanics"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FOsc"},
			["Knob V6"]={template="FOsc"},
		},
		["Eq"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A1"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A2"]={template="BEffectPage", helptext="Goto Ambience"},
			["Button A3"]={template="BEffectPage", helptext="Goto Output"},
			["Button 1-1"]={template="BRedOnOff"},
			["Knob V4"]={template="FEffect"},
			["Knob V5"]={template="FEffect"},
			["Knob V6"]={template="FEffect"},
		},
		["Ambience"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Ambience"},
			["Button A1"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A2"]={template="BEffectPage", helptext="Goto Ambience"},
			["Button A3"]={template="BEffectPage", helptext="Goto Output"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=1},
			["Fader 4"]={template="FEffect", defaultvalue=0},
		},
		["Output"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Tune"},
			["Button B3"]={template="BOscPage", helptext="Goto Resonance"},
			["Button B4"]={template="BOscPage", helptext="Goto Mechanics"},
			["Button B6"]={template="BAmpPage", helptext="Goto Envelope"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Velocity"},
			["Button B8"]={template="BEffectPage", helptext="Goto Output"},
			["Button A1"]={template="BEffectPage", helptext="Goto Eq"},
			["Button A2"]={template="BEffectPage", helptext="Goto Ambience"},
			["Button A3"]={template="BEffectPage", helptext="Goto Output"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Knob V4"]={template="FEffect"},
		},
	},
	["Redrum"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-5"]={helptext="Goto Performance"},
			["Button 6-1"]={template="BOscPageHigh", helptext="Goto Drum9"},
			["Button 6-2"]={template="BOscPageHigh", helptext="Goto Drum10"},
			["Button 7-1"]={template="BOscPageHigh", helptext="Goto Drum5"},
			["Button 7-2"]={template="BOscPageHigh", helptext="Goto Drum6"},
			["Button 7-3"]={template="BOscPageHigh", helptext="Goto Drum7"},
			["Button 7-4"]={template="BOscPageHigh", helptext="Goto Drum8"},
			["Button 8-1"]={template="BOscPageHigh", helptext="Goto Drum1"},
			["Button 8-2"]={template="BOscPageHigh", helptext="Goto Drum2"},
			["Button 8-3"]={template="BOscPageHigh", helptext="Goto Drum3"},
			["Button 8-4"]={template="BOscPageHigh", helptext="Goto Drum4"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button 2-1"]={template="BMute"},
			["Button 2-2"]={template="BSoloRevival"},
			["Button 2-3"]={template="BPlaySel"},
			["Button 3-1"]={template="BOscSel"},
			["Button 3-2"]={template="BOscSel"},
			["Button 3-3"]={template="BOscSel"},
			["Button 3-4"]={template="BOscSel"},
			["Button 3-5"]={template="BOscSel"},
			["Button 3-6"]={template="BOscSel"},
			["Button 3-7"]={template="BOscSel"},
			["Button 3-8"]={template="BOscSel"},
			["Button 4-7"]={template="BOscSel"},
			["Button 4-8"]={template="BOscSel"},
			["Button 6-1"]={template="BRun"},
			["UDVButton 5-2_6-2"]={template="UDPerf", defaultvalue=0},
			["Button 5-4"]={template="BPerformancePage"},
			["Button 5-5"]={template="BPerformancePage"},
			["Button 6-5"]={template="BRedOnOff"},
			["MFader 5-7"]={template="FPerf"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 7-1"]={template="BStep"},
			["Button 7-2"]={template="BStep"},
			["Button 7-3"]={template="BStep"},
			["Button 7-4"]={template="BStep"},
			["Button 7-5"]={template="BStep"},
			["Button 7-6"]={template="BStep"},
			["Button 7-7"]={template="BStep"},
			["Button 7-8"]={template="BStep"},
			["Button 8-1"]={template="BStep"},
			["Button 8-2"]={template="BStep"},
			["Button 8-3"]={template="BStep"},
			["Button 8-4"]={template="BStep"},
			["Button 8-5"]={template="BStep"},
			["Button 8-6"]={template="BStep"},
			["Button 8-7"]={template="BStep"},
			["Button 8-8"]={template="BStep"},
			["Play"]={
				["Button 1-1"]={template="BPad"},
				["Button 1-2"]={template="BPad"},
				["Button 1-3"]={template="BPad"},
				["Button 1-4"]={template="BPad"},
				["Button 1-5"]={template="BPad"},
				["Button 1-6"]={template="BPad"},
				["Button 1-7"]={template="BPad"},
				["Button 1-8"]={template="BPad"},
				["Button 2-7"]={template="BPad"},
				["Button 2-8"]={template="BPad"},
			},
			["Solo"]={
				["Button 1-1"]={template="BSoloRevival"},
				["Button 1-2"]={template="BSoloRevival"},
				["Button 1-3"]={template="BSoloRevival"},
				["Button 1-4"]={template="BSoloRevival"},
				["Button 1-5"]={template="BSoloRevival"},
				["Button 1-6"]={template="BSoloRevival"},
				["Button 1-7"]={template="BSoloRevival"},
				["Button 1-8"]={template="BSoloRevival"},
				["Button 2-7"]={template="BSoloRevival"},
				["Button 2-8"]={template="BSoloRevival"},
			},
			["Mute"]={
				["Button 1-1"]={template="BMute"},
				["Button 1-2"]={template="BMute"},
				["Button 1-3"]={template="BMute"},
				["Button 1-4"]={template="BMute"},
				["Button 1-5"]={template="BMute"},
				["Button 1-6"]={template="BMute"},
				["Button 1-7"]={template="BMute"},
				["Button 1-8"]={template="BMute"},
				["Button 2-7"]={template="BMute"},
				["Button 2-8"]={template="BMute"},
			},
		},
		["Performance"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 2-1"]={template="BPerformancePage"},
			["Button 2-2"]={template="BPerformancePage"},
			["Button 2-3"]={template="BPerformancePage"},
			["Button 2-4"]={template="BPerformancePage"},
			["Button 3-1"]={template="BPerformancePage"},
			["Button 3-2"]={template="BPerformancePage"},
			["Button 3-3"]={template="BPerformancePage"},
			["Button 3-4"]={template="BPerformancePage"},
			["Button 5-1"]={template="BPerformancePage"},
			["Button 5-2"]={template="BPerformancePage"},
			["Button 5-3"]={template="BPerformancePage"},
			["Button 5-4"]={template="BPerformancePage"},
			["UDVButton 7-1_8-1"]={template="FPerf", defaultvalue=15},
			["UDVButton 7-4_8-4"]={template="FFreq", defaultvalue=4},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 1 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum2"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 2 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum2"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum3"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum3"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 3 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum3"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum4"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum4"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 4 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum4"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum5"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum5"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 5 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum5"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum6"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum6"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 6 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum6"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["UDVButton 5-4_6-4"]={template="UDPerf", defaultvalue=64},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum7"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum7"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 7 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum7"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["UDVButton 5-4_6-4"]={template="UDPerf", defaultvalue=64},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum8"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 8 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2Edit"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3Edit"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4Edit"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5Edit"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6Edit"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7Edit"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum8"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum8Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 9"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum9Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 9 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum9Edit"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum9Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
		["Drum 10"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum10"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum10"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum10Edit"},
			["MFader 5-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol", defaultvalue=100},
		},
		["Drum 10 Edit"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B3"]={template="BOscPage", helptext="Goto Drum10Edit"},
			["Button B4"]={template="BPerformancePage", helptext="Goto Performance"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum9Edit"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum10Edit"},
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
			["Button 2-1"]={template="BOscPage", helptext="Goto Drum10"},
			["Button 3-1"]={template="BOscPage", helptext="Goto Drum10Edit"},
			["UDVButton 5-2_6-2"]={template="UDOsc", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=127},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
		},
	},
	["Revival"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Voicing"},
			["Button 1-4"]={helptext="Goto PriSec"},
			["Button 1-5"]={helptext="Goto Solos"},
			["Button 2-1"]={helptext="Goto Attack"},
			["Button 3-1"]={helptext="Goto Primary"},
			["Button 4-1"]={helptext="Goto Secondary"},
			["Button 5-1"]={helptext="Goto Release"},
			["Button 2-2"]={helptext="Goto AttackL"},
			["Button 3-2"]={helptext="Goto PrimaryL"},
			["Button 4-2"]={helptext="Goto SecondaryL"},
			["Button 5-2"]={helptext="Goto ReleaseL"},
			["Button 2-3"]={helptext="Goto AttackU"},
			["Button 3-3"]={helptext="Goto PrimaryU"},
			["Button 4-3"]={helptext="Goto SecondaryU"},
			["Button 5-3"]={helptext="Goto ReleaseU"},
			["Button 2-4"]={template="BFilterPageHigh", helptext="Goto AttackModEnable"},
			["Button 3-4"]={template="BFilterPageHigh", helptext="Goto PrimaryModEnable"},
			["Button 4-4"]={template="BFilterPageHigh", helptext="Goto SecondaryModEnable"},
			["Button 5-4"]={template="BFilterPageHigh", helptext="Goto ReleaseModEnable"},
			["Button 2-5"]={template="BFilterModPageHigh", helptext="Goto AttackMod1"},
			["Button 3-5"]={template="BFilterModPageHigh", helptext="Goto PrimaryMod1"},
			["Button 5-5"]={template="BFilterModPageHigh", helptext="Goto ReleaseMod1"},
			["Button 4-5"]={template="BFilterModPageHigh", helptext="Goto SecondaryMod1"},
			["Button 2-6"]={template="BFilterModPageHigh", helptext="Goto AttackMod2"},
			["Button 3-6"]={template="BFilterModPageHigh", helptext="Goto PrimaryMod2"},
			["Button 4-6"]={template="BFilterModPageHigh", helptext="Goto SecondaryMod2"},
			["Button 5-6"]={template="BFilterModPageHigh", helptext="Goto ReleaseMod2"},
			["Button 2-7"]={template="BFilterModPageHigh", helptext="Goto AttackMod3"},
			["Button 3-7"]={template="BFilterModPageHigh", helptext="Goto PrimaryMod3"},
			["Button 4-7"]={template="BFilterModPageHigh", helptext="Goto SecondaryMod3"},
			["Button 5-7"]={template="BFilterModPageHigh", helptext="Goto ReleaseMod3"},
			["Button 1-8"]={helptext="Goto Effects"},
			["Button 2-8"]={helptext="Goto PreAmp"},
			["Button 3-8"]={helptext="Goto Phaser"},
			["Button 4-8"]={helptext="Goto ModFilter"},
			["Button 5-8"]={helptext="Goto Speaker"},
			["Button 6-8"]={helptext="Goto Reverb"},
			["Button 7-8"]={helptext="Goto Delay"},
			["Button 8-8"]={helptext="Goto Limiter"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 6-2"]={template="BYellowOnOff"},
			["Button 6-3"]={template="BYellowOnOff"},
			["Button 7-2"]={template="BYellowOnOff"},
			["Button 7-3"]={template="BYellowOnOff"},
			["Button 8-2"]={template="BBAmberOnOff"},
			["Button 8-3"]={template="BBAmberOnOff"},
			["Fader 4"]={template="FMisc", defaultvalue=0},
			["Fader 5"]={template="FMisc", defaultvalue=0},
			["Fader 8"]={template="FVol"},
		},
		["Voicing"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-1_2-1"]={template="FOsc", inverted=true, defaultvalue=0},
			["UDVButton 3-1_4-1"]={template="FOsc", inverted=true, defaultvalue=0},
			["UDVButton 5-1_6-1"]={template="FPerf", inverted=true, defaultvalue=0},
			["UDVButton 7-1_8-1"]={template="FOsc", inverted=true, defaultvalue=0},
			["Button 8-2"]={template="BRedOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=24},
			["UDVButton 7-4_8-4"]={template="UDPerf", defaultvalue=1},
			["MFader 1-5"]={template="FOsc", defaultvalue=0},
			["MFader 1-6"]={template="FPerf", defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="FPerf", defaultvalue=0},
			["MFader 3-5"]={template="FPerf", defaultvalue=0},
			["MFader 3-6"]={template="FEffect", defaultvalue=0},
			["MFader 3-7"]={template="FPerf", defaultvalue=0},
			["MFader 5-5"]={template="FEffect", defaultvalue=64},
			["MFader 5-6"]={template="FEffect", defaultvalue=0},
			["MFader 5-7"]={template="FPerf", defaultvalue=64},
		},
		["Pri/Sec"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Knob V4"]={template="FOsc"},
			["Fader 6"]={template="FFreq", defaultvalue=64},
			["Button 1-7"]={template="BRedOnOff"},
		},
		["Solos"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-2_2-2"]={template="UDOsc", defaultvalue=0},
			["Button 8-2"]={template="BSoloRevival"},
			["Button 8-4"]={template="BSoloRevival"},
			["Button 8-6"]={template="BSoloRevival"},
			["Button 8-8"]={template="BSoloRevival"},
		},
		["Attack"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FVol", defaultvalue=64},
			["Fader 5"]={template="FOsc", defaultvalue=0},
			["Fader 6"]={template="FVol", defaultvalue=0},
			["Fader 7"]={template="FVol", defaultvalue=25},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Primary"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FVol", defaultvalue=64},
			["Fader 7"]={template="FVol", defaultvalue=127},
		},
		["Secondary"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FVol", defaultvalue=64},
			["Fader 7"]={template="FVol", defaultvalue=127},
		},
		["Release"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FVol", defaultvalue=64},
			["Fader 5"]={template="FOsc", defaultvalue=0},
			["Fader 6"]={template="FVol", defaultvalue=0},
			["Fader 7"]={template="FVol", defaultvalue=19},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Attack Drawbars Lower"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackL"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryL"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryL"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseL"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["Drawbar 2"]={template="DSub"},
			["Drawbar 3"]={template="DSub"},
			["Drawbar 4"]={template="DFund"},
			["Drawbar 5"]={template="DFund"},
			["Drawbar 6"]={template="DHarm"},
			["Drawbar 7"]={template="DFund"},
			["Drawbar 8"]={template="DHarm"},
		},
		["Attack Drawbars Upper"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackU"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryU"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryU"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseU"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["Drawbar 2"]={template="DHarm"},
			["Drawbar 3"]={template="DHarm7"},
			["Drawbar 4"]={template="DFund"},
		},
		["Attack Mod Enable"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackModEnable"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryModEnable"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryModEnable"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseModEnable"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 3-3"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 3-8"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Button 4-3"]={template="BRedOnOff"},
			["Button 4-4"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 5-3"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 6-3"]={template="BRedOnOff"},
			["Button 6-4"]={template="BRedOnOff"},
		},
		["Attack Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod1"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod1"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod1"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Attack Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod2"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod2"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod2"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Attack Mod 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod3"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod3"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod3"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Attack"},
			["Button A2"]={template="BOscModPage", helptext="Goto AttackL"},
			["Button A3"]={template="BOscModPage", helptext="Goto AttackU"},
			["Button A4"]={template="BFilterPage", helptext="Goto AttackModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto AttackMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto AttackMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto AttackMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Primary Drawbars Lower"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackL"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryL"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryL"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseL"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["Drawbar 2"]={template="DSub"},
			["Drawbar 3"]={template="DSub"},
			["Drawbar 4"]={template="DFund"},
			["Drawbar 5"]={template="DFund"},
			["Drawbar 6"]={template="DHarm"},
			["Drawbar 7"]={template="DFund"},
			["Drawbar 8"]={template="DHarm"},
		},
		["Primary Drawbars Upper"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackU"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryU"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryU"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseU"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["Drawbar 2"]={template="DHarm"},
			["Drawbar 3"]={template="DHarm7"},
			["Drawbar 4"]={template="DFund"},
		},
		["Primary Mod Enable"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackModEnable"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryModEnable"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryModEnable"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseModEnable"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 3-3"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 3-8"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Button 4-3"]={template="BRedOnOff"},
			["Button 4-4"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 5-3"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 6-3"]={template="BRedOnOff"},
			["Button 6-4"]={template="BRedOnOff"},
		},
		["Primary Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod1"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod1"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod1"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Primary Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod2"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod2"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod2"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Primary Mod 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod3"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod3"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod3"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Primary"},
			["Button A2"]={template="BOscModPage", helptext="Goto PrimaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto PrimaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto PrimaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto PrimaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto PrimaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto PrimaryMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Secondary Drawbars Lower"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackL"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryL"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryL"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseL"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["Drawbar 2"]={template="DSub"},
			["Drawbar 3"]={template="DSub"},
			["Drawbar 4"]={template="DFund"},
			["Drawbar 5"]={template="DFund"},
			["Drawbar 6"]={template="DHarm"},
			["Drawbar 7"]={template="DFund"},
			["Drawbar 8"]={template="DHarm"},
		},
		["Secondary Drawbars Upper"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackU"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryU"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryU"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseU"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["Drawbar 2"]={template="DHarm"},
			["Drawbar 3"]={template="DHarm7"},
			["Drawbar 4"]={template="DFund"},
		},
		["Secondary Mod Enable"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackModEnable"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryModEnable"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryModEnable"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseModEnable"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 3-3"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 3-8"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Button 4-3"]={template="BRedOnOff"},
			["Button 4-4"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 5-3"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 6-3"]={template="BRedOnOff"},
			["Button 6-4"]={template="BRedOnOff"},
		},
		["Secondary Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod1"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod1"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod1"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Secondary Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod2"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod2"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod2"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Secondary Mod 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod3"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod3"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod3"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Secondary"},
			["Button A2"]={template="BOscModPage", helptext="Goto SecondaryL"},
			["Button A3"]={template="BOscModPage", helptext="Goto SecondaryU"},
			["Button A4"]={template="BFilterPage", helptext="Goto SecondaryModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto SecondaryMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto SecondaryMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto SecondaryMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Release Drawbars Lower"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackL"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryL"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryL"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseL"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["Drawbar 2"]={template="DSub"},
			["Drawbar 3"]={template="DSub"},
			["Drawbar 4"]={template="DFund"},
			["Drawbar 5"]={template="DFund"},
			["Drawbar 6"]={template="DHarm"},
			["Drawbar 7"]={template="DFund"},
			["Drawbar 8"]={template="DHarm"},
		},
		["Release Drawbars Upper"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackU"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryU"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryU"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseU"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["Drawbar 2"]={template="DHarm"},
			["Drawbar 3"]={template="DHarm7"},
			["Drawbar 4"]={template="DFund"},
		},
		["Release Mod Enable"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackModEnable"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryModEnable"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryModEnable"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseModEnable"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 3-3"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 3-8"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Button 4-3"]={template="BRedOnOff"},
			["Button 4-4"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 5-3"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 6-3"]={template="BRedOnOff"},
			["Button 6-4"]={template="BRedOnOff"},
		},
		["Release Mod 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod1"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod1"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod1"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod1"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Release Mod 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod2"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod2"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod2"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod2"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Release Mod 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto AttackMod3"},
			["Button B5"]={template="BOscPage", helptext="Goto PrimaryMod3"},
			["Button B6"]={template="BOscPage", helptext="Goto SecondaryMod3"},
			["Button B7"]={template="BOscPage", helptext="Goto ReleaseMod3"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Release"},
			["Button A2"]={template="BOscModPage", helptext="Goto ReleaseL"},
			["Button A3"]={template="BOscModPage", helptext="Goto ReleaseU"},
			["Button A4"]={template="BFilterPage", helptext="Goto ReleaseModEnable"},
			["Button A5"]={template="BFilterModPage", helptext="Goto ReleaseMod1"},
			["Button A6"]={template="BFilterModPage", helptext="Goto ReleaseMod2"},
			["Button A7"]={template="BFilterModPage", helptext="Goto ReleaseMod3"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=127},
			["Fader 7"]={template="FLFO", defaultvalue=127},
			["Fader 8"]={template="FFreq", defaultvalue=64},
		},
		["Effects"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
			["Button 8-7"]={template="BRedOnOff"},
		},
		["PreAmp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FAmount", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
		},
		["Phaser"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=1},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
		},
		["ModFilter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDLFO", defaultvalue=0},
			["Fader 6"]={template="FLFO", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-7_8-7"]={template="UDFreq", defaultvalue=0},
		},
		["Speaker"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=127},
			["Knob V4"]={template="FEffect"},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Knob V7"]={template="FVol"},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Knob V4"]={template="FEffect"},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 8"]={template="FEffect", defaultvalue=64},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FFreq", defaultvalue=32},
			["Fader 6"]={template="FEffect", defaultvalue=64},
		},
		["Limiter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Voicing"},
			["Button B3"]={template="BAmpPage", helptext="Goto PriSec"},
			["Button B4"]={template="BOscPage", helptext="Goto Attack"},
			["Button B5"]={template="BOscPage", helptext="Goto Primary"},
			["Button B6"]={template="BOscPage", helptext="Goto Secondary"},
			["Button B7"]={template="BOscPage", helptext="Goto Release"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto PreAmp"},
			["Button A2"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A3"]={template="BEffectPage", helptext="Goto ModFilter"},
			["Button A4"]={template="BEffectPage", helptext="Goto Speaker"},
			["Button A5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button A6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A7"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=127},
		},
	},
	["Rytmik"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-1"]={helptext="Goto Drum1"},
			["Button 2-2"]={helptext="Goto Drum2"},
			["Button 2-3"]={helptext="Goto Drum3"},
			["Button 2-4"]={helptext="Goto Drum4"},
			["Button 3-1"]={helptext="Goto Drum5"},
			["Button 3-2"]={helptext="Goto Drum6"},
			["Button 3-3"]={helptext="Goto Drum7"},
			["Button 3-4"]={helptext="Goto Drum8"},
			["Button 1-8"]={helptext="Goto Delay"},
			["Button 2-8"]={helptext="Goto Reverb"},
			["Button 3-8"]={helptext="Goto Comp"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Fader 1"]={template="FOsc"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 8"]={template="FVol", defaultvalue=101},
		},
		["Drum1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum3"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum4"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum5"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum5"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum6"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum6"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum7"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Drum8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum8"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Button A1"]={template="BOscPage", helptext="Goto Drum1"},
			["Button A2"]={template="BOscPage", helptext="Goto Drum2"},
			["Button A3"]={template="BOscPage", helptext="Goto Drum3"},
			["Button A4"]={template="BOscPage", helptext="Goto Drum4"},
			["Button A5"]={template="BOscPage", helptext="Goto Drum5"},
			["Button A6"]={template="BOscPage", helptext="Goto Drum6"},
			["Button A7"]={template="BOscPage", helptext="Goto Drum7"},
			["Button A8"]={template="BOscPage", helptext="Goto Drum8"},
			["Fader 1"]={template="FVol", defaultvalue=101},
			["Button 1-2"]={template="BMute"},
			["Button 2-2"]={template="BSolo"},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FOsc", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Knob V7"]={template="FVol"},
			["MFader 1-8"]={template="FFreq", defaultvalue=127},
			["MFader 3-8"]={template="FFreq", defaultvalue=0},
			["MFader 5-8"]={template="FEffect", defaultvalue=0},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["UDVButton 1-1_2-1"]={template="UDFreq", defaultvalue=0},
			["Fader 2"]={template="FEffect", defaultvalue=64},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Fader 1"]={template="FEffect", defaultvalue=64},
			["Fader 2"]={template="FFreq", defaultvalue=0},
			["Fader 3"]={template="FFreq", defaultvalue=127},
		},
		["Comp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Drum1"},
			["Button B6"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B7"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B8"]={template="BEffectPage", helptext="Goto Comp"},
			["Fader 1"]={template="FEffect", defaultvalue=50},
			["Fader 2"]={template="FEffect", defaultvalue=85},
		},
	},
	["Subtractor"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto AmpEnv"},
			["Button 1-3"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button 1-4"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button 1-5"]={helptext="Goto Velocity1"},
			["Button 1-6"]={helptext="Goto ModWheelContr"},
			["Button 1-7"]={helptext="Goto ExtMod"},
			["Button 2-1"]={helptext="Goto Osc1"},
			["Button 3-1"]={helptext="Goto Osc2"},
			["Button 4-1"]={helptext="Goto Noise"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 3-5"]={helptext="Goto Filter2"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 5-5"]={helptext="Goto LFO1"},
			["Button 6-5"]={helptext="Goto LFO2"},
			["Button 5-6"]={helptext="Goto ModEnv"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Fader 8"]={template="FGain", defaultvalue=80},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Velocity2"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ExtMod"},
			["UDVButton 7-3_8-3"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FPerf", defaultvalue=0},
			["UDVButton 7-5_8-5"]={template="UDPerf", defaultvalue=7},
		},
		["Osc 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["MFader 3-1"]={template="FOsc"},
			["UDVButton 3-2_4-2"]={template="UDOsc", inverted=true, defaultvalue=2},
			["UDVButton 3-3_4-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["UDVButton 3-4_4-4"]={template="UDFreq", defaultvalue=4},
			["UDVButton 3-5_4-5"]={template="UDFreq", defaultvalue=0},
			["UDVButton 3-6_4-6"]={template="UDFreq", defaultvalue=50},
			["Button 8-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FOsc", defaultvalue=0},
			["Knob V8"]={template="FVol"},
		},
		["Osc 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button 1-1"]={template="BRedOnOff"},
			["MFader 3-1"]={template="FOsc"},
			["UDVButton 3-2_4-2"]={template="UDOsc", inverted=true, defaultvalue=2},
			["UDVButton 3-3_4-3"]={template="UDOsc", defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["UDVButton 3-4_4-4"]={template="UDFreq", defaultvalue=4},
			["UDVButton 3-5_4-5"]={template="UDFreq", defaultvalue=0},
			["UDVButton 3-6_4-6"]={template="UDFreq", defaultvalue=50},
			["Button 8-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FOsc", defaultvalue=0},
			["Knob V8"]={template="FVol"},
		},
		["Noise"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=127},
			["Fader 3"]={template="FOsc", defaultvalue=127},
			["Fader 4"]={template="FVol", defaultvalue=127},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Fader 2"]={template="FFreq", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDFreq", inverted=true, defaultvalue=3},
			["Fader 5"]={template="FPerf", defaultvalue=0},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Filter 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=0},
		},
		["Filter Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto FilterEnv"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=40},
			["Fader 5"]={template="FFreq", defaultvalue=0},
			["Fader 6"]={template="FFreq", defaultvalue=40},
			["Button 1-7"]={template="BRedOnOff"},
			["MFader 3-7"]={template="FEnv", defaultvalue=0},
		},
		["Amp Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Fader 3"]={template="FVol", defaultvalue=0},
			["Fader 4"]={template="FVol", defaultvalue=100},
			["Fader 5"]={template="FVol", defaultvalue=64},
			["Fader 6"]={template="FVol", defaultvalue=10},
			["Fader 8"]={template="FVol", defaultvalue=80},
		},
		["Mod Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto ModEnv"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Fader 2"]={template="FEnv", defaultvalue=0},
			["Fader 3"]={template="FEnv", defaultvalue=40},
			["Fader 4"]={template="FEnv", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=0},
			["UDVButton 1-8_2-8"]={template="UDEnv", inverted=true, defaultvalue=0},
			["Button 1-7"]={template="BRedOnOff"},
			["MFader 3-7"]={template="FEnv", defaultvalue=0},
		},
		["LFO 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 3-1_4-1"]={template="UDLFO", inverted=true, defaultvalue=0},
			["MFader 1-3"]={template="FFreq", defaultvalue=64},
			["MFader 1-5"]={template="FLFO", defaultvalue=0},
			["UDVButton 3-4_4-4"]={template="UDLFO", inverted=true, defaultvalue=0},
		},
		["LFO 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["UDVButton 1-1_2-1"]={template="UDLFO", inverted=true, defaultvalue=1},
			["MFader 1-3"]={template="FFreq", defaultvalue=64},
			["MFader 1-5"]={template="FLFO", defaultvalue=0},
			["MFader 3-3"]={template="FPerf", defaultvalue=0},
			["MFader 3-5"]={template="FEffect", defaultvalue=0},
		},
		["Velocity 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Velocity2"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ExtMod"},
			["Knob V3"]={template="FVol"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FEnv"},
			["Knob V6"]={template="FOsc"},
		},
		["Velocity 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto Velocity2"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Velocity2"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ExtMod"},
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FFreq"},
			["Knob V6"]={template="FVol"},
			["Knob V7"]={template="FVol"},
		},
		["ModWheel Control"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto ModwheelContr"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Velocity2"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ExtMod"},
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FEffect"},
			["Knob V5"]={template="FLFO"},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
		},
		["ExtMod"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B4"]={template="BOscModPage", helptext="Goto Noise"},
			["Button B5"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B6"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B8"]={template="BPerformancePage", helptext="Goto ExtMod"},
			["Button A1"]={template="BPerformancePage", helptext="Goto Perf"},
			["Button A2"]={template="BPerformancePage", helptext="Goto Velocity1"},
			["Button A3"]={template="BPerformancePage", helptext="Goto Velocity2"},
			["Button A4"]={template="BPerformancePage", helptext="Goto ModWheelContr"},
			["Button A5"]={template="BPerformancePage", helptext="Goto ExtMod"},
			["UDVButton 7-2_8-2"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FLFO"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FOsc"},
		},
	},
	["Thor"]={
		["Keyboard"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
		},
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Mixer"},
			["Button 1-3"]={helptext="Goto Amp"},
			["Button 1-4"]={helptext="Goto AmpEnv"},
			["Button 1-5"]={helptext="Goto Perf"},
			["Button 1-6"]={helptext="Goto Seq"},
			["Button 2-1"]={helptext="Goto Osc1"},
			["Button 3-1"]={helptext="Goto Osc2"},
			["Button 4-1"]={helptext="Goto Osc3"},
			["Button 2-5"]={helptext="Goto Filter1"},
			["Button 3-5"]={helptext="Goto Filter2"},
			["Button 4-5"]={helptext="Goto Filter3"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 5-5"]={helptext="Goto LFO1"},
			["Button 6-5"]={helptext="Goto LFO2"},
			["Button 5-6"]={helptext="Goto ModEnv"},
			["Button 6-6"]={helptext="Goto GlobalEnv"},
			["Button 7-1"]={template="BModMPageHigh", helptext="Goto ModMatrix1"},
			["Button 7-2"]={template="BModMPageHigh", helptext="Goto ModMatrix2"},
			["Button 7-3"]={template="BModMPageHigh", helptext="Goto ModMatrix3"},
			["Button 7-4"]={template="BModMPageHigh", helptext="Goto ModMatrix4"},
			["Button 1-8"]={helptext="Goto Effects"},
			["Button 2-8"]={helptext="Goto Shaper"},
			["Button 3-8"]={helptext="Goto Delay"},
			["Button 4-8"]={helptext="Goto Chorus"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FMisc", defaultvalue=0},
			["Fader 5"]={template="FMisc", defaultvalue=0},
			["Fader 8"]={template="FGain", defaultvalue=100},
		},
		["Perf"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["UDVButton 1-2_2-2"]={template="UDPerf", defaultvalue=8},
			["UDVButton 3-2_4-2"]={template="UDPerf2", defaultvalue=4},
			["UDVButton 5-2_6-2"]={template="UDPerf", inverted=true, defaultvalue=2},
			["UDVButton 7-2_8-2"]={template="UDPerf2", defaultvalue=0},
			["Fader 3"]={template="FPerf", defaultvalue=40},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 2-4"]={template="BGreenOnOff"},
		},
		["Osc 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Osc1"},
			["Button A2"]={template="BOscPage", helptext="Goto Osc2"},
			["Button A3"]={template="BOscPage", helptext="Goto Osc3"},
			["UDVButton 1-1_2-1"]={template="UDOsc", inverted=true, defaultvalue=0},
			["Analog"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true , defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Wavetable"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true, defaultvalue=0},
				["Button 8-5"]={template="BRedOnOff"},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc"},
			},
			["Phase Modulation"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", defaultvalue=0},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["FM Pair"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", defaultvalue=0},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Multi Oscillator"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true, defaultvalue=0},
				["UDVButton 7-5_8-5"]={template="UDOsc", inverted=true, defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Noise"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true , defaultvalue=4},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Fader 8"]={template="FEffect", defaultvalue=0},
		},
		["Osc 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc2"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Osc1"},
			["Button A2"]={template="BOscPage", helptext="Goto Osc2"},
			["Button A3"]={template="BOscPage", helptext="Goto Osc3"},
			["UDVButton 1-1_2-1"]={template="UDOsc", inverted=true, defaultvalue=6},
			["Analog"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true , defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Wavetable"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true, defaultvalue=0},
				["Button 8-5"]={template="BRedOnOff"},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc"},
			},
			["Phase Modulation"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", defaultvalue=0},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["FM Pair"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", defaultvalue=0},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Multi Oscillator"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true, defaultvalue=0},
				["UDVButton 7-5_8-5"]={template="UDOsc", inverted=true, defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Noise"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true , defaultvalue=4},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
		["Osc 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc3"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BOscPage", helptext="Goto Osc1"},
			["Button A2"]={template="BOscPage", helptext="Goto Osc2"},
			["Button A3"]={template="BOscPage", helptext="Goto Osc3"},
			["UDVButton 1-1_2-1"]={template="UDOsc", inverted=true, defaultvalue=6},
			["Analog"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true , defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Wavetable"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true, defaultvalue=0},
				["Button 8-5"]={template="BRedOnOff"},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc"},
			},
			["Phase Modulation"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", defaultvalue=0},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["FM Pair"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", defaultvalue=0},
				["UDVButton 7-4_8-4"]={template="UDOsc", defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Multi Oscillator"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true, defaultvalue=0},
				["UDVButton 7-5_8-5"]={template="UDOsc", inverted=true, defaultvalue=0},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Noise"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true , defaultvalue=4},
				["MFader 1-3"]={template="FPerf", defaultvalue=127},
				["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=4},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=0},
				["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=50},
				["Fader 7"]={template="FOsc", defaultvalue=24},
			},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
		["Mixer"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Knob V3"]={template="FVol"},
			["Fader 4"]={template="FVol", defaultvalue=100},
			["Fader 5"]={template="FVol", defaultvalue=100},
		},
		["Filter 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterPage", helptext="Goto Filter3"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["UDVButton 1-1_2-1"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Button 5-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Button 7-1"]={template="BRedOnOff"},
			["Low Pass"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=1},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["State Variable"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=0},
				["Fader 7"]={template="FFreq", defaultvalue=66},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["Comb"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=0},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv"},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["Formant"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FEffect", defaultvalue=64},
				["Fader 6"]={template="FEffect", defaultvalue=80},
				["Fader 7"]={template="FEffect", defaultvalue=0},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
		},
		["Filter 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterPage", helptext="Goto Filter3"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["UDVButton 1-1_2-1"]={template="UDFreq", inverted=true, defaultvalue=4},
			["Button 5-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Button 7-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Low Pass"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=1},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["State Variable"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=0},
				["Fader 7"]={template="FFreq", defaultvalue=66},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["Comb"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=0},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv"},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["Formant"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FEffect", defaultvalue=64},
				["Fader 6"]={template="FEffect", defaultvalue=80},
				["Fader 7"]={template="FEffect", defaultvalue=0},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
		},
		["Filter 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter3"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterPage", helptext="Goto Filter3"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["UDVButton 1-1_2-1"]={template="UDFreq", inverted=true, defaultvalue=4},
			["Low Pass"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=1},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["State Variable"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=0},
				["Fader 7"]={template="FFreq", defaultvalue=66},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["Comb"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true, defaultvalue=0},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv"},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
			["Formant"]={
				["Fader 3"]={template="FGain", defaultvalue=64},
				["Fader 4"]={template="FEffect", defaultvalue=64},
				["Fader 6"]={template="FEffect", defaultvalue=80},
				["Fader 7"]={template="FEffect", defaultvalue=0},
				["Button 1-8"]={template="BGreenOnOff"},
				["MFader 3-8"]={template="UDEnv", defaultvalue=33},
				["MFader 5-8"]={template="UDPerf", defaultvalue=47},
				["MFader 7-8"]={template="UDPerf2", defaultvalue=0},
			},
		},
		["Filter Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto FilterEnv"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button A2"]={template="BFilterPage", helptext="Goto Filter2"},
			["Button A3"]={template="BFilterPage", helptext="Goto Filter3"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 2-2"]={template="BGreenOnOff"},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FFreq", defaultvalue=55},
			["Fader 6"]={template="FFreq", defaultvalue=64},
		},
		["Amp"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Amp"},
			["Button A2"]={template="BAmpModPage", helptext="Goto AmpEnv"},
			["UDVButton 3-2_4-2"]={template="UDGain"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FPerf", defaultvalue=0},
			["Fader 4"]={template="FVol", defaultvalue=100},
			["Knob V5"]={template="FPan"},
		},
		["Amp Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BAmpPage", helptext="Goto Amp"},
			["Button A2"]={template="BAmpModPage", helptext="Goto AmpEnv"},
			["Button 2-2"]={template="BGreenOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=0},
			["Fader 4"]={template="FGain", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=55},
			["Fader 6"]={template="FGain", defaultvalue=0},
		},
		["Mod Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto ModEnv"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=64},
			["Fader 6"]={template="FEnv", defaultvalue=64},
			["Button 8-7"]={template="BGreenOnOff"},
		},
		["Global Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto GlobalEnv"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
			["Button 4-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=0},
			["Fader 3"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=40},
			["Fader 6"]={template="FEnv", defaultvalue=55},
			["Fader 7"]={template="FEnv", defaultvalue=40},
		},
		["LFO 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FPerf", defaultvalue=0},
		},
		["LFO 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=0},
		},
		["Mod Matrix 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto ModMatrix1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["UDVButton 1-1_2-1"]={template="UDPerf"},
			["MFader 1-2"]={template="FAmount"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["MFader 1-7"]={template="FAmount"},
			["UDVButton 1-8_2-8"]={template="UDPerf"},
			["UDVButton 3-1_4-1"]={template="UDPerf"},
			["MFader 3-2"]={template="FAmount"},
			["UDVButton 3-3_4-3"]={template="UDPerf"},
			["MFader 3-7"]={template="FAmount"},
			["UDVButton 3-8_4-8"]={template="UDPerf"},
			["UDVButton 5-1_6-1"]={template="UDPerf"},
			["MFader 5-2"]={template="FAmount"},
			["UDVButton 5-3_6-3"]={template="UDPerf"},
			["MFader 5-7"]={template="FAmount"},
			["UDVButton 5-8_6-8"]={template="UDPerf"},
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["MFader 7-2"]={template="FAmount"},
			["UDVButton 7-3_8-3"]={template="UDPerf"},
			["MFader 7-7"]={template="FAmount"},
			["UDVButton 7-8_8-8"]={template="UDPerf"},
		},
		["Mod Matrix 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto ModMatrix2"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["UDVButton 1-1_2-1"]={template="UDPerf"},
			["MFader 1-2"]={template="FAmount"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["MFader 1-7"]={template="FAmount"},
			["UDVButton 1-8_2-8"]={template="UDPerf"},
			["UDVButton 3-1_4-1"]={template="UDPerf"},
			["MFader 3-2"]={template="FAmount"},
			["UDVButton 3-3_4-3"]={template="UDPerf"},
			["MFader 3-7"]={template="FAmount"},
			["UDVButton 3-8_4-8"]={template="UDPerf"},
			["UDVButton 5-1_6-1"]={template="UDPerf"},
			["MFader 5-2"]={template="FAmount"},
			["UDVButton 5-3_6-3"]={template="UDPerf"},
			["MFader 5-7"]={template="FAmount"},
			["UDVButton 5-8_6-8"]={template="UDPerf"},
		},
		["Mod Matrix 3"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto ModMatrix3"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["UDVButton 1-1_2-1"]={template="UDPerf"},
			["MFader 1-2"]={template="FAmount"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["MFader 1-7"]={template="FAmount"},
			["UDVButton 1-8_2-8"]={template="UDPerf"},
			["MFader 1-4"]={template="FAmount"},
			["UDVButton 1-5_2-5"]={template="UDPerf"},
			["UDVButton 3-1_4-1"]={template="UDPerf"},
			["MFader 3-2"]={template="FAmount"},
			["UDVButton 3-3_4-3"]={template="UDPerf"},
			["MFader 3-7"]={template="FAmount"},
			["UDVButton 3-8_4-8"]={template="UDPerf"},
			["MFader 3-4"]={template="FAmount"},
			["UDVButton 3-5_4-5"]={template="UDPerf"},
			["UDVButton 5-1_6-1"]={template="UDPerf"},
			["MFader 5-2"]={template="FAmount"},
			["UDVButton 5-3_6-3"]={template="UDPerf"},
			["MFader 5-7"]={template="FAmount"},
			["UDVButton 5-8_6-8"]={template="UDPerf"},
			["MFader 5-4"]={template="FAmount"},
			["UDVButton 5-5_6-5"]={template="UDPerf"},
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["MFader 7-2"]={template="FAmount"},
			["UDVButton 7-3_8-3"]={template="UDPerf"},
			["MFader 7-7"]={template="FAmount"},
			["UDVButton 7-8_8-8"]={template="UDPerf"},
			["MFader 7-4"]={template="FAmount"},
			["UDVButton 7-5_8-5"]={template="UDPerf"},
		},
		["Mod Matrix 4"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto ModMatrix4"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button A2"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button A3"]={template="BEnvPage", helptext="Goto ModEnv"},
			["Button A4"]={template="BEnvPage", helptext="Goto GlobalEnv"},
			["Button A5"]={template="BModMPage", helptext="Goto ModMatrix1"},
			["Button A6"]={template="BModMPage", helptext="Goto ModMatrix2"},
			["Button A7"]={template="BModMPage", helptext="Goto ModMatrix3"},
			["Button A8"]={template="BModMPage", helptext="Goto ModMatrix4"},
			["UDVButton 1-1_2-1"]={template="UDPerf"},
			["MFader 1-2"]={template="FAmount"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["MFader 1-5"]={template="FAmount"},
			["UDVButton 1-6_2-6"]={template="UDPerf"},
			["MFader 1-7"]={template="FAmount"},
			["UDVButton 1-8_2-8"]={template="UDPerf"},
			["UDVButton 3-1_4-1"]={template="UDPerf"},
			["MFader 3-2"]={template="FAmount"},
			["UDVButton 3-3_4-3"]={template="UDPerf"},
			["MFader 3-5"]={template="FAmount"},
			["UDVButton 3-6_4-6"]={template="UDPerf"},
			["MFader 3-7"]={template="FAmount"},
			["UDVButton 3-8_4-8"]={template="UDPerf"},
		},
		["Step Sequencer"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 2-5"]={template="BRedOnOff"},
			["Button 2-6"]={template="BRedOnOff"},
			["Button 2-7"]={template="BRedOnOff"},
			["Button 2-8"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRun"},
			["UDVButton 7-2_8-2"]={template="UDPerf", defaultvalue=0},
			["UDVButton 7-3_8-3"]={template="UDPerf", inverted=true, defaultvalue=0},
			["Button 8-4"]={template="BGreenOnOff"},
			["MFader 7-5"]={template="FFreq", defaultvalue=31},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=-1},
			["UDVButton 7-6_8-6"]={template="UDPerf", defaultvalue=5},
			["UDVButton 7-7_8-7"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 7-8_8-8"]={template="UDPerf", defaultvalue=16},
			["Sel1_127"]={template="BRedOnOff"},
			["Sel1_102"]={template="BRedOnOff"},
			["Sel1_76"]={template="BRedOnOff"},
			["Sel1_51"]={template="BRedOnOff"},
			["Sel1_25"]={template="BRedOnOff"},
			["Sel1_0"]={template="BRedOnOff"},
			["Note"]={
				["UDVButton 3-1_4-1"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-2_4-2"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-3_4-3"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-4_4-4"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-5_4-5"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-6_4-6"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-7_4-7"]={template="UDFreq", defaultvalue=12},
				["UDVButton 3-8_4-8"]={template="UDFreq", defaultvalue=12},
				["UDVButton 5-1_6-1"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-2_6-2"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-3_6-3"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-4_6-4"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-5_6-5"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-6_6-6"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-7_6-7"]={template="UDFreq2", defaultvalue=12},
				["UDVButton 5-8_6-8"]={template="UDFreq2", defaultvalue=12},
			},
			["Velocity"]={
				["UDVButton 3-1_4-1"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-2_4-2"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-3_4-3"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-4_4-4"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-5_4-5"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-6_4-6"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-7_4-7"]={template="UDPerf", defaultvalue=100},
				["UDVButton 3-8_4-8"]={template="UDPerf", defaultvalue=100},
				["UDVButton 5-1_6-1"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-2_6-2"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-3_6-3"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-4_6-4"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-5_6-5"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-6_6-6"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-7_6-7"]={template="UDPerf2", defaultvalue=100},
				["UDVButton 5-8_6-8"]={template="UDPerf2", defaultvalue=100},
			},
			["GateLen"]={
				["UDVButton 3-1_4-1"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-2_4-2"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-3_4-3"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-4_4-4"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-5_4-5"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-6_4-6"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-7_4-7"]={template="UDEffect", defaultvalue=75},
				["UDVButton 3-8_4-8"]={template="UDEffect", defaultvalue=75},
				["UDVButton 5-1_6-1"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-2_6-2"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-3_6-3"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-4_6-4"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-5_6-5"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-6_6-6"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-7_6-7"]={template="UDEffect2", defaultvalue=75},
				["UDVButton 5-8_6-8"]={template="UDEffect2", defaultvalue=75},
			},
			["StepDur"]={
				["UDVButton 3-1_4-1"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-2_4-2"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-3_4-3"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-4_4-4"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-5_4-5"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-6_4-6"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-7_4-7"]={template="UDFreq", defaultvalue=8},
				["UDVButton 3-8_4-8"]={template="UDFreq", defaultvalue=8},
				["UDVButton 5-1_6-1"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-2_6-2"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-3_6-3"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-4_6-4"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-5_6-5"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-6_6-6"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-7_6-7"]={template="UDFreq2", defaultvalue=8},
				["UDVButton 5-8_6-8"]={template="UDFreq2", defaultvalue=8},
			},
			["Curve1"]={
				["UDVButton 3-1_4-1"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-2_4-2"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-3_4-3"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-4_4-4"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-5_4-5"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-6_4-6"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-7_4-7"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-8_4-8"]={template="UDMisc", defaultvalue=64},
				["UDVButton 5-1_6-1"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-2_6-2"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-3_6-3"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-4_6-4"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-5_6-5"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-6_6-6"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-7_6-7"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-8_6-8"]={template="UDMisc2", defaultvalue=64},
			},
			["Curve2"]={
				["UDVButton 3-1_4-1"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-2_4-2"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-3_4-3"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-4_4-4"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-5_4-5"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-6_4-6"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-7_4-7"]={template="UDMisc", defaultvalue=64},
				["UDVButton 3-8_4-8"]={template="UDMisc", defaultvalue=64},
				["UDVButton 5-1_6-1"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-2_6-2"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-3_6-3"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-4_6-4"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-5_6-5"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-6_6-6"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-7_6-7"]={template="UDMisc2", defaultvalue=64},
				["UDVButton 5-8_6-8"]={template="UDMisc2", defaultvalue=64},
			},
		},
		["Effects"]={
			["Button 8-1"]={template="BGreenOnOff"},
			["Button 8-2"]={template="BGreenOnOff"},
			["Button 8-3"]={template="BGreenOnOff"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A3"]={template="BEffectPage", helptext="Goto Chorus"},
		},
		["Shaper"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A3"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=37},
			["UDVButton 7-4_8-4"]={template="UDAmount"},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A3"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 8-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=48},
			["Fader 3"]={template="FEffect", defaultvalue=50},
			["Fader 5"]={template="FFreq", defaultvalue=35},
			["Fader 6"]={template="FLFO", defaultvalue=25},
			["Fader 8"]={template="FEffect", defaultvalue=40},
		},
		["Chorus"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Osc1"},
			["Button B3"]={template="BAmpPage", helptext="Goto Mixer"},
			["Button B4"]={template="BFilterPage", helptext="Goto Filter1"},
			["Button B5"]={template="BAmpPage", helptext="Goto Amp"},
			["Button B6"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B7"]={template="BPerformancePage", helptext="Goto Seq"},
			["Button B8"]={template="BEffectPage", helptext="Goto Effects"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shaper"},
			["Button A2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button A3"]={template="BEffectPage", helptext="Goto Chorus"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=64},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=40},
			["Fader 6"]={template="FLFO", defaultvalue=32},
			["Fader 8"]={template="FEffect", defaultvalue=60},
		},
	},
	["Alligator"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto AmpEnv"},
			["Button 1-3"]={helptext="Goto DryLevels"},
			["Button 2-5"]={helptext="Goto HPFilter"},
			["Button 2-6"]={helptext="Goto FilterEnv"},
			["Button 3-5"]={helptext="Goto BPFilter"},
			["Button 4-5"]={helptext="Goto LPFilter"},
			["Button 2-8"]={helptext="Goto HPEffects"},
			["Button 3-8"]={helptext="Goto BPEffects"},
			["Button 4-8"]={helptext="Goto LPEffects"},
			["Button 6-8"]={helptext="Goto Delay"},
			["Button 7-8"]={helptext="Goto Phaser"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 3-2"]={template="BGreenOnOff"},
			["UDVButton 5-2_6-2"]={template="UDEffect", defaultvalue=1},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=2},
			["MFader 7-3"]={template="UDEffect", defaultvalue=64},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Fader 7"]={template="FVol", defaultvalue=100},
		},
		["HPFilter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button A2"]={template="BFilterPage", helptext="Goto BPFilter"},
			["Button A3"]={template="BFilterPage", helptext="Goto LPFilter"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-2"]={template="BGreenOnOff"},
			["Knob V3"]={template="FLFO"},
			["Fader 4"]={template="FFreq", defaultvalue=74},
			["Fader 5"]={template="FEffect", defaultvalue=15},
			["Knob V6"]={template="FEnv"},
		},
		["BPFilter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto BPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button A2"]={template="BFilterPage", helptext="Goto BPFilter"},
			["Button A3"]={template="BFilterPage", helptext="Goto LPFilter"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-2"]={template="BGreenOnOff"},
			["Knob V3"]={template="FLFO"},
			["Fader 4"]={template="FFreq", defaultvalue=52},
			["Fader 5"]={template="FEffect", defaultvalue=15},
			["Knob V6"]={template="FEnv"},
		},
		["LPFilter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto LPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button A2"]={template="BFilterPage", helptext="Goto BPFilter"},
			["Button A3"]={template="BFilterPage", helptext="Goto LPFilter"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Button 1-2"]={template="BGreenOnOff"},
			["Knob V3"]={template="FLFO"},
			["Fader 4"]={template="FFreq", defaultvalue=43},
			["Fader 5"]={template="FEffect", defaultvalue=15},
			["Knob V6"]={template="FEnv"},
		},
		["HPEffects"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button A2"]={template="BEffectPage", helptext="Goto BPEffects"},
			["Button A3"]={template="BEffectPage", helptext="Goto LPEffects"},
			["Button A5"]={template="BAmpPage", helptext="Goto DryLevels"},
			["Fader 2"]={template="FAmount", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Knob V6"]={template="FPan"},
			["Fader 7"]={template="FVol", defaultvalue=100},
		},
		["BPEffects"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto BPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button A2"]={template="BEffectPage", helptext="Goto BPEffects"},
			["Button A3"]={template="BEffectPage", helptext="Goto LPEffects"},
			["Button A5"]={template="BAmpPage", helptext="Goto DryLevels"},
			["Fader 2"]={template="FAmount", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Knob V6"]={template="FPan"},
			["Fader 7"]={template="FVol", defaultvalue=100},
		},
		["LPEffects"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto LPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button A2"]={template="BEffectPage", helptext="Goto BPEffects"},
			["Button A3"]={template="BEffectPage", helptext="Goto LPEffects"},
			["Button A5"]={template="BAmpPage", helptext="Goto DryLevels"},
			["Fader 2"]={template="FAmount", defaultvalue=0},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Knob V6"]={template="FPan"},
			["Fader 7"]={template="FVol", defaultvalue=100},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=5},
			["Button 1-3"]={template="BGreenOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=61},
			["Knob V5"]={template="FEffect"},
		},
		["Phaser"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Fader 2"]={template="FFreq", defaultvalue=20},
			["Fader 4"]={template="FEffect", defaultvalue=37},
		},
		["AmpEnv"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Fader 3"]={template="FVol", defaultvalue=20},
			["Fader 4"]={template="FVol", defaultvalue=127},
			["Fader 5"]={template="FVol", defaultvalue=20},
		},
		["DryLevels"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto DryLevels"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button A2"]={template="BEffectPage", helptext="Goto BPEffects"},
			["Button A3"]={template="BEffectPage", helptext="Goto LPEffects"},
			["Button A5"]={template="BAmpPage", helptext="Goto DryLevels"},
			["Fader 2"]={template="FEffect", defaultvalue=0},
			["Knob V4"]={template="FPan"},
			["Fader 5"]={template="FVol", defaultvalue=0},
		},
		["FilterEnv"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto FilterEnv"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["Button A1"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button A2"]={template="BFilterPage", helptext="Goto BPFilter"},
			["Button A3"]={template="BFilterPage", helptext="Goto LPFilter"},
			["Button A5"]={template="BFilterModPage", helptext="Goto FilterEnv"},
			["Fader 3"]={template="FFreq", defaultvalue=40},
			["Fader 4"]={template="FFreq", defaultvalue=40},
			["Fader 5"]={template="FFreq", defaultvalue=10},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto AmpEnv"},
			["Button B3"]={template="BFilterPage", helptext="Goto HPFilter"},
			["Button B4"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B6"]={template="BEffectPage", helptext="Goto HPEffects"},
			["Button B7"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B8"]={template="BEffectPage", helptext="Goto Phaser"},
			["UDVButton 1-2_2-2"]={template="UDLFO", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=32},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=4},
			["Button 1-5"]={template="BGreenOnOff"},
		},
	},
	["Audiomatic"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Fader 2"]={template="FGain", defaultvalue=64},
			["UDVButton 1-3_2-3"]={template="UDEffect", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=127},
			["Fader 7"]={template="FVol", defaultvalue=64},
		},
	},
	["BV512 Digital Vocoder"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Band1-8"},
			["Button B3"]={template="BEffectPage", helptext="Goto Band9-16"},
			["Button B4"]={template="BEffectPage", helptext="Goto Band17-24"},
			["Button B5"]={template="BEffectPage", helptext="Goto Band25-32"},
			["UDVButton 7-1_8-1"]={template="UDNocolor"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Band1-8"},
			["Button 3-8"]={helptext="Goto Band9-16"},
			["Button 4-8"]={helptext="Goto Band17-24"},
			["Button 5-8"]={helptext="Goto Band25-32"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Band1-8"},
			["Button B3"]={template="BEffectPage", helptext="Goto Band9-16"},
			["Button B4"]={template="BEffectPage", helptext="Goto Band17-24"},
			["Button B5"]={template="BEffectPage", helptext="Goto Band25-32"},
			["Button 4-1"]={template="BRedOnOff"},
			["UDVButton 5-1_6-1"]={template="UDEffect", defaultvalue=2},
			["UDVButton 7-1_8-1"]={template="UDEffect", defaultvalue=0},
			["Fader 4"]={template="FAmount", defaultvalue=0},
			["Fader 5"]={template="FAmount", defaultvalue=30},
			["Knob V6"]={template="FGain"},
			["Fader 7"]={template="FFreq", defaultvalue=64},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
		["Band1-8"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Band1-8"},
			["Button B3"]={template="BEffectPage", helptext="Goto Band9-16"},
			["Button B4"]={template="BEffectPage", helptext="Goto Band17-24"},
			["Button B5"]={template="BEffectPage", helptext="Goto Band25-32"},
			["UDVButton 7-1_8-1"]={template="UDNocolor"},
			["Fader 1"]={template="FVCFreq", defaultvalue=89},
			["Fader 2"]={template="FVCFreq", defaultvalue=89},
			["Fader 3"]={template="FVCFreq", defaultvalue=89},
			["Fader 4"]={template="FVCFreq", defaultvalue=89},
		},
		["Band9-16"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Band1-8"},
			["Button B3"]={template="BEffectPage", helptext="Goto Band9-16"},
			["Button B4"]={template="BEffectPage", helptext="Goto Band17-24"},
			["Button B5"]={template="BEffectPage", helptext="Goto Band25-32"},
			["UDVButton 7-1_8-1"]={template="UDNocolor"},
			["Fader 1"]={template="FVCFreq", defaultvalue=89},
			["Fader 2"]={template="FVCFreq", defaultvalue=89},
			["Fader 3"]={template="FVCFreq", defaultvalue=89},
			["Fader 4"]={template="FVCFreq", defaultvalue=89},
			["Fader 5"]={template="FVCFreq", defaultvalue=89},
			["Fader 6"]={template="FVCFreq", defaultvalue=89},
			["Fader 7"]={template="FVCFreq", defaultvalue=89},
			["Fader 8"]={template="FVCFreq", defaultvalue=89},
		},
		["Band17-24"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Band1-8"},
			["Button B3"]={template="BEffectPage", helptext="Goto Band9-16"},
			["Button B4"]={template="BEffectPage", helptext="Goto Band17-24"},
			["Button B5"]={template="BEffectPage", helptext="Goto Band25-32"},
			["UDVButton 7-1_8-1"]={template="UDNocolor"},
			["Fader 1"]={template="FVCFreq", defaultvalue=89},
			["Fader 2"]={template="FVCFreq", defaultvalue=89},
			["Fader 3"]={template="FVCFreq", defaultvalue=89},
			["Fader 4"]={template="FVCFreq", defaultvalue=89},
			["Fader 5"]={template="FVCFreq", defaultvalue=89},
			["Fader 6"]={template="FVCFreq", defaultvalue=89},
			["Fader 7"]={template="FVCFreq", defaultvalue=89},
			["Fader 8"]={template="FVCFreq", defaultvalue=89},
		},
		["Band25-32"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Band1-8"},
			["Button B3"]={template="BEffectPage", helptext="Goto Band9-16"},
			["Button B4"]={template="BEffectPage", helptext="Goto Band17-24"},
			["Button B5"]={template="BEffectPage", helptext="Goto Band25-32"},
			["UDVButton 7-1_8-1"]={template="UDNocolor"},
			["Fader 1"]={template="FVCFreq", defaultvalue=89},
			["Fader 2"]={template="FVCFreq", defaultvalue=89},
			["Fader 3"]={template="FVCFreq", defaultvalue=89},
			["Fader 4"]={template="FVCFreq", defaultvalue=89},
			["Fader 5"]={template="FVCFreq", defaultvalue=89},
			["Fader 6"]={template="FVCFreq", defaultvalue=89},
			["Fader 7"]={template="FVCFreq", defaultvalue=89},
			["Fader 8"]={template="FVCFreq", defaultvalue=89},
		},
	},
	["CF-101 Chorus/Flanger"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Fader 3"]={template="FFreq", defaultvalue=40},
			["Knob V4"]={template="FEffect"},
			["Fader 5"]={template="FFreq", defaultvalue=40},
			["Button 1-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FLFO", defaultvalue=64},
			["Button 1-8"]={template="BRedOnOff"},
		},
	},
	["Channel Dynamics"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Compressor"},
			["Button 3-8"]={helptext="Goto GateExpander"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Compressor"},
			["Button B3"]={template="BGainPage", helptext="Goto GateExpander"},
			["Fader 2"]={template="FGain", defaultvalue=63},
			["Button 8-7"]={template="BRedOnOff"},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
		["Compressor"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Compressor"},
			["Button B3"]={template="BGainPage", helptext="Goto GateExpander"},
			["Button 5-1"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["Fader 2"]={template="FGain", defaultvalue=63},
			["Fader 3"]={template="FEffect", defaultvalue=63},
			["Fader 4"]={template="FEffect", defaultvalue=63},
			["Button 8-5"]={template="BBlueOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=63},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
		["Gate/Expander"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Compressor"},
			["Button B3"]={template="BGainPage", helptext="Goto GateExpander"},
			["Button 5-1"]={template="BBlueOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=63},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=45},
			["Button 8-5"]={template="BBlueOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=63},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
	},
	["Channel EQ"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Filter"},
			["Button 3-8"]={helptext="Goto LF"},
			["Button 4-8"]={helptext="Goto LMF"},
			["Button 5-8"]={helptext="Goto HMF"},
			["Button 6-8"]={helptext="Goto HF"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Filter"},
			["Button B3"]={template="BMainPage", helptext="Goto LF"},
			["Button B4"]={template="BEffectPage", helptext="Goto LMF"},
			["Button B5"]={template="BFilterPage", helptext="Goto HMF"},
			["Button B6"]={template="BGainPage", helptext="Goto HF"},
			["Fader 8"]={template="FGain", defaultvalue=63},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Filter"},
			["Button B3"]={template="BMainPage", helptext="Goto LF"},
			["Button B4"]={template="BEffectPage", helptext="Goto LMF"},
			["Button B5"]={template="BFilterPage", helptext="Goto HMF"},
			["Button B6"]={template="BGainPage", helptext="Goto HF"},
			["Button 8-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Button 8-4"]={template="BBlueOnOff"},
			["Fader 5"]={template="FFreq", defaultvalue=127},
		},
		["LF"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Filter"},
			["Button B3"]={template="BMainPage", helptext="Goto LF"},
			["Button B4"]={template="BEffectPage", helptext="Goto LMF"},
			["Button B5"]={template="BFilterPage", helptext="Goto HMF"},
			["Button B6"]={template="BGainPage", helptext="Goto HF"},
			["Button 8-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=63},
			["Fader 4"]={template="FFreq", defaultvalue=63},
		},
		["LMF"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Filter"},
			["Button B3"]={template="BMainPage", helptext="Goto LF"},
			["Button B4"]={template="BEffectPage", helptext="Goto LMF"},
			["Button B5"]={template="BFilterPage", helptext="Goto HMF"},
			["Button B6"]={template="BGainPage", helptext="Goto HF"},
			["Button 8-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=63},
			["Fader 4"]={template="FFreq", defaultvalue=63},
			["Fader 5"]={template="FEffect", defaultvalue=63},
		},
		["HMF"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Filter"},
			["Button B3"]={template="BMainPage", helptext="Goto LF"},
			["Button B4"]={template="BEffectPage", helptext="Goto LMF"},
			["Button B5"]={template="BFilterPage", helptext="Goto HMF"},
			["Button B6"]={template="BGainPage", helptext="Goto HF"},
			["Button 8-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=63},
			["Fader 4"]={template="FFreq", defaultvalue=63},
			["Fader 5"]={template="FEffect", defaultvalue=63},
		},
		["HF"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto Filter"},
			["Button B3"]={template="BMainPage", helptext="Goto LF"},
			["Button B4"]={template="BEffectPage", helptext="Goto LMF"},
			["Button B5"]={template="BFilterPage", helptext="Goto HMF"},
			["Button B6"]={template="BGainPage", helptext="Goto HF"},
			["Button 8-2"]={template="BBlueOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=63},
			["Fader 4"]={template="FFreq", defaultvalue=63},
		},
	},
	["COMP-01 Compressor/Limiter"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=40},
			["Fader 5"]={template="FEffect", defaultvalue=40},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Meter 8"]={template="FGain",bvmap="MeterSI"},
		},
	},
	["D-11 Foldback Distortion"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Fader 4"]={template="FEffect", defaultvalue=20},
			["Fader 8"]={template="FEffect", defaultvalue=34},
		},
	},
	["DDL-1 Digital Delay Line"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Steps"]={
				["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=2},
			},
			["Ms"]={
				["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=23},
			},
			["UDVButton 1-4_2-4"]={template="UDFreq", inverted=true, defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=40},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
	},
	["ECF-42 Filter"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-6"]={helptext="Goto FilterEnvelope"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterModPage", helptext="Goto FilterEnvelope"},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=32},
			["Fader 6"]={template="FPerf", defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="UDFreq", inverted=true, defaultvalue=1},
		},
		["Filter Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterModPage", helptext="Goto FilterEnvelope"},
			["Fader 1"]={template="FEnv", defaultvalue=32},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FFreq", defaultvalue=0},
			["Fader 6"]={template="FFreq", defaultvalue=64},
		},
	},
	["Master Compressor"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
		},
		["Main"]={
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FGain", defaultvalue=63},
			["Fader 3"]={template="FEffect", defaultvalue=63},
			["UDVButton 1-4_2-4"]={template="UDEffect2", defaultvalue=0},
			["UDVButton 5-4_6-4"]={template="UDFreq2", defaultvalue=2},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=2},
			["Fader 6"]={template="FGain", defaultvalue=63},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
	},
	["MClass Compressor"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Env"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Env"},
			["Button 7-1"]={template="BRedLed"},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"	, defaultvalue=64},
			["Meter 7"]={template="InvMeter"},
			["Fader 8"]={template="FGain", defaultvalue=64},
		},
		["Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Env"},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Button 1-6"]={template="BRedOnOff"},
		},
	},
	["MClass Equalizer"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Low"},
			["Button 3-8"]={helptext="Goto Param1"},
			["Button 4-8"]={helptext="Goto Param2"},
			["Button 5-8"]={helptext="Goto Hi"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Low"},
			["Button B3"]={template="BFilterPage", helptext="Goto Param1"},
			["Button B4"]={template="BFilterPage", helptext="Goto Param2"},
			["Button B5"]={template="BFilterPage", helptext="Goto Hi"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
		},
		["Low"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Low"},
			["Button B3"]={template="BFilterPage", helptext="Goto Param1"},
			["Button B4"]={template="BFilterPage", helptext="Goto Param2"},
			["Button B5"]={template="BFilterPage", helptext="Goto Hi"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=20},
		},
		["Param1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Low"},
			["Button B3"]={template="BFilterPage", helptext="Goto Param1"},
			["Button B4"]={template="BFilterPage", helptext="Goto Param2"},
			["Button B5"]={template="BFilterPage", helptext="Goto Hi"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=64},
		},
		["Param2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Low"},
			["Button B3"]={template="BFilterPage", helptext="Goto Param1"},
			["Button B4"]={template="BFilterPage", helptext="Goto Param2"},
			["Button B5"]={template="BFilterPage", helptext="Goto Hi"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=64},
		},
		["Hi"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Low"},
			["Button B3"]={template="BFilterPage", helptext="Goto Param1"},
			["Button B4"]={template="BFilterPage", helptext="Goto Param2"},
			["Button B5"]={template="BFilterPage", helptext="Goto Hi"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=20},
		},
	},
	["MClass Maximizer"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Limiter"},
			["Button 3-8"]={helptext="Goto SoftClip"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button B3"]={template="BEffectPage", helptext="Goto SoftCLip"},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Button 1-6"]={template="BRedOnOff"},
		},
		["Limiter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button B3"]={template="BEffectPage", helptext="Goto SoftCLip"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Meter 3"]={template="InvMeter"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 6"]={template="FGain", defaultvalue=64},
		},
		["SoftClip"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Limiter"},
			["Button B3"]={template="BEffectPage", helptext="Goto SoftCLip"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
		},
	},
	["MClass Stereo Imager"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Knob V3"]={template="FEffect"},
			["Meter 4"]={template="FGain", bvmap="MeterSI"},
			["Fader 5"]={template="FFreq", bvmap="Fader64"},
			["Knob V6"]={template="FEffect"},
			["Meter 7"]={template="FGain", bvmap="MeterSI"},
			["UDVButton 1-8_2-8"]={template="UDPerf", defaultvalue=0},
			["UDVButton 7-8_8-8"]={template="UDEffect", defaultvalue=0},
		},
	},
	["Neptune Pitch Adjuster"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto PitchAdjust"},
			["Button 3-8"]={helptext="Goto Transpose"},
			["Button 4-8"]={helptext="Goto Formant"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto PitchAdjust"},
			["Button B3"]={template="BFilterPage", helptext="Goto Transpose"},
			["Button B4"]={template="BEffectPage", helptext="Goto Formant"},
			["Fader 3"]={template="UDEffect", defaultvalue=64},
			["Button 1-4"]={template="BYellowOnOff"},
			["Button 3-4"]={template="BYellowOnOff"},
			["Button 5-4"]={template="BYellowOnOff"},
			["UDVButton 7-4_8-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=100},
			["Fader 8"]={template="FEffect", defaultvalue=100},
		},
		["PitchAdjust"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto PitchAdjust"},
			["Button B3"]={template="BFilterPage", helptext="Goto Transpose"},
			["Button B4"]={template="BEffectPage", helptext="Goto Formant"},
			["Button 1-2"]={template="BYellowOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=0},
		},
		["Transpose"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto PitchAdjust"},
			["Button B3"]={template="BFilterPage", helptext="Goto Transpose"},
			["Button B4"]={template="BEffectPage", helptext="Goto Formant"},
			["Button 1-2"]={template="BYellowOnOff"},
			["UDVButton 1-4_2-4"]={template="UDFreq", defaultvalue=12},
			["UDVButton 5-4_6-4"]={template="UDFreq", defaultvalue=50},
		},
		["Formant"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BOscPage", helptext="Goto PitchAdjust"},
			["Button B3"]={template="BFilterPage", helptext="Goto Transpose"},
			["Button B4"]={template="BEffectPage", helptext="Goto Formant"},
			["Button 1-2"]={template="BYellowOnOff"},
			["Knob V5"]={template="FEffect"},
		},
	},
	["PEQ-2 Two Band Parametric EQ"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FGain"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FGain"},
		},
	},
	["PH-90 Phaser"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO"},
			["Fader 3"]={template="FFreq", defaultvalue=58},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=100},
			["Fader 6"]={template="FEffect", defaultvalue=100},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO"},
			["Fader 5"]={template="FFreq", defaultvalue=32},
			["Button 1-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FLFO", defaultvalue=70},
		},
	},
	["Polar Dual Pitch Shifter"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Dry"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 5-5"]={helptext="Goto LFO"},
			["Button 5-6"]={helptext="Goto Env"},
			["Button 2-8"]={helptext="Goto DelayBuffer"},
			["Button 3-8"]={helptext="Goto Shifter1"},
			["Button 4-8"]={helptext="Goto Shifter1Vol"},
			["Button 5-8"]={helptext="Goto Shifter2"},
			["Button 6-8"]={helptext="Goto Shifter2Vol"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true, defaultvalue=1},
			["UDVButton 5-3_6-3"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FFreq", defaultvalue=32},
		},
		["Dry Signal"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FLFO"},
			["Fader 8"]={template="FGain", defaultvalue=127},
		},
		["Delay Buffer"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Button 1-4"]={template="BRedOnOff"},
			["Knob V5"]={template="FLFO"},
			["Knob V6"]={template="FEnv"},
		},
		["Shifter 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button A2"]={template="BEffectPage", helptext="Goto Shifter1Vol"},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=24},
			["Knob V3"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Knob V6"]={template="FLFO"},
			["Knob V7"]={template="FEnv"},
		},
		["Shifter 1 Vol"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1Vol"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button A2"]={template="BEffectPage", helptext="Goto Shifter1Vol"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FLFO"},
			["Fader 6"]={template="FVol", defaultvalue=127},
		},
		["Shifter 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button A2"]={template="BEffectPage", helptext="Goto Shifter2Vol"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=24},
			["Knob V3"]={template="FFreq"},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Knob V6"]={template="FLFO"},
			["Knob V7"]={template="FEnv"},
		},
		["Shifter Vol 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2Vol"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button A1"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button A2"]={template="BEffectPage", helptext="Goto Shifter2Vol"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FLFO"},
			["Fader 6"]={template="FVol", defaultvalue=127},
		},
		["Envelope"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEnv", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=64},
			["Fader 5"]={template="FEnv", defaultvalue=0},
			["Fader 6"]={template="FEnv", defaultvalue=64},
			["Button 1-7"]={template="BRedOnOff"},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Fader 2"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=9},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["UDVButton 7-6_8-6"]={template="UDLFO", defaultvalue=0},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto DelayBuffer"},
			["Button B3"]={template="BAmpPage", helptext="Goto Dry"},
			["Button B4"]={template="BEffectPage", helptext="Goto Shifter1"},
			["Button B5"]={template="BEffectPage", helptext="Goto Shifter2"},
			["Button B6"]={template="BEnvPage", helptext="Goto Env"},
			["Button B7"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B8"]={template="BFilterPage", helptext="Goto Filter"},
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FPerf", defaultvalue=0},
			["Knob V7"]={template="FLFO"},
			["Knob V8"]={template="FEnv"},
		},
	},
	["Pulveriser"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-6"]={helptext="Goto Follower"},
			["Button 2-8"]={helptext="Goto Tremor"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B3"]={template="BLFOPage", helptext="Goto Tremor"},
			["Button B4"]={template="BEnvPage", helptext="Goto Follower"},
			["UDVButton 7-1_8-1"]={template="UDPerf", defaultvalue=1},
			["Fader 2"]={template="FEffect", defaultvalue=0},
			["Fader 3"]={template="FEnv", defaultvalue=63},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FOsc", defaultvalue=127},
			["Fader 6"]={template="FEffect", defaultvalue=127},
			["Fader 7"]={template="FVol", defaultvalue=100},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B3"]={template="BLFOPage", helptext="Goto Tremor"},
			["Button B4"]={template="BEnvPage", helptext="Goto Follower"},
			["UDVButton 1-2_2-2"]={template="UDFreq", defaultvalue=4},
			["Fader 3"]={template="FFreq", defaultvalue=127},
			["Fader 4"]={template="FEffect", defaultvalue=46},
			["Knob V7"]={template="FLFO"},
			["Knob V8"]={template="FEnv"},
		},
		["Tremor"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B3"]={template="BLFOPage", helptext="Goto Tremor"},
			["Button B4"]={template="BEnvPage", helptext="Goto Follower"},
			["Fader 2"]={template="FFreq", defaultvalue=33},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=4},
			["Button 1-3"]={template="BGreenOnOff"},
			["UDVButton 1-4_2-4"]={template="UDEffect", defaultvalue=0},
			["Button 1-5"]={template="BGreenOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=20},
			["Knob V8"]={template="FVol"},
		},
		["Follower"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B3"]={template="BLFOPage", helptext="Goto Tremor"},
			["Button B4"]={template="BEnvPage", helptext="Goto Follower"},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FEnv", defaultvalue=0},
			["Fader 5"]={template="FEnv", defaultvalue=0},
		},
	},
	["RV-7 Digital Reverb"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["UDVButton 1-3_2-3"]={template="FEffect", defaultvalue=0},
			["Knob V4"]={template="FEffect"},
			["Knob V5"]={template="FFreq"},
			["Fader 7"]={template="FEffect", defaultvalue=40},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
	},
	["RV7000 Advanced Reverb"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Reverb"},
			["Button 3-8"]={helptext="Goto Eq"},
			["Button 4-8"]={helptext="Goto Gate"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B3"]={template="BFilterPage", helptext="Goto Eq"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=82},
			["Fader 4"]={template="FFreq", defaultvalue=28},
			["Knob V5"]={template="FFreq"},
			["Fader 7"]={template="FEffect", defaultvalue=127},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B3"]={template="BFilterPage", helptext="Goto Eq"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["UDVButton 1-1_2-1"]={template="UDEffect", defaultvalue=2},
			["SmallSpace"]={
				["Fader 2"]={template="FEffect", defaultvalue=30},
				["Fader 3"]={template="FFreq", defaultvalue=10},
				["UDVButton 7-4_8-4"]={template="UDEffect", defaultvalue=1},
				["Fader 5"]={template="FFreq", defaultvalue=32},
				["Fader 6"]={template="FEffect", defaultvalue=127},
				["Fader 7"]={template="FFreq", defaultvalue=0},
				["Fader 8"]={template="FLFO", defaultvalue=10},
			},
			["Room"]={
				["Fader 2"]={template="FEffect", defaultvalue=64},
				["Fader 3"]={template="FEffect", defaultvalue=127},
				["UDVButton 7-4_8-4"]={template="UDEffect", defaultvalue=0},
				["Fader 5"]={template="FEffect", defaultvalue=64},
				["Fader 6"]={template="FEffect", defaultvalue=64},
				["Fader 7"]={template="FFreq", defaultvalue=0},
				["Fader 8"]={template="FLFO", defaultvalue=10},
			},
			["Hall"]={
				["Fader 2"]={template="FEffect", defaultvalue=64},
				["Fader 3"]={template="FEffect", defaultvalue=127},
				["UDVButton 7-4_8-4"]={template="UDEffect", defaultvalue=0},
				["Fader 5"]={template="FEffect", defaultvalue=64},
				["Fader 6"]={template="FEffect", defaultvalue=64},
				["Fader 7"]={template="FFreq", defaultvalue=10},
				["Fader 8"]={template="FLFO", defaultvalue=10},
			},
			["Arena"]={
				["Fader 2"]={template="FEffect", defaultvalue=64},
				["Fader 3"]={template="FEffect", defaultvalue=127},
				["Fader 4"]={template="FFreq", defaultvalue=24},
				["Fader 5"]={template="FFreq", defaultvalue=24},
				["Fader 6"]={template="FAmount", defaultvalue=64},
				["Fader 7"]={template="FFreq", defaultvalue=0},
				["Fader 8"]={template="FAmount", defaultvalue=64},
			},
			["Plate"]={
				["Fader 5"]={template="FFreq", defaultvalue=64},
				["Fader 7"]={template="FFreq", defaultvalue=0},
			},
			["Spring"]={
				["Fader 2"]={template="FEffect", defaultvalue=50},
				["Fader 3"]={template="FEffect", defaultvalue=127},
				["Fader 4"]={template="FFreq", defaultvalue=80},
				["Fader 5"]={template="FFreq", defaultvalue=32},
				["Button 8-6"]={template="BRedOnOff"},
				["Fader 7"]={template="FFreq", defaultvalue=12},
				["Fader 8"]={template="FAmount", defaultvalue=127},
			},
			["Echo"]={
				["Fader 2"]={template="FEffect", defaultvalue=12},
				["UDVButton 7-2_8-2"]={template="UDEffect", defaultvalue=2},
				["Fader 3"]={template="FEffect", defaultvalue=32},
				["Button 8-4"]={template="BRedOnOff"},
				["Fader 5"]={template="FFreq", defaultvalue=32},
				["Fader 6"]={template="FEffect", defaultvalue=64},
				["Fader 7"]={template="FFreq", defaultvalue=0},
			},
			["MultiTap"]={
				["Button 8-2"]={template="BRedOnOff"},
				["Fader 3"]={template="FEffect", defaultvalue=50},
				["Fader 4"]={template="FFreq", defaultvalue=0},
				["UDVButton 7-5_8-5"]={template="UDEffect", defaultvalue=0},
				["Fader 6"]={template="FFreq", defaultvalue=9},
				["UDVButton 7-6_8-6"]={template="UDFreq", defaultvalue=0},
				["Fader 7"]={template="FVol", defaultvalue=100},
				["Knob V8"]={template="FPan"},
			},
			["Reverse"]={
				["Fader 2"]={template="FEffect", defaultvalue=0},
				["UDVButton 7-2_8-2"]={template="UDEffect", defaultvalue=3},
				["Fader 3"]={template="FEffect", defaultvalue=127},
				["Button 8-4"]={template="BRedOnOff"},
				["Fader 5"]={template="FEffect", defaultvalue=64},
			},
			["Convolution"]={
				["UDVButton 7-2_8-2"]={template="UDEffect", defaultvalue=0},
				["Fader 3"]={template="FEffect", defaultvalue=127},
				["Knob V4"]={template="FEffect"},
				["Fader 5"]={template="FFreq", defaultvalue=0},
				["UDVButton 7-6_8-6"]={template="UDEffect", defaultvalue=0},
				["Knob V7"]={template="FFreq"},
				["Fader 8"]={template="FGain", defaultvalue=64},
			},
		},
		["Eq"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B3"]={template="BFilterPage", helptext="Goto Eq"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button 1-1"]={template="BRedOnOff"},
			["Knob V2"]={template="FGain"},
			["Fader 3"]={template="FFreq", defaultvalue=64},
			["Knob V5"]={template="FGain"},
			["Fader 6"]={template="FFreq", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=10},
		},
		["Gate"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button B3"]={template="BFilterPage", helptext="Goto Eq"},
			["Button B4"]={template="BEffectPage", helptext="Goto Gate"},
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect", defaultvalue=8},
			["Fader 3"]={template="FEffect", defaultvalue=127},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 5"]={template="FFreq", defaultvalue=32},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=20},
			["Fader 8"]={template="FEffect", defaultvalue=10},
		},
	},
	["Quartet"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
		},
		["Main"]={
			["ARadioButton4"]={template="BRedOnOff"},
			["Button 8-1"]={template="BBlueOnOff"},
			["Chorus"]={
				["Fader 2"]={template="FEffect", defaultvalue=33},
				["Fader 3"]={template="FLFO", defaultvalue=63},
				["Fader 4"]={template="FLFO", defaultvalue=63},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Fader 7"]={template="FEffect", defaultvalue=127},
				["Fader 8"]={template="FEffect", defaultvalue=127},
			},
			["BBD"]={
				["Fader 2"]={template="FEffect", defaultvalue=33},
				["Fader 3"]={template="FLFO", defaultvalue=63},
				["Fader 4"]={template="FLFO", defaultvalue=63},
				["Fader 5"]={template="FEffect", defaultvalue=0},
				["Fader 7"]={template="FEffect", defaultvalue=127},
				["Fader 8"]={template="FEffect", defaultvalue=127},
			},
			["FFT"]={
				["UDVButton 5-2_6-2"]={template="UDEffect", defaultvalue=2},
				["Fader 3"]={template="FLFO", defaultvalue=63},
				["Fader 4"]={template="FEffect", defaultvalue=0},
				["Fader 5"]={template="FEffect", defaultvalue=127},
				["Fader 7"]={template="FEffect", defaultvalue=127},
				["Fader 8"]={template="FEffect", defaultvalue=127},
			},
			["Grain"]={
				["Button 5-1"]={template="BRedOnOff"},
				["Fader 3"]={template="FEffect", defaultvalue=63},
				["Fader 4"]={template="FLFO", defaultvalue=50},
				["Fader 5"]={template="FEffect", defaultvalue=63},
				["Fader 6"]={template="FEffect", defaultvalue=70},
				["Fader 7"]={template="FEffect", defaultvalue=127},
				["Fader 8"]={template="FEffect", defaultvalue=127},
			},
		},
	},
	["Saturation Knob"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-4_2-4"]={template="UDEffect", defaultvalue=1},
		},
	},
	["Scream 4 Distortion"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Cut"},
			["Button 2-8"]={helptext="Goto Body"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Cut"},
			["Button B3"]={template="BEffectPage", helptext="Goto Body"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=30},
			["Fader 7"]={template="FGain", defaultvalue=85},
		},
		["Cut"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Cut"},
			["Button B3"]={template="BEffectPage", helptext="Goto Body"},
			["Button 1-2"]={template="BRedOnOff"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FFreq"},
			["Knob V6"]={template="FFreq"},
		},
		["Body"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Cut"},
			["Button B3"]={template="BEffectPage", helptext="Goto Body"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=105},
			["Fader 5"]={template="FEffect", defaultvalue=40},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["UDVButton 1-7_2-7"]={template="UDEffect", inverted=true, defaultvalue=0},
		},
	},
	["Softtube Amp"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Eq"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Eq"},
			["UDVButton 1-2_2-2"]={template="UDEffect", defaultvalue=0},
			["UDVButton 5-2_6-2"]={template="UDEffect", defaultvalue=0},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 4"]={template="FGain", defaultvalue=64},
			["Fader 7"]={template="FGain", defaultvalue=64},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Eq"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Eq"},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Fader 4"]={template="FGain", defaultvalue=64},
			["Fader 5"]={template="FGain", defaultvalue=64},
		},
	},
	["Softtube Bass Amp"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Eq"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Eq"},
			["UDVButton 1-2_2-2"]={template="UDEffect", defaultvalue=0},
			["UDVButton 5-2_6-2"]={template="UDEffect", defaultvalue=0},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Fader 8"]={template="FVol", defaultvalue=64},
		},
		["Eq"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BFilterPage", helptext="Goto Eq"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Fader 4"]={template="FGain", defaultvalue=64},
			["UDVButton 7-5_8-5"]={template="UDFreq", defaultvalue=0},
			["Button 8-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FGain", defaultvalue=64},
		},
	},
	["Sweeper"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B3"]={template="BEnvPage", helptext="Goto Modulator"},
			["Button 8-1"]={template="BBlueOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=127},
			["Fader 8"]={template="FGain", defaultvalue=63},
			["ARadioButton3"]={template="BRedOnOff"},
			["Phaser"]={
				["Fader 2"]={template="FFreq", defaultvalue=63},
				["Fader 3"]={template="FEffect", defaultvalue=30},
				["Fader 4"]={template="FEffect", defaultvalue=63},
				["UDVButton 1-5_2-5"]={template="UDEffect", defaultvalue=4},
				["Button 5-5"]={template="BRedOnOff"},
				["Button 7-5"]={template="BRedOnOff"},
			},
			["Flanger"]={
				["Fader 2"]={template="FFreq", defaultvalue=63},
				["Fader 4"]={template="FEffect", defaultvalue=63},
				["Button 5-5"]={template="BRedOnOff"},
				["Button 7-5"]={template="BRedOnOff"},
			},
			["Filter"]={
				["Fader 2"]={template="FGain", defaultvalue=30},
				["Fader 3"]={template="FFreq", defaultvalue=63},
				["Fader 4"]={template="FEffect", defaultvalue=0},
				["UDVButton 1-5_2-5"]={template="UDFreq", defaultvalue=4},
			},
		},
		["LFO"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B3"]={template="BEnvPage", helptext="Goto Modulator"},
			["UDVButton 1-1_2-1"]={template="UDLFO", defaultvalue=1},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq", defaultvalue=15},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=0},
			["Fader 5"]={template="FLFO", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=63},
			["Fader 8"]={template="FGain", defaultvalue=63},
		},
		["Modulator"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO"},
			["Button B3"]={template="BEnvPage", helptext="Goto Modulator"},
			["ARadioButton2"]={template="BRedOnOff", inverted=true},
			["Env"]={
				["Button 8-1"]={template="BRedOnOff"},
				["Button 1-2"]={template="BRedOnOff"},
				["Button 8-2"]={template="BRedOnOff"},
				["Fader 3"]={template="FFreq", defaultvalue=63},
				["UDVButton 7-3_8-3"]={template="UDFreq", defaultvalue=0},
				["Button 8-4"]={template="BRedOnOff"},
				["Fader 5"]={template="FEffect", defaultvalue=30},
			},
			["Audio"]={
				["Fader 2"]={template="FGain", defaultvalue=63},
				["Fader 3"]={template="FLFO", defaultvalue=63},
				["Fader 4"]={template="FLFO", defaultvalue=63},
			},
			["Fader 6"]={template="FLFO", defaultvalue=0},
			["Fader 7"]={template="FFreq", defaultvalue=63},
			["Fader 8"]={template="FGain", defaultvalue=63},
		},
	},
	["Synchronous"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-5"]={helptext="Goto Filter"},
			["Button 2-8"]={helptext="Goto Dist"},
			["Button 3-8"]={helptext="Goto Delay"},
			["Button 4-8"]={helptext="Goto Reverb"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Fader 3"]={template="FGain", defaultvalue=64},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=127},
			["Fader 7"]={template="FGain", defaultvalue=64},
		},
		["Dist"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDEffect", defaultvalue=1},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
		},
		["Filter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDEffect", defaultvalue=1},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 5"]={template="FEffect", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=0},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["UDVButton 7-4_8-4"]={template="UDFreq", defaultvalue=2},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Button 8-7"]={template="BRedOnOff"},
			["Knob V8"]={template="FEffect"},
		},
		["Reverb"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Dist"},
			["Button B3"]={template="BFilterPage", helptext="Goto Filter"},
			["Button B4"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B5"]={template="BEffectPage", helptext="Goto Reverb"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect", defaultvalue=64},
			["Fader 4"]={template="FFreq", defaultvalue=64},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=25},
			["Button 8-8"]={template="BRedOnOff"},
		},
	},
	["The Echo"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 2-8"]={helptext="Goto Delay"},
			["Button 3-8"]={helptext="Goto Feedback"},
			["Button 4-8"]={helptext="Goto Color"},
			["Button 5-5"]={helptext="Goto Modulation"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B3"]={template="BEffectPage", helptext="Goto Feedback"},
			["Button B4"]={template="BEffectPage", helptext="Goto Color"},
			["Button B5"]={template="BLFOPage", helptext="Goto Modulation"},
			["UDVButton 1-2_2-2"]={template="UDEffect", defaultvalue=2},
			["Button 1-3"]={template="BYellowOnOff"},
			["Fader 4"]={template="FEffect", defaultvalue=0},
			["Fader 6"]={template="FEffect", defaultvalue=0},
			["Fader 7"]={template="FEffect", defaultvalue=127},
		},
		["Delay"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B3"]={template="BEffectPage", helptext="Goto Feedback"},
			["Button B4"]={template="BEffectPage", helptext="Goto Color"},
			["Button B5"]={template="BLFOPage", helptext="Goto Modulation"},
			["Fader 2"]={template="FFreq", defaultvalue=76},
			["UDVButton 7-2_8-2"]={template="UDFreq", defaultvalue=11},
			["Fader 3"]={template="FFreq", defaultvalue=0},
			["Button 1-4"]={template="BYellowOnOff"},
			["Button 1-5"]={template="BYellowOnOff"},
			["Button 8-5"]={template="BYellowOnOff"},
			["Knob V6"]={template="FEffect"},
		},
		["Feedback"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B3"]={template="BEffectPage", helptext="Goto Feedback"},
			["Button B4"]={template="BEffectPage", helptext="Goto Color"},
			["Button B5"]={template="BLFOPage", helptext="Goto Modulation"},
			["Fader 2"]={template="FEffect"},
			["Knob V3"]={template="FEffect", defaultvalue=20},
			["Button 1-5"]={template="BYellowOnOff"},
			["Fader 6"]={template="FEffect", defaultvalue=64},
			["Fader 7"]={template="FAmount", defaultvalue=64},
		},
		["Color"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B3"]={template="BEffectPage", helptext="Goto Feedback"},
			["Button B4"]={template="BEffectPage", helptext="Goto Color"},
			["Button B5"]={template="BLFOPage", helptext="Goto Modulation"},
			["Fader 2"]={template="FAmount", defaultvalue=29},
			["UDVButton 1-3_2-3"]={template="UDEffect", defaultvalue=3},
			["Button 1-5"]={template="BYellowOnOff"},
			["Fader 6"]={template="FFreq", defaultvalue=64},
			["Fader 7"]={template="FEffect", defaultvalue=64},
		},
		["Modulation"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BEffectPage", helptext="Goto Delay"},
			["Button B3"]={template="BEffectPage", helptext="Goto Feedback"},
			["Button B4"]={template="BEffectPage", helptext="Goto Color"},
			["Button B5"]={template="BLFOPage", helptext="Goto Modulation"},
			["Knob V2"]={template="FEnv"},
			["Fader 3"]={template="FEffect", defaultvalue=0},
			["Fader 5"]={template="FFreq", defaultvalue=29},
			["Fader 6"]={template="FLFO", defaultvalue=0},
		},
	},
	["UN-16 Unison"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true, defaultvalue=0},
			["Fader 4"]={template="FEffect", defaultvalue=40},
			["Fader 8"]={template="FEffect", defaultvalue=127},
		},
	},
	["Matrix"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button 2-1"]={template="BPerfOnOff"},
			["Button 2-2"]={template="BPerfOnOff"},
			["Button 2-3"]={template="BPerfOnOff"},
			["Button 2-4"]={template="BPerfOnOff"},
			["Button 3-1"]={template="BPerfOnOff"},
			["Button 3-2"]={template="BPerfOnOff"},
			["Button 3-3"]={template="BPerfOnOff"},
			["Button 3-4"]={template="BPerfOnOff"},
			["Button 5-1"]={template="BPerfOnOff"},
			["Button 5-2"]={template="BPerfOnOff"},
			["Button 5-3"]={template="BPerfOnOff"},
			["Button 5-4"]={template="BPerfOnOff"},
			["UDVButton 7-8_8-8"]={template="UDFreq"},
			["Button 8-1"]={template="BRun"},
		},
	},
	["RPG-8"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-5"]={helptext="Goto Pattern"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Pattern"},
			["Fader 2"]={template="FPerf"},
			["Button 1-3"]={template="BRedOnOff"},
			["UDVButton 3-3_4-3"]={template="UDFreq"},
			["Button 1-4"]={template="BRedOnOff"},
			["UDVButton 3-4_4-4"]={template="UDEffect"},
			["UDVButton 5-4_6-4"]={template="UDFreq"},
			["UDVButton 7-4_8-4"]={template="UDEffect"},
			["Button 8-5"]={template="BRedOnOff"},
			["UDVButton 7-6_8-6"]={template="UDFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
			["Button 8-8"]={template="BRedOnOff"},
		},
		["Pattern"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Pattern"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 2-5"]={template="BRedOnOff"},
			["Button 2-6"]={template="BRedOnOff"},
			["Button 2-7"]={template="BRedOnOff"},
			["Button 2-8"]={template="BRedOnOff"},
			["Button 3-1"]={template="BRedOnOff"},
			["UDVButton 3-8_4-8"]={template="UDPerf"},
			["Button 8-1"]={template="BRedOnOff"},
		},
	},
	["Pulsar"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 5-5"]={helptext="Goto LFO1"},
			["Button 6-5"]={helptext="Goto LFO2"},
			["Button 5-6"]={helptext="Goto Env"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B3"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B4"]={template="BEnvPage", helptext="Goto Env"},
			["Knob V3"]={template="FMisc"},
			["Knob V4"]={template="FMisc"},
			["Button 8-5"]={template="BRedOnOff"},
			["Knob V7"]={template="FMisc"},
		},
		["LFO 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B3"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B4"]={template="BEnvPage", helptext="Goto Env"},
			["Button 7-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["UDVButton 1-3_2-3"]={template="UDLFO"},
			["Fader 4"]={template="FAmount"},
			["Fader 5"]={template="FLFO"},
			["Fader 6"]={template="FLFO"},
			["Fader 7"]={template="FFreq"},
		},
		["LFO 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B3"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B4"]={template="BEnvPage", helptext="Goto Env"},
			["Button 7-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["UDVButton 1-3_2-3"]={template="UDLFO"},
			["Fader 4"]={template="FAmount"},
			["Fader 5"]={template="FLFO"},
			["Fader 6"]={template="FLFO"},
			["Fader 7"]={template="FFreq"},
		},
		["Env"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BLFOPage", helptext="Goto LFO1"},
			["Button B3"]={template="BLFOPage", helptext="Goto LFO2"},
			["Button B4"]={template="BEnvPage", helptext="Goto Env"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEnv"},
			["Fader 4"]={template="FEnv"},
			["Knob V5"]={template="FAmount"},
			["Knob V6"]={template="FFreq"},
			["Knob V7"]={template="FAmount"},
			["Knob V8"]={template="FFreq"},
		},
	},
	["Line Mixer 6:2"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Level"},
			["Button 1-3"]={helptext="Goto Pan"},
			["Button 1-4"]={helptext="Goto Meter"},
			["Button 1-5"]={helptext="Goto MutesAndSolos"},
			["Button 2-8"]={helptext="Goto AuxSend"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Level"},
			["Button B3"]={template="BAmpPage", helptext="Goto Pan"},
			["Button B4"]={template="BAmpPage", helptext="Goto Meter"},
			["Button B8"]={template="BEffectPage", helptext="Goto AuxSend"},
			["UDVButton 7-3_8-3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FVol"},
		},
		["Level"]={
			["Fader 1"]={template="FVol"},
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Level"},
			["Button B3"]={template="BAmpPage", helptext="Goto Pan"},
			["Button B4"]={template="BAmpPage", helptext="Goto Meter"},
			["Button B8"]={template="BEffectPage", helptext="Goto AuxSend"},
			["Button A7"]={template="BMute"},
			["Button A8"]={template="BSolo"},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
			},
		},
		["Pan"]={
			["Knob V1"]={template="FPan"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FPan"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FPan"},
			["Knob V6"]={template="FPan"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Level"},
			["Button B3"]={template="BAmpPage", helptext="Goto Pan"},
			["Button B4"]={template="BAmpPage", helptext="Goto Meter"},
			["Button B8"]={template="BEffectPage", helptext="Goto AuxSend"},
			["Button A7"]={template="BMute"},
			["Button A8"]={template="BSolo"},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
			},
		},
		["Aux Send"]={
			["Fader 1"]={template="FEffect"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Level"},
			["Button B3"]={template="BAmpPage", helptext="Goto Pan"},
			["Button B4"]={template="BAmpPage", helptext="Goto Meter"},
			["Button B8"]={template="BEffectPage", helptext="Goto AuxSend"},
			["Button A7"]={template="BMute"},
			["Button A8"]={template="BSolo"},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
			},
		},
		["Meter"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Level"},
			["Button B3"]={template="BAmpPage", helptext="Goto Pan"},
			["Button B4"]={template="BAmpPage", helptext="Goto Meter"},
			["Button B8"]={template="BEffectPage", helptext="Goto AuxSend"},
			["Button A7"]={template="BMute"},
			["Button A8"]={template="BSolo"},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
			},
		},
		["MutesAndSolos"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BAmpPage", helptext="Goto Level"},
			["Button B3"]={template="BAmpPage", helptext="Goto Pan"},
			["Button B4"]={template="BAmpPage", helptext="Goto Meter"},
			["Button B8"]={template="BEffectPage", helptext="Goto AuxSend"},
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BMute"},
			["Button 1-4"]={template="BMute"},
			["Button 1-5"]={template="BMute"},
			["Button 1-6"]={template="BMute"},
			["Button 2-1"]={template="BSolo"},
			["Button 2-2"]={template="BSolo"},
			["Button 2-3"]={template="BSolo"},
			["Button 2-4"]={template="BSolo"},
			["Button 2-5"]={template="BSolo"},
			["Button 2-6"]={template="BSolo"},
		},
	},
	["Mixer 14:2"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-2"]={helptext="Goto Level1-7"},
			["Button 1-3"]={helptext="Goto Level8-14"},
			["Button 2-2"]={helptext="Goto Pan1-7"},
			["Button 2-3"]={helptext="Goto Pan8-14"},
			["Button 7-1"]={helptext="Goto Chan1"},
			["Button 7-2"]={helptext="Goto Chan2"},
			["Button 7-3"]={helptext="Goto Chan3"},
			["Button 7-4"]={helptext="Goto Chan4"},
			["Button 7-5"]={helptext="Goto Chan5"},
			["Button 7-6"]={helptext="Goto Chan6"},
			["Button 7-7"]={helptext="Goto Chan7"},
			["Button 8-1"]={helptext="Goto Chan8"},
			["Button 8-2"]={helptext="Goto Chan9"},
			["Button 8-3"]={helptext="Goto Chan10"},
			["Button 8-4"]={helptext="Goto Chan11"},
			["Button 8-5"]={helptext="Goto Chan12"},
			["Button 8-6"]={helptext="Goto Chan13"},
			["Button 8-7"]={helptext="Goto Chan14"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FVol"},
		},
		["Channel 1-7"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Channel1-7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Channel8-14"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
		},
		["Channel 8-14"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel8-14"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Channel1-7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Channel8-14"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
		},
		["Level 1-7"]={
			["Fader 1"]={template="FVol"},
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Level8-14"},
			["Button 6-8"]={template="BAmpPage"},
			["Button 7-8"]={template="BMute"},
			["Button 8-8"]={template="BSolo"},
			["Channel"]={
				["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
				["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
				["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
				["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
				["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
				["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
				["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
				["Button A7"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
				["Button A7"]={template="BSolo"},
			},
		},
		["Level 8-14"]={
			["Fader 1"]={template="FVol"},
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level8-14"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Level8-14"},
			["Button 6-8"]={template="BAmpPage"},
			["Button 7-8"]={template="BMute"},
			["Button 8-8"]={template="BSolo"},
			["Channel"]={
				["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
				["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
				["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
				["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
				["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
				["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
				["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
				["Button A7"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
				["Button A7"]={template="BSolo"},
			},
		},
		["Pan 1-7"]={
			["Knob V1"]={template="FPan"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FPan"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FPan"},
			["Knob V6"]={template="FPan"},
			["Knob V7"]={template="FPan"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Pan1-7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Pan8-14"},
			["Button 6-8"]={template="BAmpPage"},
			["Button 7-8"]={template="BMute"},
			["Button 8-8"]={template="BSolo"},
			["Channel"]={
				["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
				["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
				["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
				["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
				["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
				["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
				["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
				["Button A7"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
				["Button A7"]={template="BSolo"},
			},
		},
		["Pan 8-14"]={
			["Knob V1"]={template="FPan"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FPan"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FPan"},
			["Knob V6"]={template="FPan"},
			["Knob V7"]={template="FPan"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan8-14"},
			["Button B7"]={template="BAmpPage", helptext="Goto Pan1-7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Pan8-14"},
			["Button 6-8"]={template="BAmpPage"},
			["Button 7-8"]={template="BMute"},
			["Button 8-8"]={template="BSolo"},
			["Channel"]={
				["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
				["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
				["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
				["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
				["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
				["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
				["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			},
			["Mute"]={
				["Button A1"]={template="BMute"},
				["Button A2"]={template="BMute"},
				["Button A3"]={template="BMute"},
				["Button A4"]={template="BMute"},
				["Button A5"]={template="BMute"},
				["Button A6"]={template="BMute"},
				["Button A7"]={template="BMute"},
			},
			["Solo"]={
				["Button A1"]={template="BSolo"},
				["Button A2"]={template="BSolo"},
				["Button A3"]={template="BSolo"},
				["Button A4"]={template="BSolo"},
				["Button A5"]={template="BSolo"},
				["Button A6"]={template="BSolo"},
				["Button A7"]={template="BSolo"},
			},
		},
		["Channel 1"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 2"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 3"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 4"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 5"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 6"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 7"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan7"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan2"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan3"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan4"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan5"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan6"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan7"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 8"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 9"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 10"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 11"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 12"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 13"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Channel 14"]={
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerformancePage", helptext="Goto Channel1-7"},
			["Button B3"]={template="BAmpPage", helptext="Goto Level1-7"},
			["Button B4"]={template="BLFOPage", helptext="Goto Pan1-7"},
			["Button B7"]={template="BAmpPage", helptext="Goto Chan1"},
			["Button B8"]={template="BAmpPage", helptext="Goto Chan14"},
			["Button A1"]={template="BAmpPage", helptext="Goto Chan8"},
			["Button A2"]={template="BAmpPage", helptext="Goto Chan9"},
			["Button A3"]={template="BAmpPage", helptext="Goto Chan10"},
			["Button A4"]={template="BAmpPage", helptext="Goto Chan11"},
			["Button A5"]={template="BAmpPage", helptext="Goto Chan12"},
			["Button A6"]={template="BAmpPage", helptext="Goto Chan13"},
			["Button A7"]={template="BAmpPage", helptext="Goto Chan14"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
	},
	["BeatMap"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-2"]={template="BRun"},
		},
	},
	["Dual Arpeggio"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Arp1"},
			["Button B3"]={template="BPerfPage", helptext="Goto Arp2"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button 1-6"]={helptext="Goto Arp1"},
			["Button 1-7"]={helptext="Goto Arp2"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Arp1"},
			["Button B3"]={template="BPerfPage", helptext="Goto Arp2"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
		},
		["Arp 1"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Arp1"},
			["Button B3"]={template="BPerfPage", helptext="Goto Arp2"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDPerf", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", defaultvalue=127},
			["Button 8-1"]={template="BGreenOnOff"},
			["UDVButton 1-3_2-3"]={template="UDPerf", defaultvalue=15},
			["UDVButton 3-3_4-3"]={template="UDPerf2", defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDPerf", defaultvalue=0},
			["Button 1-5"]={template="BBAmberOnOff"},
			["Button 3-5"]={template="BBGreenOnOff"},
			["Button 5-5"]={template="BBBlueOnOff"},
			["UDVButton 1-6_2-6"]={template="UDPerf", defaultvalue=4},
			["UDVButton 1-8_2-8"]={template="UDPerf", defaultvalue=16},
			["UDVButton 3-8_4-8"]={template="UDPerf", defaultvalue=24},
			["MFader 7-8"]={template="UDPerf"},
		},
		["Arp 2"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Arp1"},
			["Button B3"]={template="BPerfPage", helptext="Goto Arp2"},
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDPerf", defaultvalue=0},
			["UDVButton 3-2_4-2"]={template="UDPerf", defaultvalue=127},
			["Button 8-1"]={template="BGreenOnOff"},
			["UDVButton 1-3_2-3"]={template="UDPerf", defaultvalue=15},
			["UDVButton 3-3_4-3"]={template="UDPerf2", defaultvalue=0},
			["UDVButton 5-3_6-3"]={template="UDPerf", defaultvalue=0},
			["Button 1-5"]={template="BBAmberOnOff"},
			["Button 3-5"]={template="BBGreenOnOff"},
			["Button 5-5"]={template="BBBlueOnOff"},
			["UDVButton 1-6_2-6"]={template="UDPerf", defaultvalue=4},
			["UDVButton 1-8_2-8"]={template="UDPerf", defaultvalue=16},
			["UDVButton 3-8_4-8"]={template="UDPerf", defaultvalue=24},
			["MFader 7-8"]={template="UDPerf"},
		},
	},
	["Scales & Chords"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Scales"},
			["Button B3"]={template="BPerfPage", helptext="Goto Chords"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Scales"},
			["Button B3"]={template="BPerfPage", helptext="Goto Chords"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BBAmberOnOff"},
		},
		["Scales"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Scales"},
			["Button B3"]={template="BPerfPage", helptext="Goto Chords"},
			["UDVButton 1-1_2-1"]={template="UDPerf", defaultvalue=0},
			["UDVButton 1-5_2-5"]={template="UDPerf", defaultvalue=1},
		},
		["Chords"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button B2"]={template="BPerfPage", helptext="Goto Scales"},
			["Button B3"]={template="BPerfPage", helptext="Goto Chords"},
			["Button 1-1"]={template="BBGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDPerf", defaultvalue=2},
			["UDVButton 3-3_4-3"]={template="UDPerf", defaultvalue=0},
			["Button 3-5"]={template="BBGreenOnOff"},
			["Button 2-7"]={template="BBGreenOnOff"},
			["Button 3-7"]={template="BBGreenOnOff"},
			["Button 4-7"]={template="BBGreenOnOff"},
			["Button 3-8"]={template="BBGreenOnOff"},
		},
	},
	["Note Echo"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["MFader 1-3"]={template="FFreq"},
			["UDVButton 1-3_2-3"]={template="UDFreq", defaultvalue=10},
			["Button 1-4"]={template="BBAmberOnOff"},
			["UDVButton 1-6_2-6"]={template="UDFreq", defaultvalue=3},
			["MFader 1-8"]={template="FPerf"},
			["UDVButton 3-8_4-8"]={template="UDOsc", defaultvalue=12},
			["Button 5-1"]={template="BPerfOnOff"},
			["Step1"]={
				["Button 6-1"]={template="BPerfOnOff"},
			},
			["Step2"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
			},
			["Step3"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
			},
			["Step4"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
			},
			["Step5"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
			},
			["Step6"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
			},
			["Step7"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
			},
			["Step8"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
			},
			["Step9"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
			},
			["Step10"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
			},
			["Step11"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
			},
			["Step12"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
				["Button 7-4"]={template="BPerfOnOff"},
			},
			["Step13"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
				["Button 7-4"]={template="BPerfOnOff"},
				["Button 7-5"]={template="BPerfOnOff"},
			},
			["Step14"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
				["Button 7-4"]={template="BPerfOnOff"},
				["Button 7-5"]={template="BPerfOnOff"},
				["Button 7-6"]={template="BPerfOnOff"},
			},
			["Step15"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
				["Button 7-4"]={template="BPerfOnOff"},
				["Button 7-5"]={template="BPerfOnOff"},
				["Button 7-6"]={template="BPerfOnOff"},
				["Button 7-7"]={template="BPerfOnOff"},
			},
			["Step16"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
				["Button 7-4"]={template="BPerfOnOff"},
				["Button 7-5"]={template="BPerfOnOff"},
				["Button 7-6"]={template="BPerfOnOff"},
				["Button 7-7"]={template="BPerfOnOff"},
				["Button 7-8"]={template="BPerfOnOff"},
			},
			["Step17"]={
				["Button 6-1"]={template="BPerfOnOff"},
				["Button 6-2"]={template="BPerfOnOff"},
				["Button 6-3"]={template="BPerfOnOff"},
				["Button 6-4"]={template="BPerfOnOff"},
				["Button 6-5"]={template="BPerfOnOff"},
				["Button 6-6"]={template="BPerfOnOff"},
				["Button 6-7"]={template="BPerfOnOff"},
				["Button 6-8"]={template="BPerfOnOff"},
				["Button 7-1"]={template="BPerfOnOff"},
				["Button 7-2"]={template="BPerfOnOff"},
				["Button 7-3"]={template="BPerfOnOff"},
				["Button 7-4"]={template="BPerfOnOff"},
				["Button 7-5"]={template="BPerfOnOff"},
				["Button 7-6"]={template="BPerfOnOff"},
				["Button 7-7"]={template="BPerfOnOff"},
				["Button 7-8"]={template="BPerfOnOff"},
				["Button 8-1"]={template="BPerfOnOff"},
			},
		},
	},
	["Drum Sequencer"]={
		["Internal"]={
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Main"},
		},
		["Index"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button 1-1"]={helptext="Goto Main"},
			["Button C7"]={helptext="Goto Internal"},
		},
		["Main"]={
			["Button B1"]={template="BMainPage", helptext="Goto Main"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-3"]={template="BBRedOnOff"},
			["Button 1-4"]={template="BGreenOnOff"},
		},
	},
}
local items = {
	{name = "Keyboard", input = "keyboard"},
	{name = "DeviceScope", output = "text" },
	{name = "DeviceName", output = "text" },
	{name = "PatchName", output = "text" },
	{name = "PageName", output = "text" },
	{name = "SubPageName", output = "text" },
	{name = "KbdPageName", output = "text" },
	{name = "DocPageName", output = "text" },
	{name = "PlayingStep", output = "text" },
	{name = "KeyboardMode", output = "text" },
	{name = "KbdVel", output = "text" },
	{name = "BaseKey", output = "text" },
	{name = "Aftertouch", input = "value", output = "value", min = 0, max = 127},
	{name = "BarPosition", input= "button", output = "value", min = 0, max = 127},
	{name = "BeatPosition", input= "button", output = "value", min = 0, max = 127},
	{name = "EFSButton", input= "value", output = "value", min = 0, max = 2},
	{name = "ARadioButton2", input= "value", output = "value", min = 0, max = 1, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "ARadioButton3", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "ARadioButton4", input= "value", output = "value", min = 0, max = 3, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EngineSelect", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EffectSelect", input= "value", output = "value", min = 0, max = 5, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EditSelect", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "LFOSelect", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EnvSelect", input= "value", output = "value", min = 0, max = 3, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "PWSelect", input= "value", output = "value", min = 0, max = 3, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "Hidden", input = "delta", output = "value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "Fader 1", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 2", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 3", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 4", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 5", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 6", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 7", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 8", input = "value", output = "value", min = 0, max = 127},
	{name = "BigFader 1", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 2", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 3", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 4", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 5", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 6", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 7", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 8", input = "value", output = "value", min = 0, max = 1023},
	{name = "Drawbar 1", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 2", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 3", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 4", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 5", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 6", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 7", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 8", input = "value", output = "value", min = 0, max = 127},
	{name = "Meter 1", output = "value", min = 0, max = 68},
	{name = "Meter 2", output = "value", min = 0, max = 68},
	{name = "Meter 3", output = "value", min = 0, max = 68},
	{name = "Meter 4", output = "value", min = 0, max = 68},
	{name = "Meter 5", output = "value", min = 0, max = 68},
	{name = "Meter 6", output = "value", min = 0, max = 68},
	{name = "Meter 7", output = "value", min = 0, max = 68},
	{name = "Meter 8", output = "value", min = 0, max = 68},
	{name = "Knob V1", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V2", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V3", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V4", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V5", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V6", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V7", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V8", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H1", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H2", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H3", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H4", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H5", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H6", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H7", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H8", input = "value", output = "value", min = 0, max = 127},
	{name = "Side LED", input = "value", output = "value", min = 0, max = 127},
}

local function hex_encode_text(text)
	local hexstring = ""

	for i = 1, #text do
		hexstring = hexstring..string.format("%02x ", string.byte(text:sub(i,i)))
	end

	return hexstring
end

-- Merge table2 into table1
-- function mergetables(table1, table2)
-- 	for k,v in pairs(table2) do
-- 		table1[k] = v
-- 	end
-- end

function isaftertouch(button)
	return(button ~= nil and button.x == 0xa0)
end

function isbutton(button)
	return(button ~= nil and (button.x == 0x90 or button.x == 0xb0))
end
function gen_scroll_string(string, color, speed)
	return(string.format("%s %02x %02x %02x %s F7", MIDI_OUT_SCROLL, color, 0, speed, hex_encode_text(string)))
end

function get_veloctity(velocity)
	return(velocity)
end

function get_rgb_midi(color)
	if(color == nil) then
		error("Undefined color")
	end
	local r,g,b = string.match(color, "(..)(..)(..)")
	return(string.format("%02x %02x %02x", tonumber(r,16)/4, tonumber(g,16)/4, tonumber(b,16)/4))
end

function dim_color(colorlow, colorhigh, dimlevel)
	local rl,gl,bl = string.match(colorlow, "(..)(..)(..)")
	local rh,gh,bh = string.match(colorhigh, "(..)(..)(..)")
	local r = tonumber(rl,16) + (tonumber(rh,16) - tonumber(rl,16)) * dimlevel
	local g = tonumber(gl,16) + (tonumber(gh,16) - tonumber(gl,16)) * dimlevel
	local b = tonumber(bl,16) + (tonumber(bh,16) - tonumber(bl,16)) * dimlevel
	return(string.format("%02x%02x%02x", r, g, b))
end

-- function gen_color_midi(button, color)
-- 	local buttonmidi = string.match(button, ".. (..)")
-- 	return(string.format("f0 00 20 29 02 10 0b %s %s f7", buttonmidi, get_rgb_midi(color)))
-- end
function get_item_bvmap(itemname)
	local currentpage = get_current_page()
	local scope = g_colorscheme

	local itemtype = get_item_conf_map_field(scope, currentpage, itemname, "bvmap")

	if(item_bvmap[itemtype] == nil) then
		itemtype = "Default"
	end

	return(item_bvmap[itemtype])
end

function get_item_conf_map_field(context, page, itemname, field)
	local defaultitemname = string.gsub(itemname, " .+", " *")

	if(field == nil) then
		error("Field is nil")
	end

	if(string.match(get_current_page(), "Internal")) then
		context = "Default"
	end

	if(item_conf_map[context] == nil) then
		context = "Default"
	end

	if(string.match(itemname, "Button [A-H]$")) then
		page = get_current_docpage()
		context = "Default"
	end

	local subpage = get_current_subpage()

	local field_value = check_all_conf_map(context, page, subpage, itemname, field)
	if(field_value == nil) then
		field_value = check_all_conf_map(context, page, subpage, defaultitemname, field)
	end
	if(field_value == nil and subpage ~= "Unknown") then
		field_value = check_all_conf_map(context, page, "Unknown", itemname, field)
		if(field_value == nil) then
			field_value = check_all_conf_map(context, page, "Unknown", defaultitemname, field)
		end
	end

	return(field_value)
end

function check_all_conf_map(context, page, subpage, itemname, field)
	local field_value = check_item_conf_map(context, page, subpage, itemname, field)
	if(field_value == nil) then
		field_value = check_item_conf_map(context, "Default", subpage, itemname, field)
	end
	if(field_value == nil) then
		field_value = check_item_conf_map("Default", page, subpage, itemname, field)
	end
	if(field_value == nil) then
		field_value = check_item_conf_map("Default", "Default", subpage, itemname, field)
	end

	return(field_value)
end

function check_item_conf_map(context, page, subpage, itemname, field)
	if(subpage ~= "Unknown") then
		if(item_conf_map[context] and item_conf_map[context][page] and item_conf_map[context][page][subpage] and item_conf_map[context][page][subpage][itemname] and item_conf_map[context][page][subpage][itemname][field]) then
			return(item_conf_map[context][page][subpage][itemname][field])
		end
	else
		if(item_conf_map[context] and item_conf_map[context][page] and item_conf_map[context][page][itemname] and item_conf_map[context][page][itemname][field]) then
			return(item_conf_map[context][page][itemname][field])
		end
	end
	return(nil)
end

function get_button_color(context, itemname, buttonname)
	local color
	local buttonindex = 0
	local buttonvalue = 0

	local enabled = remote.is_item_enabled(itemsindex[itemname])

	-- Colors
	local activecolor = get_item_conf_map_field(context, get_current_page(), itemname, "activecolor")
	local enabledcolor = get_item_conf_map_field(context, get_current_page(), itemname, "enabledcolor")
	local disabledcolor = get_item_conf_map_field(context, get_current_page(), itemname, "disabledcolor")
	local dactivecolor = get_item_conf_map_field(context, get_current_page(), itemname, "dactivecolor")
	local denabledcolor = get_item_conf_map_field(context, get_current_page(), itemname, "denabledcolor")
	local maxcolor = get_item_conf_map_field(context, get_current_page(), itemname, "maxcolor")
	--Config
	local defaultvalue = get_item_conf_map_field(context, get_current_page(), itemname, "defaultvalue")

	local citem_conf_map_template = color_templates[get_item_conf_map_field(context, get_current_page(), itemname, "template")]

	if(citem_conf_map_template ~= nil) then
		if(citem_conf_map_template.activecolor ~= nil) then
			activecolor = citem_conf_map_template.activecolor
		end
		if(citem_conf_map_template.enabledcolor ~= nil) then
			enabledcolor = citem_conf_map_template.enabledcolor
		end
		if(citem_conf_map_template.disabledcolor ~= nil) then
			disabledcolor = citem_conf_map_template.disabledcolor
		end
		if(citem_conf_map_template.dactivecolor ~= nil) then
			dactivecolor = citem_conf_map_template.dactivecolor
		end
		if(citem_conf_map_template.denabledcolor ~= nil) then
			denabledcolor = citem_conf_map_template.denabledcolor
		end
		if(citem_conf_map_template.maxcolor ~= nil) then
			maxcolor = citem_conf_map_template.maxcolor
		end
		if(citem_conf_map_template.defaultvalue ~= nil) then
			defaultvalue = citem_conf_map_template.defaultvalue
		end
	end

	if(activecolor == nil) then
		error(string.format("activecolor is nil, device: %s page: %s item: %s", context, get_current_page(), itemname))
	end

	if(denabledcolor == nil) then
		denabledcolor = enabledcolor
	end
	if(dactivecolor == nil) then
		dactivecolor = activecolor
	end

	local value = remote.get_item_value(itemsindex[itemname])
	local textvalue = tonumber(remote.get_item_text_value(itemsindex[itemname]))

	if(g_scopetext == "Redrum" and string.match(get_current_page(), "Main") and (string.match(itemname, "Button [78]%-%d"))) then
		if(g_playingbutton == itemname and (tonumber(remote.get_item_text_value(itemsindex["Button 6-1"])) == 1)) then
			return(REDRUM_HIT)
		else
			if(textvalue == 1) then
				return(REDRUM_SOFT)
			elseif(textvalue == 2) then
				return(REDRUM_MEDIUM)
			elseif(textvalue == 3) then
				return(REDRUM_HARD)
			else
				return(REDRUM_NOHIT)
			end
		end
	end
	if(g_scopetext == "Redrum" and string.match(get_current_page(), "Main") and (string.match(itemname, "Button 6%-5"))) then
		if(textvalue == 1) then
			return(REDRUM_SOFT)
		elseif(textvalue == 2) then
			return(REDRUM_MEDIUM)
		elseif(textvalue == 3) then
			return(REDRUM_HARD)
		else
			return(REDRUM_NOHIT)
		end
	end
	if(g_scopetext == "Thor" and string.match(get_current_page(), "Step Sequencer") and (string.match(itemname, "Button [12]%-%d"))) then
		if(g_playingbutton == itemname and (tonumber(remote.get_item_value(itemsindex["Button 8-1"])) == 1)) then
			return(THOR_SEQ_ACTIVE)
		else
			if(value == 1) then
				return(THOR_SEQ_STEPON)
			else
				return(THOR_SEQ_STEPOFF)
			end
		end
	end

	if(string.find(itemname, "ARadioButton")) then
		local abuttonnum = tonumber(string.sub(buttonname, -1,-1))
		if(get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "inverted")) then
			abuttonnum = tonumber(string.match(itemname, "ARadioButton(%d)"))-abuttonnum+1
		end
		if(abuttonnum-1 == value) then
			color = activecolor
		else
			color = enabledcolor
		end
	elseif(string.find(itemname, "EFSButton")) then
		buttonindex = tonumber(string.sub(buttonname, -3,-3))
		if(enabled) then
			if(buttonindex == 3-value) then
				color = efsactive[buttonindex]
			else
				color = efsinactive[buttonindex]
			end
		end
	elseif(string.find(itemname, "UDHButton %d%-%d_%d%-%d") or string.find(itemname, "UDVButton %d%-%d_%d%-%d")) then
		if(enabled) then
			if(g_buttondown[buttonname] ~= nil) then
				color = activecolor
			else
				color = enabledcolor
			end
		else
			color = disabledcolor
		end
	elseif(string.find(itemname, "Button %d%-%d") or string.find(itemname, "Button C%d") or string.find(itemname, "Button %a")) then
		if(enabled) then
			if(value == 1) then
				color = activecolor
			else
				color = enabledcolor
			end
		else
			color = disabledcolor
		end
	else
		if(string.find(itemname, "Drawbar %d")) then
			buttonindex = 9-tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "Meter %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "BigFader %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "MFader %d%-%d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex%2+1]
		elseif(string.find(itemname, "Fader %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "Knob V%d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "Knob H%d")) then
			buttonindex = 9-tonumber(string.sub(buttonname, -1,-1))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		end

		if(string.find(itemname, "MFader %d%-%d")) then
			local prevbuttonvalue = 0
			if((buttonindex%2) == 1) then
				prevbuttonvalue = get_item_bvmap(itemname)[(buttonindex+1)%2+1]
			end

			if(value >= buttonvalue) then
				color = activecolor
			elseif(value > prevbuttonvalue) then
				color = dim_color(enabledcolor, activecolor, (value - prevbuttonvalue)/(buttonvalue - prevbuttonvalue))
			else
				color = enabledcolor
			end
		elseif((string.find(itemname, "Fader %d")) or (string.find(itemname, "BigFader %d")) or (string.find(itemname, "Meter %d")) or (string.find(itemname, "Drawbar %d"))) then
			local nextbuttonvalue = 0
			if(buttonindex ~= 8) then
				nextbuttonvalue = get_item_bvmap(itemname)[buttonindex+1]
			end

			if(value >= buttonvalue) then
				if(string.find(itemname, "Meter %d") and buttonindex == 0) then
					color = maxcolor
				else
					if((string.find(itemname, "BigFader %d") or string.find(itemname, "Fader %d")) and buttonvalue == defaultvalue) then
						color = dactivecolor
					else
						color = activecolor
					end
				end
			elseif((value > nextbuttonvalue) and (value < buttonvalue)) then
				color = dim_color(enabledcolor, activecolor, (value - nextbuttonvalue)/(buttonvalue - nextbuttonvalue))
			else
				if((string.find(itemname, "BigFader %d") or string.find(itemname, "Fader %d")) and buttonvalue == defaultvalue) then
					color = denabledcolor
				else
					color = enabledcolor
				end
			end
		elseif(string.find(itemname, "Knob H%d") or string.find(itemname, "Knob V%d")) then
			if(value > 64) then
				if(buttonindex <= 4) then
					local nextbuttonvalue = 127
					if(buttonindex < 8) then
						nextbuttonvalue = get_item_bvmap(itemname)[buttonindex+1]
					end

					if(value >= buttonvalue) then
						color = activecolor
					elseif((value > nextbuttonvalue) and (value < buttonvalue)) then
						color = dim_color(enabledcolor, activecolor, (value - nextbuttonvalue)/(buttonvalue - nextbuttonvalue))
					else
						color = enabledcolor
					end
				else
					color = enabledcolor
				end
			elseif(value < 64) then
				if(buttonindex >= 5) then
					local prevbuttonvalue = 0
					if(buttonindex ~= 0) then
						prevbuttonvalue = get_item_bvmap(itemname)[buttonindex-1]
					end

					if(value <= buttonvalue) then
						color = activecolor
					elseif((value < prevbuttonvalue) and (value > buttonvalue)) then
						color = dim_color(enabledcolor, activecolor, (prevbuttonvalue - value)/(prevbuttonvalue - buttonvalue))
					else
						color = enabledcolor
					end
				else
					color = enabledcolor
				end
			else
				if(buttonindex == 4 or buttonindex == 5) then
					color = activecolor
				else
					color = enabledcolor
				end
			end
		else
			local prevbuttonvalue = 0
			if(buttonindex ~= 0) then
				prevbuttonvalue = get_item_bvmap(itemname)[buttonindex-1]
			end

			if(value >= buttonvalue) then
				color = activecolor
			elseif((value > prevbuttonvalue) and (value < buttonvalue)) then
				color = dim_color(enabledcolor, activecolor, (value - prevbuttonvalue)/(buttonvalue - prevbuttonvalue))
			else
				color = enabledcolor
			end
		end
	end

	return color
end

function get_item_by_button(buttonname)
	if(remote.is_item_enabled(itemsindex["ARadioButton2"]) and string.find(buttonname, "Button A")) then
		local num = get_a_button_num(buttonname)
		if(num <= 2) then
			return "ARadioButton2"
		end
	end
	if(remote.is_item_enabled(itemsindex["ARadioButton3"]) and string.find(buttonname, "Button A")) then
		local num = get_a_button_num(buttonname)
		if(num <= 3) then
			return "ARadioButton3"
		end
	end
	if(remote.is_item_enabled(itemsindex["ARadioButton4"]) and string.find(buttonname, "Button A")) then
		local num = get_a_button_num(buttonname)
		if(num <= 4) then
			return "ARadioButton4"
		end
	end
	if(remote.is_item_enabled(itemsindex["EFSButton"])) then
		local row = get_button_row(buttonname)
		local col = get_button_col(buttonname)
		if((col == 1) and (row <= 3)) then
			return "EFSButton"
		end
	end
	for i=1,8 do
		local fadername = "Fader "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
	for i=1,8 do
		local fadername = "BigFader "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
	for i=1,8 do
		local fadername = "Drawbar "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
	for i=1,8 do
		local fadername = "Meter "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
	for i=1,8 do
		local fadername = "Knob H"..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button "..tostring(i).."%-%d")) then
				return fadername
			end
		end
	end
for i=1,8 do
		local fadername = "Knob V"..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
	for row=1,8 do
		for column=1,8,2 do
			local udhbuttonname = "UDHButton "..row.."-"..column.."_"..row.."-"..tostring(column+1)
			if(remote.is_item_enabled(itemsindex[udhbuttonname])) then
				if(string.find(buttonname, "Button "..row.."%-"..column)) then
					return udhbuttonname
				elseif(string.find(buttonname, "Button "..row.."%-"..tostring(column+1))) then
					return udhbuttonname
				end
			end
		end
	end
	for row=1,8,2 do
		for column=1,8 do
			local udvbuttonname = "UDVButton "..row.."-"..column.."_"..tostring(row+1).."-"..column
			if(remote.is_item_enabled(itemsindex[udvbuttonname])) then
				if(string.find(buttonname, "Button "..row.."%-"..column)) then
					return udvbuttonname
				elseif(string.find(buttonname, "Button "..tostring(row+1).."%-"..column)) then
					return udvbuttonname
				end
			end
		end
	end
	for row=1,8,2 do
		for column=1,8 do
			local mfadername = "MFader "..row.."-"..column
			if(remote.is_item_enabled(itemsindex[mfadername])) then
				if(string.find(buttonname, "Button "..row.."%-"..column)) then
					return mfadername
				elseif(string.find(buttonname, "Button "..tostring(row+1).."%-"..column)) then
					return mfadername
				end
			end
		end
	end
	return buttonname
end

function get_current_page()
	local pagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["PageName"])) then
		pagename = remote.get_item_text_value(itemsindex["PageName"])
	end

	return pagename
end

function get_current_kbdpage()
	local kbdpagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["KbdPageName"])) then
		kbdpagename = remote.get_item_text_value(itemsindex["KbdPageName"])
	end

	return kbdpagename
end

function get_current_subpage()
	local subpagename = "Unknown"

	if(get_current_page() == "Keyboard") then
		return(get_current_kbdpage())
	end

	if(remote.is_item_enabled(itemsindex["SubPageName"])) then
		subpagename = remote.get_item_text_value(itemsindex["SubPageName"])
	end

	return subpagename
end

function get_current_docpage()
	local pagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["DocPageName"])) then
		pagename = remote.get_item_text_value(itemsindex["DocPageName"])
	end

	return pagename
end

function get_button_name(button)
	local x = button.x
	if(button.x == 0xa0) then
		x = 0x90
	end
	local midistring = string.format("%02x %02x", x, button.y)
	local buttonname = midi_to_button[midistring]
	if(buttonname == nil) then
		error("No button found for midistring: "..midistring)
	end
	return(buttonname)
end

-- function get_knob_type(itemname)
-- 	return(string.match(itemname, ".+ (.).+"))
-- end

function get_item_type(itemname)
	return(string.match(itemname, "(.+) .+"))
end

function get_button_row(buttonname)
	return(tonumber(string.match(buttonname, "Button (%d)%-%d")))
end

function get_button_col(buttonname)
	return(tonumber(string.match(buttonname, "Button %d%-(%d)")))
end

function get_a_button_num(buttonname)
	return(tonumber(string.match(buttonname, "Button A(%d)")))
end

function is_up_udupbutton(buttonname, itemname)
	local upbutton

	local udtype,first,second = string.match(itemname, "UD(.)Button (...)_(...)")

	if(udtype == 'V') then
		if(get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "inverted")) then
			upbutton = second
		else
			upbutton = first
		end
	else
		if(get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "inverted")) then
			upbutton = first
		else
			upbutton = second
		end
	end

	return(buttonname == "Button "..upbutton)
end

function fader_nearby_down(buttonname)
	local row = tonumber(string.match(buttonname, "Button (%d)%-%d"))
	local col = tonumber(string.match(buttonname, "Button %d%-(%d)"))
	local upbutton = "Button "..(row+1).."-"..col
	local downbutton = "Button "..(row-1).."-"..col

	return(g_buttondown[upbutton] or g_buttondown[downbutton])
end

function fader_get_otherbutton(buttonname)
	local row = tonumber(string.match(buttonname, "Button (%d)%-%d"))
	local col = tonumber(string.match(buttonname, "Button %d%-(%d)"))
	local otherrow = 1
	if(row == 1) then
		otherrow = 8
	end
	return("Button "..otherrow.."-"..col)
end

function fader_already_down(buttonname)
	local row = tonumber(string.match(buttonname, "Button (%d)%-%d"))
	local otherbutton = fader_get_otherbutton(buttonname)

	if((row == 1) or (row == 8)) then
		return(g_buttondown[otherbutton])
	end
	return(nil)
end

function is_up_mfader(buttonname, itemname)
	local first = string.match(itemname, "MFader (...)")
	return(buttonname == "Button "..first)
end

function mfader_get_otherbutton(buttonname, itemname)
	local otherbutton
	local firstbutton = string.match(itemname, "MFader (...)")
	local row = string.match(itemname, "MFader (%d)%-%d")
	local col = string.match(itemname, "MFader %d%-(%d)")
	if(buttonname == "Button "..firstbutton) then
		otherbutton = "Button "..tostring(row+1).."-"..col
	else
		otherbutton = "Button "..firstbutton
	end
	return(otherbutton)
end

function mfader_already_down(buttonname, itemname)
	return(g_buttondown[mfader_get_otherbutton(buttonname, itemname)])
end

function ud_get_otherbutton(buttonname, itemname)
	local otherbutton
	local firstbutton, secondbutton = string.match(itemname, "UD.Button (...)_(...)")
	if(buttonname == "Button "..firstbutton) then
		otherbutton = "Button "..secondbutton
	else
		otherbutton = "Button "..firstbutton
	end
	return(otherbutton)
end

function ud_already_down(buttonname, itemname)
	return(g_buttondown[ud_get_otherbutton(buttonname, itemname)])
end
function init_buttons()
	for buttonname,buttonmidi in pairs(buttons) do
		table.insert(items, {name = buttonname, input = "button", output="value", modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		table.insert(inputs, {pattern=buttonmidi .. " ?<???x>", name=buttonname})
	end
end

function init_udbuttons()
	for row=1,8 do
		for column=1,8,2 do
			table.insert(items, {name = "UDHButton "..row.."-"..column.."_"..row.."-"..tostring(column+1), input = "delta", output="value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		end
	end

	for row=1,8,2 do
		for column=1,8 do
			table.insert(items, {name = "UDVButton "..row.."-"..column.."_"..tostring(row+1).."-"..column, input = "delta", output="value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		end
	end
end

function init_minifaders()
	for row=1,8,2 do
		for column=1,8 do
			table.insert(items, {name = "MFader "..row.."-"..column, input = "value", output="value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		end
	end
end

function init_sel()
	for sel=1,4 do
		for val=0,127 do
			table.insert(items, {name = "Sel"..sel.."_"..val, input= "button", output = "value", min = 0, max = 1})
		end
	end
end

function init_itemsindex()
	for index,item in ipairs(items) do
		itemsindex[item.name] = index
		itemsmodeindex[item.name] = {}
		if(item.modes ~= nil) then
			for mindex,mode in ipairs(item.modes) do
				itemsmodeindex[item.name][mode] = mindex
			end
		end
	end
end

function init_miditobutton()
	for button,midi in pairs(buttons) do
		midi_to_button[midi] = button
	end
end

function handle_input_sel(event)
	for selnum=1,g_selcount do
		if(g_sel[selnum] ~= nil) then
			local msg = { time_stamp = event.time_stamp, item = itemsindex["Sel"..selnum.."_"..g_sel[selnum]], value = 1 }
			remote.handle_input(msg)
			g_sel[selnum] = nil
			g_updateall = true
		end
	end
end

function handle_input_mfader(event)
	local updatetime = remote.get_time_ms()
	local timediff = updatetime - g_mfaderlastupdate
	for buttonname, velocity in pairs(g_mfaderbuttons) do
		if(velocity > 0) then
			local itemname = get_item_by_button(buttonname)
			local maxvalue = get_item_bvmap(itemname)[2]
			-- This is number of seconds to go from 0 to 127 at minimum velocity
			local divider=100
			local change = (velocity*timediff*maxvalue)/(divider*1000)
			local value
			if(change < 1) then
				return
			end
			local cvalue = remote.get_item_value(itemsindex[itemname])
			if(velocity >= 0x7f) then
				if(is_up_mfader(buttonname, itemname)) then
					value = maxvalue
				else
					value = 0
				end
			elseif(is_up_mfader(buttonname, itemname)) then
				value = cvalue + change
			else
				value = cvalue - change
			end
			if(value > maxvalue) then
				value = maxvalue
			elseif(value < 0) then
				value = 0
			end
			if(value == maxvalue or value == 0) then
				g_mfaderlastupdate = nil
				g_mfaderbuttons[buttonname] = nil
			end
			local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
			remote.handle_input(msg)
		end
	end
	g_mfaderlastupdate = updatetime
end

function handle_input_repeatud(event)
	local updatetime = remote.get_time_ms()
	local timediff = updatetime - g_repeatudlastupdate

	local firstwait = 500 -- 1s
	local wait = 200 -- 0.2s/step after 0.5
	local finalwait = 5 -- 0.01s/step after 0.2*10 + 0.5 = 2.5s

	for buttonname, count in pairs(g_repeatudbuttons) do
		if((count == 1 and timediff > firstwait) or (count > 1 and timediff > wait) or (count > 8 and timediff > finalwait)) then
			g_repeatudbuttons[buttonname] = count + 1
			local itemname = get_item_by_button(buttonname)
			local value
			if(is_up_udupbutton(buttonname, itemname)) then
				value = 1
			else
				value = -1
			end
			local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
			remote.handle_input(msg)
			g_repeatudlastupdate = updatetime
		end
	end
end

function handle_input_velofader(event)
	local updatetime = remote.get_time_ms()
	local timediff = updatetime - g_velofaderlastupdate
	for buttonname, velocity in pairs(g_velofaderbuttons) do
		if(velocity > 0) then
			local itemname = get_item_by_button(buttonname)
			local row = get_button_row(buttonname)
			local col = get_button_col(buttonname)
			local targetvalue = get_item_bvmap(itemname)[row]
			local maxvalue = get_item_bvmap(itemname)[1]
			local value = 0
			if(string.find(itemname, "Knob H%d")) then
				targetvalue = get_item_bvmap(itemname)[9-col]
			end
			if(string.find(itemname, "Drawbar %d")) then
				targetvalue = get_item_bvmap(itemname)[9-row]
			end
			local cvalue = remote.get_item_value(itemsindex[itemname])
			-- This is number of seconds to go from 0 to 127 at minimum velocity
			local divider=200
			local change = (velocity*timediff*maxvalue)/(divider*1000)
			if(change < 1) then
				return
			end
			if(velocity >= 0x7f) then
				value = targetvalue
				g_velofaderbuttons[buttonname] = nil
			elseif(cvalue < targetvalue) then
				value = cvalue + change
				if(value >= targetvalue) then
					value = targetvalue
					g_velofaderbuttons[buttonname] = nil
				end
			elseif(cvalue > targetvalue) then
				value = cvalue - change
				if(value <= targetvalue) then
					value = targetvalue
					g_velofaderbuttons[buttonname] = nil
				end
			end
			if(cvalue == targetvalue) then
				value = cvalue
			end
			local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
			remote.handle_input(msg)
		end
	end
	g_velofaderlastupdate = updatetime
end

function handle_input_select(event)
	for itemname,value in pairs(g_select) do
		local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
		remote.handle_input(msg)
		g_select[itemname] = nil
	end
end

function handle_input_scrollend(event)
	local msg_scrollend = remote.match_midi(MIDI_IN_SCROLLEND, event)
	if(msg_scrollend ~= nil) then
		g_scrolling = false
		g_updateall = true
		return true
	end
end

function handle_input_devices(event, button)
	if(g_scopetext == "Kong" and get_current_page() == "Main") then
		local buttonname = get_button_name(button)
		local padnote = button_to_padnote[buttonname]
		if(padnote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = 1, value = 1, note = padnote, velocity = button.z })
			return true
		end
	end
end

function handle_input_keyboard_at(event, button)
	local velocity = get_veloctity(button.z)
	if(get_current_page() == "Keyboard" and get_current_kbdpage() == "Kbd") then
		local buttonname = get_button_name(button)
		local keynote = button_to_keynote[buttonname]
		if(keynote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = itemsindex['Aftertouch'], value = velocity })
			return true
		end
	end
end

function handle_input_keyboard(event, button)
	local velocity = get_veloctity(button.z)
	if(get_current_page() == "Keyboard" and get_current_kbdpage() == "Kbd") then
		local buttonname = get_button_name(button)
		local keynote = button_to_keynote[buttonname]
		if(keynote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = 1, value = 1, note = (keynote+12*g_basekey), velocity = velocity })
			return true
		end
	elseif(get_current_page() == "Keyboard" and get_current_kbdpage() == "Drum") then
		local buttonname = get_button_name(button)
		local padnote = button_to_fullpadnote[buttonname]
		if(padnote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = 1, value = 1, note = padnote, velocity = velocity })
			return true
		end
	end
end

function handle_input_item(event, button)
	local buttonname = get_button_name(button)
	local row = get_button_row(buttonname)
	local col = get_button_col(buttonname)
	local itemname = get_item_by_button(buttonname)
	if(button.z > 0) then
		g_buttondown[buttonname] = button.z
		if(buttonname ~= itemname) then
			local itemtype = get_item_type(itemname)
			if(itemname == "ARadioButton2" or itemname == "ARadioButton3" or itemname == "ARadioButton4") then
				local num = get_a_button_num(buttonname)
				if(get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "inverted")) then
					num = tonumber(string.match(itemname, "ARadioButton(%d)"))-num+1
				end
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = num-1 }
				remote.handle_input(msg)
			elseif(itemname == "EFSButton") then
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = 3-row }
				remote.handle_input(msg)
			elseif(itemtype == "Fader" or itemtype == "BigFader" or itemtype == "Drawbar") then
				if(fader_already_down(buttonname) ~= nil) then
					local value
					local defaultvalue = get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "defaultvalue")
					g_buttondown[buttonname] = nil
					g_buttondown[fader_get_otherbutton(buttonname)] = nil
					g_velofaderbuttons[buttonname] = nil
					g_velofaderbuttons[fader_get_otherbutton(buttonname)] = nil
					if(defaultvalue ~= nil) then
						value = defaultvalue
					else
						value = 64
					end
					local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
					remote.handle_input(msg)
				else
					if(fader_nearby_down(buttonname) ~= nil) then
						local value = get_item_bvmap(itemname)[row]
						if(string.find(itemname, "Drawbar %d")) then
							value = get_item_bvmap(itemname)[9-row]
						end
						local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
						remote.handle_input(msg)
					else
						g_velofaderbuttons[buttonname] = button.z
					end
				end
				return(true)
			elseif(itemtype == "Knob") then
				local oldvalue = remote.get_item_value(itemsindex[itemname])
				local value

				if(string.find(itemname, "Knob H%d")) then
					if((oldvalue > 64 and col == 4) or (oldvalue < 64 and col == 5)) then
						value = 64
						local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
						remote.handle_input(msg)
						return(true)
					end
				else
					if((oldvalue > 64 and row == 5) or (oldvalue < 64 and row == 4)) then
						value = 64
						local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
						remote.handle_input(msg)
						return(true)
					end
				end
				if(fader_nearby_down(buttonname) ~= nil) then
					value = get_item_bvmap(itemname)[row]
					local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
					remote.handle_input(msg)
				else
					g_velofaderbuttons[buttonname] = button.z
				end
				return(true)
			elseif(itemtype == "UDVButton" or itemtype == "UDHButton") then
				local value
				local defaultvalue = get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "defaultvalue")
				if(ud_already_down(buttonname, itemname) and defaultvalue ~= -1) then
					g_repeatudbuttons[buttonname] = nil
					g_repeatudbuttons[ud_get_otherbutton(buttonname, itemname)] = nil
					if(defaultvalue ~= nil) then
						value = defaultvalue
					else
						value = 64
					end
					if(defaultvalue ~= -1) then
						local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = -127 }
						remote.handle_input(msg)
						msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
						remote.handle_input(msg)
					end
					return(true)
				else
					g_repeatudbuttons[buttonname] = 1
					g_repeatudlastupdate = remote.get_time_ms()
					if(is_up_udupbutton(buttonname, itemname)) then
						value = 1
					else
						value = -1
					end
				end
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
				remote.handle_input(msg)
				return(true)
			elseif(itemtype == "MFader") then
				if(mfader_already_down(buttonname, itemname)) then
					local value
					local defaultvalue = get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "defaultvalue")
					g_buttondown[buttonname] = nil
					g_buttondown[mfader_get_otherbutton(buttonname, itemname)] = nil
					g_mfaderbuttons[buttonname] = nil
					g_mfaderbuttons[mfader_get_otherbutton(buttonname, itemname)] = nil
					if(defaultvalue ~= nil) then
						value = defaultvalue
					else
						value = 64
					end
					local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
					remote.handle_input(msg)
				else
					g_mfaderbuttons[buttonname] = button.z
				end
			end
		end
	else
		g_buttondown[buttonname] = nil
		g_velofaderbuttons[buttonname] = nil
		g_mfaderbuttons[buttonname] = nil
		g_repeatudbuttons[buttonname] = nil
		g_updateall = true
		local itemtype = get_item_type(itemname)
		if(itemtype == "Knob") then
			if(get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "resetonrel")) then
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = 64 }
				remote.handle_input(msg)
				return true
			end
		end
	end
end

function handle_input_aftertouch(button)
	local buttonname = get_button_name(button)
	local itemname = get_item_by_button(buttonname)

	if(buttonname ~= itemname) then
		local itemtype = get_item_type(itemname)
		if(itemtype == "Fader" or itemtype == "BigFader" or itemtype == "Drawbar" or itemtype == "Knob") then
			if(g_buttondown[buttonname] ~= nil) then
				if(button.z > 0) then
					for bn, v in pairs(g_velofaderbuttons) do
						if(v ~= nil and buttonname == bn) then
							g_velofaderbuttons[buttonname] = button.z
						end
					end
				end
			end
			return(true)
		end
		if(itemtype == "MFader") then
			if(g_buttondown[buttonname] ~= nil) then
				if(button.z > 0) then
					for bn, v in pairs(g_mfaderbuttons) do
						if(v ~= nil and buttonname == bn) then
							g_mfaderbuttons[buttonname] = button.z
						end
					end
				end
			end
			return(true)
		end
	end
end

function handle_input_helpmode(button)
	if(button.z == 0) then
		g_helpmode = false
		g_stopflashing = true
		g_scrollcolor = S_RED
		g_updateall = true
		local buttonname = get_button_name(button)
		local itemname = get_item_by_button(buttonname)

		if(itemname == "Button C1" or itemname == "Button C2") then
			g_scrolltext = g_scopetext
		elseif(itemname == "Button C3" or itemname == "Button C4") then
			g_scrolltext = remote.get_item_text_value(itemsindex["PatchName"])
		elseif(itemname == "Button C7") then
			g_scrolltext = "Page: "..get_current_page()
		-- elseif(itemname == "Button D8") then
			-- g_scrolltext = get_current_docpage()
		elseif(itemname == "Button C8") then
			g_valuemode = true
			g_startflashing = true
		else
			g_scrolltext = remote.get_item_name(itemsindex[itemname])
		end
		if(g_scrolltext == "") then
			g_scrolltext = get_item_conf_map_field(g_colorscheme, get_current_page(), itemname, "helptext")
			if(g_scrolltext == nil) then
				g_scrolltext = "Unknown: "..itemname
			end
		end
		return true
	end
end

function handle_input_valuemode(button)
	if(button.z == 0) then
		g_valuemode = false
		g_stopflashing = true
		g_scrollcolor = S_YELLOW
		g_updateall = true
		local buttonname = get_button_name(button)
		local itemname = get_item_by_button(buttonname)
		if(itemname == "Button C1" or itemname == "Button C2") then
			g_scrolltext = remote.get_item_text_value(itemsindex["DeviceName"])
		elseif(itemname == "Button C7") then
			g_scrolltext = "SubPage: "..get_current_subpage()
		elseif(itemname == "Button C8") then
			return true
		else
			local value = tostring(remote.get_item_value(itemsindex[itemname]))
			local textvalue = remote.get_item_text_value(itemsindex[itemname])
			g_scrolltext = value..", "..textvalue
		end
		if(g_scrolltext == "") then
			g_scrolltext = "Unknown"
		end
		return true
	end
end

function handle_input_starthelpmode(button)
	local buttonname = get_button_name(button)
	if(buttonname == 'Button C8') then
		g_helpmode = true
		g_startflashing = true
		g_updateall = true
		return true
	end
end

function handle_input_setveltomax(event, button)
	-- Change all remaining button input to velocity 127
	if(button.z > 0 ) then
		local midi = string.format("%02x %02x", button.x, button.y)
		local item = itemsindex[midi_to_button[midi]]
		local msg = { time_stamp = event.time_stamp, item = item, value = 1, velocity = 127 }
		remote.handle_input(msg)
		return true
	end
end
function handle_input_buttonendscroll(button)
	if(g_scrolling and button.z) then
		g_endscroll = true
		return false
	end
end
function handle_changed_sel(citemindex, citemname)
	for s=1,g_selcount do
		if(remote.get_item_mode(citemindex) == itemsmodeindex[citemname]["SEL"..s]) then
			g_sel[s] = tonumber(remote.get_item_value(citemindex))
		end
	end
end

function handle_changed_devicescope(citemname)
	if(string.match(citemname, "DeviceScope")) then
		-- g_scrolltext = remote.get_item_text_value(itemsindex["DeviceScope"])
		g_updateall = true
		if(remote.is_item_enabled(itemsindex["DeviceScope"])) then
			local newscope = remote.get_item_text_value(itemsindex["DeviceScope"])
			g_scopetext = newscope
			g_colorscheme = g_scopetext
		else
			local newscope = ""
			g_scopetext = newscope
		end
	end
end


function handle_changed_playingstep(citemname)
	if(string.match(citemname, "PlayingStep")) then
		if(g_scopetext == "Redrum") then
			local playingstep = tonumber(remote.get_item_text_value(itemsindex["PlayingStep"]))
			local editsteps = math.floor(remote.get_item_value(itemsindex["UDVButton 5-4_6-4"])/42)+1
			local cstep = (playingstep-1)%16
			local cpage = math.floor(((playingstep-1))/16)+1
			local crowstep = (cstep)%8+1
			local crow = math.floor((cstep)/8)+1+6

			if(editsteps == cpage) then
				g_playingbutton = "Button "..tostring(crow).."-"..tostring(crowstep)
				g_updateall = true
			else
				g_playingbutton = "Other page"
			end
		end
		if(g_scopetext == "Thor") then
			local playingstep = tonumber(remote.get_item_text_value(itemsindex["PlayingStep"]))
			local crowstep = (playingstep)%8+1
			local crow = math.floor((playingstep)/8)+1

			g_playingbutton = "Button "..tostring(crow).."-"..tostring(crowstep)
			g_updateall = true
		end
	end
end

function handle_changed_pagename(citemname)
	if(string.match(citemname, "PageName")) then
		g_updateall = true
		if(g_scopetext == "Europa") then
			local ceng = tonumber(string.match(get_current_page(), "Eng (%d)"))
			if(ceng ~= nil) then
				g_select["EngineSelect"] = ceng-1
			end

			local clfo = tonumber(string.match(get_current_page(), "LFO (%d)"))
			if(clfo ~= nil) then
				g_select["LFOSelect"] = clfo-1
			end

			local cenv = tonumber(string.match(get_current_page(), "Env (%d)"))
			if(cenv ~= nil) then
				g_select["EnvSelect"] = cenv-1
			end

			if(string.match(get_current_page(), "Phaser")) then
				g_select["EffectSelect"] = 4
			elseif(string.match(get_current_page(), "Dist")) then
				g_select["EffectSelect"] = 2
			elseif(string.match(get_current_page(), "Eq")) then
				g_select["EffectSelect"] = 6
			elseif(string.match(get_current_page(), "Delay")) then
				g_select["EffectSelect"] = 1
			elseif(string.match(get_current_page(), "Comp")) then
				g_select["EffectSelect"] = 3
			elseif(string.match(get_current_page(), "Reverb")) then
				g_select["EffectSelect"] = 0
			end
		end
		if(g_scopetext == "Grain") then
			local ceng = tonumber(string.match(get_current_page(), "Eng (%d)"))
			if(ceng ~= nil) then
				g_select["EngineSelect"] = ceng-1
			end

			local clfo = tonumber(string.match(get_current_page(), "LFO (%d)"))
			if(clfo ~= nil) then
				g_select["LFOSelect"] = clfo-1
			end

			local cenv = tonumber(string.match(get_current_page(), "Env (%d)"))
			if(cenv ~= nil) then
				g_select["EnvSelect"] = cenv-1
			end

			if(string.match(get_current_page(), "Phaser")) then
				g_select["EffectSelect"] = 4
			elseif(string.match(get_current_page(), "Dist")) then
				g_select["EffectSelect"] = 2
			elseif(string.match(get_current_page(), "Eq")) then
				g_select["EffectSelect"] = 6
			elseif(string.match(get_current_page(), "Delay")) then
				g_select["EffectSelect"] = 1
			elseif(string.match(get_current_page(), "Comp")) then
				g_select["EffectSelect"] = 3
			elseif(string.match(get_current_page(), "Reverb")) then
				g_select["EffectSelect"] = 0
			end
		end
		if(g_scopetext == "RV7000 Advanced Reverb") then
			if(string.match(get_current_page(), "Reverb")) then
				g_select["EditSelect"] = 0
			elseif(string.match(get_current_page(), "Eq")) then
				g_select["EditSelect"] = 1
			elseif(string.match(get_current_page(), "Gate")) then
				g_select["EditSelect"] = 2
			end
		end
	end
end

function handle_changed_custom(citemname)
	local esstr = string.match(citemname, "PW ES (.*)")
	if(esstr ~= nil) then
		g_select["PWSelect"] = g_esmap[esstr]
	end
end

function handle_changed_subpagename(citemname)
	if(string.match(citemname, "SubPageName")) then
		g_updateall = true
	end
end

function handle_changed_basekey(citemname)
	if(string.match(citemname, "BaseKey")) then
		local newbasekey = tonumber(remote.get_item_text_value(itemsindex["BaseKey"]))
		if(newbasekey ~= nil) then
			g_basekey = newbasekey
		end
	end
end
function deliver_midi_scrolltext(ret_events)
	if(g_scrolltext ~= nil) then
		table.insert(ret_events, remote.make_midi(gen_scroll_string(g_scrolltext, g_scrollcolor, g_scrollspeed)))
		g_scrolling = true
		-- g_scrolltime = remote.get_time_ms()
		g_scrolltext = nil
		g_scrollcolor = g_scrollcolor_default
		g_scrollspeed = g_scrollspeed_default
	end
end

function deliver_midi_endscroll(ret_events)
	if(g_endscroll) then
		table.insert(ret_events, remote.make_midi(MIDI_OUT_ENDSCROLL))
		g_endscroll = false
		g_scrolling = false
		g_updateall = true
	end
end

function deliver_midi_sel(ret_events)
	-- If sel* is updated trigger midi event by sending get version sysex
	for s=1,g_selcount do
		if(g_sel[s] ~= nil) then
			table.insert(ret_events, remote.make_midi(MIDI_OUT_GETVERSION))
		end
	end
end

function deliver_midi_mfader(ret_events)
	for buttonname, velocity in pairs(g_mfaderbuttons) do
		if(buttonname ~= nil and  velocity ~= nil) then
			table.insert(ret_events, remote.make_midi(MIDI_OUT_GETVERSION))
			return
		end
	end
end

function deliver_midi_velofader(ret_events)
	for buttonname, velocity in pairs(g_velofaderbuttons) do
		if(buttonname ~= nil and  velocity ~= nil) then
			table.insert(ret_events, remote.make_midi(MIDI_OUT_GETVERSION))
			return
		end
	end
end

function deliver_midi_repeatud(ret_events)
	for buttonname, velocity in pairs(g_repeatudbuttons) do
		if(buttonname ~= nil and velocity ~= nil) then
			table.insert(ret_events, remote.make_midi(MIDI_OUT_GETVERSION))
			return
		end
	end
end
function deliver_midi_buttons(ret_events)
	if(g_lightshow == 0 and not g_flashing and not g_scrolling) then
		if(g_updateall) then
			local gridmidimsg = "f0 00 20 29 02 10 0f 00"
			for row=9,0,-1 do
				for column=0,9 do
					local buttonname
					if(row == 0) then
						buttonname = "Button C"..tostring(column)
					elseif(row == 9) then
						buttonname = "Button A"..tostring(column)
					elseif(column == 0) then
						buttonname = "Button B"..tostring(row)
					elseif(column == 9) then
						buttonname = "Button D"..tostring(row)
					else
						buttonname = "Button "..tostring(row).."-"..tostring(column)
					end
					local itemname = get_item_by_button(buttonname)
					local color = get_button_color(g_colorscheme, itemname, buttonname)
					if(string.match(itemname, "Button C8") and g_helpmode) then
						color = RED
					elseif(string.match(itemname, "Button C8") and g_valuemode) then
						color = YELLOW
					end

					if(string.match(itemname, "Button C5") and (g_debugupdate ~= 0)) then
						if(g_debugupdate == 1) then
							g_debugupdate = 2
							color = RED
						else
							g_debugupdate = 1
							color = BLUE
						end
					end

					if(color == nil) then
						error(string.format("Undefined color, device: %s page: %s item: %s", g_colorscheme, get_current_page(), itemname))
					end

					gridmidimsg = gridmidimsg.." "..get_rgb_midi(color)
				end
			end
			gridmidimsg = gridmidimsg.." f7"
			table.insert(ret_events, remote.make_midi(gridmidimsg))
			deliver_midi_sideled(ret_events)
			g_updateall = false
		end
	end
end

function deliver_midi_sideled(ret_events)
	-- Side LED
	local sidecolor = get_rgb_midi(get_button_color(g_colorscheme, "Side LED", "Side LED"))
	if(g_helpmode) then
		sidecolor = get_rgb_midi(RED)
	elseif(g_valuemode) then
		sidecolor = get_rgb_midi(YELLOW)
	end
	table.insert(ret_events, remote.make_midi(string.format("f0 00 20 29 02 10 0b 63 %s f7", sidecolor)))
end

function deliver_midi_startflashing(ret_events)
	if(g_startflashing) then
		local flashmidi = "f0 00 20 29 02 10 23"
		local flashcolor = S_NOCOLOR
		for buttonname,buttonmidi in pairs(buttons) do
			local shortmidi = string.match(buttonmidi, ".. (..)")
			if(not string.match(buttonname, "Button C8") and not string.match(buttonname, "Button [AC][09]")) then
				flashmidi = string.format("%s %s %02x", flashmidi, shortmidi, flashcolor)
			end
		end
		flashmidi = flashmidi.." f7"
		table.insert(ret_events, remote.make_midi(flashmidi))
		g_startflashing = false
		g_flashing = true
	end
end
function remote_init()
	init_buttons()
	init_udbuttons()
	init_minifaders()
	init_sel()
	init_itemsindex()
	init_miditobutton()

	remote.define_items(items)
	remote.define_auto_inputs(inputs)
end

function remote_release_from_use()
	local ret_events={}

	return ret_events;
end

function remote_prepare_for_use()
	local ret_events={}

	table.insert(ret_events, remote.make_midi(MIDI_OUT_PROGLAYOUT))

	return ret_events;
end

function remote_set_state(changed_items)
	for i,citemindex in ipairs(changed_items)do
		local citemname = items[citemindex].name

		g_updateall = true

		if(i ~= nil and citemname ~= nil) then
			handle_changed_sel(citemindex, citemname)
			handle_changed_devicescope(citemname)
			handle_changed_playingstep(citemname)
			handle_changed_pagename(citemname)
			handle_changed_subpagename(citemname)
			handle_changed_basekey(citemname)
			handle_changed_custom(citemname)
		end
	end
end

function remote_deliver_midi(maxbytes, port)
	local ret_events = {}

	if(maxbytes == nil) then
		error("Maxbytes is nil")
	end

	if(port == nil) then
		error("Port is nil")
	end

	if(g_stopflashing) then
		g_stopflashing = false
		g_flashing = false
		g_updateall = true
	end

	deliver_midi_buttons(ret_events)
	deliver_midi_startflashing(ret_events)
	deliver_midi_scrolltext(ret_events)
	deliver_midi_endscroll(ret_events)
	deliver_midi_sel(ret_events)
	deliver_midi_velofader(ret_events)
	deliver_midi_mfader(ret_events)
	deliver_midi_repeatud(ret_events)

	return ret_events
end

function remote_process_midi(event)
	handle_input_sel(event)

	handle_input_select(event)

	handle_input_velofader(event)
	handle_input_mfader(event)
	handle_input_repeatud(event)

	if(handle_input_scrollend(event)) then
		return(true)
	end

	local button = remote.match_midi("xx yy zz", event)

	if(isbutton(button)) then
		if(g_helpmode) then
			if(handle_input_helpmode(button)) then
				return(true)
			end
		elseif(g_valuemode) then
			if(handle_input_valuemode(button)) then
				return(true)
			end
		else
			if(handle_input_buttonendscroll(button)) then
				return(true)
			end

			if(handle_input_devices(event, button)) then
				return(true)
			end

			if(handle_input_keyboard(event, button)) then
				return(true)
			end

			if(handle_input_item(event, button)) then
				return(true)
			end


			if(handle_input_setveltomax(event, button)) then
				return(true)
			end

			if(handle_input_starthelpmode(button)) then
				return(true)
			end

		end
	end

	if(isaftertouch(button)) then
		if(handle_input_keyboard_at(event, button)) then
			return(true)
		end

		if(handle_input_aftertouch(button)) then
			return(true)
		end
	end

	if(g_helpmode or g_valuemode) then
		return true
	end

	return false
end
function match_midi_events(mask,events)
	for i,event in ipairs(events) do
		local res=remote.match_midi(mask,event)
		if(res~=nil and i ~= nil) then
			return true
		end
	end
	return false
end

function remote_probe(manufacturer,model,prober)
	local dev_inq_request={remote.make_midi(MIDI_OUT_DEVICEINQ)}
	local dev_inq_response=string.format("%s %02x 00 ?? ?? ?? ?? ?? ?? f7", MIDI_IN_DEVICEINQ_HEAD, DEVICE_ID)
	local prog_layout_request={remote.make_midi(MIDI_OUT_PROGLAYOUT)}

	if(manufacturer == nil) then
		error("Manufacturer is nil")
	end

	if(model == nil) then
		error("Model is nil")
	end

	-- local LIVEPORT=1
	-- local STANDALONEPORT=2

	local results={}
	local lp_ports={}
	local standalone_ports={}

	for outPortIndex = 1,prober.out_ports do
		prober.midi_send_function(outPortIndex,dev_inq_request)
		prober.wait_function(50)
		for inPortIndex = 1,prober.in_ports do
			local events=prober.midi_receive_function(inPortIndex)
			if match_midi_events(dev_inq_response,events) then
				table.insert(lp_ports,outPortIndex)
			end
		end
	end

	for i,portnum in pairs(lp_ports) do
		prober.midi_send_function(portnum,prog_layout_request)
		prober.wait_function(50)
		for j,inportnum in pairs(lp_ports) do
			local events=prober.midi_receive_function(inportnum)

			if(match_midi_events(MIDI_IN_PROGLAYOUT_STATUS,events) and i ~=nil and j ~= nil) then
				table.insert(standalone_ports,portnum)
			end
		end
	end

	for i,portnum in pairs(standalone_ports) do
		if(i ~=nil and portnum ~= nil) then
			table.insert(results, { in_ports={portnum}, out_ports={portnum} })
		end
	end

	return results
end
